/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.shell.TrayIcon;
import com.jniwrapper.win32.shell.TrayIconListener;
import com.jniwrapper.win32.shell.TrayMessage;
import com.jniwrapper.win32.ui.AWTWindowDecorator;
import java.awt.Component;
import java.awt.Frame;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JWindow;

public class SampleTrayApp {
    private static Window _invoker;
    private static TrayIcon _trayIcon;
    private static PopupMenu _popupMenu;
    private static final String MENU_ITEM_SHOW_STANDARD_ICON = "Show Stadard System Icon";
    private static final String MENU_ITEM_SHOW_CUSTOM_ICON = "Show Custom Icon";
    private static final String MENU_ITEM_SHOW_CALLOUT = "Show Tray Balloon";
    private static final String MENU_ITEM_HIDE_ICON = "Hide Tray Icon (hides tray icon for a second)";
    private static final String MENU_ITEM_EXIT = "Exit";

    public static void main(String[] args) {
        new Frame();
        _trayIcon = new TrayIcon(Icon.SystemIcon.BANG.getIcon());
        _trayIcon.setToolTip("Tray Tooltip");
        _trayIcon.addTrayListener(new TrayIconListener(){

            public void trayActionPerformed(long message, int x, int y) {
                if (message == 517L) {
                    SampleTrayApp.showPopup(x, y);
                } else if (message == 515L) {
                    _trayIcon.setIcon(Icon.SystemIcon.HAND.getIcon());
                } else if (message == 675L) {
                    System.out.println("Mouse leave event");
                } else if (message == 673L) {
                    System.out.println("Mouse hover event");
                }
            }
        });
        _popupMenu = new PopupMenu("My Menu");
        _popupMenu.add(MENU_ITEM_SHOW_STANDARD_ICON);
        _popupMenu.add(MENU_ITEM_SHOW_CUSTOM_ICON);
        _popupMenu.addSeparator();
        _popupMenu.add(MENU_ITEM_SHOW_CALLOUT);
        _popupMenu.addSeparator();
        _popupMenu.add(MENU_ITEM_HIDE_ICON);
        _popupMenu.addSeparator();
        _popupMenu.add(MENU_ITEM_EXIT);
        _popupMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(SampleTrayApp.MENU_ITEM_SHOW_STANDARD_ICON)) {
                    SampleTrayApp.changeIconToQuestion();
                }
                if (e.getActionCommand().equals(SampleTrayApp.MENU_ITEM_SHOW_CUSTOM_ICON)) {
                    SampleTrayApp.changeIconToCustom();
                }
                if (e.getActionCommand().equals(SampleTrayApp.MENU_ITEM_SHOW_CALLOUT)) {
                    SampleTrayApp.showCallout();
                }
                if (e.getActionCommand().equals(SampleTrayApp.MENU_ITEM_HIDE_ICON)) {
                    _trayIcon.setVisible(false);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    _trayIcon.setVisible(true);
                }
                if (e.getActionCommand().equals(SampleTrayApp.MENU_ITEM_EXIT)) {
                    SampleTrayApp.removeIcon();
                    System.exit(0);
                }
            }
        });
        SampleTrayApp.getInvokerWindow();
    }

    private static void showPopup(int x, int y) {
        Component invoker = SampleTrayApp.getInvokerWindow();
        _popupMenu.show(invoker, x, y);
    }

    private static Component getInvokerWindow() {
        if (_invoker == null) {
            _invoker = new JWindow();
            _invoker.setLocation(0, 0);
            _invoker.setVisible(true);
            _invoker.add(_popupMenu);
            AWTWindowDecorator windowDecorator = new AWTWindowDecorator(_invoker);
            long windowStyle = windowDecorator.getWindowStyle();
            windowDecorator.setWindowStyle(windowStyle &= 0xFFFFFFFFEFFFFFFFL);
        }
        return _invoker;
    }

    private static void changeIconToQuestion() {
        _trayIcon.setIcon(Icon.SystemIcon.QUES.getIcon());
    }

    private static void changeIconToCustom() {
        Icon customIcon = new Icon();
        customIcon.loadFromFile("jniwrapper.ico");
        _trayIcon.setIcon(customIcon);
    }

    private static void showCallout() {
        _trayIcon.showMessage((TrayMessage)new TrayMessage.Warning("Tray Balloon", "This program demonstrates the WinPack for JNIWrapper library abilities:\n\t - tray icon\n\t - menu for tray icon\n\t - balloons from tray icon\netc."));
    }

    private static void removeIcon() {
        _trayIcon.dispose();
    }

    static {
        DefaultLibraryLoader.getInstance().addPath(new File("bin"));
        MENU_ITEM_SHOW_STANDARD_ICON = MENU_ITEM_SHOW_STANDARD_ICON;
        MENU_ITEM_SHOW_CUSTOM_ICON = MENU_ITEM_SHOW_CUSTOM_ICON;
        MENU_ITEM_SHOW_CALLOUT = MENU_ITEM_SHOW_CALLOUT;
        MENU_ITEM_HIDE_ICON = MENU_ITEM_HIDE_ICON;
        MENU_ITEM_EXIT = MENU_ITEM_EXIT;
    }
}

