/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.io.FileSystemEvent;
import com.jniwrapper.win32.io.FileSystemEventListener;
import com.jniwrapper.win32.io.FileSystemException;
import com.jniwrapper.win32.io.FileSystemWatcher;
import com.jniwrapper.win32.samples.demo.LazyPanel;
import com.jniwrapper.win32.ui.controls.SelectFolderField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class FileSystemWatcherSample
extends LazyPanel
implements ActionListener,
FileSystemEventListener,
PropertyChangeListener {
    static final String[] ACTION_NAMES = new String[]{"added", "removed", "modified", "renamed"};
    static final String MESSAGE_TEMPLATE = "File ''{0}'' was {1}";
    static final String SHORT_DATE_FORMAT = "HH:mm:ss";
    static final String LONG_DATE_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private Vector _events;
    private JLabel lblAdvisoryText;
    private JLabel lblSelectedFolderCaption;
    private SelectFolderField _selectFolderField;
    private JCheckBox chkWatchSubtree;
    private JCheckBox chkChangeFileName;
    private JCheckBox chkChangeDirName;
    private JCheckBox chkChangeAttributes;
    private JCheckBox chkChangeSize;
    private JCheckBox chkChangeLastWrite;
    private JList lstEvents;
    private JLabel lblEvents;
    private FileSystemWatcher _fileSystemWatcher;
    private JButton btnStart;
    private JButton btnStop;

    public FileSystemWatcherSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        this.lblAdvisoryText = new JLabel("This sample demonstrates FileSystemWatcher class features.");
        this.lblSelectedFolderCaption = new JLabel("Watching Folder:");
        this.chkWatchSubtree = new JCheckBox("Watch Subtree");
        this.chkChangeFileName = new JCheckBox("Watch File Name Change", true);
        this.chkChangeDirName = new JCheckBox("Watch Dir Name Change", true);
        this.chkChangeAttributes = new JCheckBox("Watch Attributes Change", true);
        this.chkChangeSize = new JCheckBox("Watch Size Change", true);
        this.chkChangeLastWrite = new JCheckBox("Watch Last Write Change", true);
        this._selectFolderField = new SelectFolderField();
        this._selectFolderField.addPropertyChangeListener("folder", (PropertyChangeListener)this);
        this._events = new Vector();
        this.lblEvents = new JLabel("File System Events:");
        this.lstEvents = new JList(this._events);
        this.btnStart = new JButton("Start");
        this.btnStart.setEnabled(false);
        this.btnStart.addActionListener(this);
        this.btnStop = new JButton("Stop");
        this.btnStop.setEnabled(false);
        this.btnStop.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lblSelectedFolderCaption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._selectFolderField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.chkWatchSubtree, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 0), 0, 0));
        this.add((Component)this.chkChangeFileName, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 10), 0, 0));
        this.add((Component)this.chkChangeDirName, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 0), 0, 0));
        this.add((Component)this.chkChangeAttributes, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 10), 0, 0));
        this.add((Component)this.chkChangeSize, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 0), 0, 0));
        this.add((Component)this.chkChangeLastWrite, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 10), 0, 0));
        this.add((Component)this.lblEvents, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        JScrollPane eventPane = new JScrollPane(this.lstEvents);
        Dimension preferredSize = new Dimension(200, 100);
        eventPane.setPreferredSize(preferredSize);
        eventPane.setMinimumSize(preferredSize);
        this.add((Component)eventPane, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.btnStart);
        buttonsPanel.add(this.btnStop);
        this.add((Component)buttonsPanel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        super.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnStart)) {
            this.startWatching();
        } else if (e.getSource().equals(this.btnStop)) {
            this.stopWatching();
        }
    }

    private void startWatching() {
        this._events.clear();
        this._events.add("Started at " + this.getDateTime(true));
        this.lstEvents.updateUI();
        this._fileSystemWatcher = new FileSystemWatcher(this._selectFolderField.getFolder(), this.chkWatchSubtree.isSelected());
        this._fileSystemWatcher.addFileSystemListener((FileSystemEventListener)this);
        FileSystemWatcher.WatcherOptions options = this._fileSystemWatcher.getOptions();
        options.setNotifyChangeAttributes(this.chkChangeAttributes.isSelected());
        options.setNotifyChangeDirName(this.chkChangeDirName.isSelected());
        options.setNotifyChangeFileName(this.chkChangeFileName.isSelected());
        options.setNotifyChangeSize(this.chkChangeSize.isSelected());
        options.setNotifyLastModified(this.chkChangeLastWrite.isSelected());
        this.btnStart.setEnabled(false);
        this.btnStop.setEnabled(true);
        try {
            this._fileSystemWatcher.start();
        }
        catch (FileSystemException e1) {
            e1.printStackTrace();
        }
    }

    private void stopWatching() {
        this._events.add("Stopped at " + this.getDateTime(true));
        this.lstEvents.updateUI();
        this.btnStart.setEnabled(true);
        this.btnStop.setEnabled(false);
        try {
            this._fileSystemWatcher.stop();
        }
        catch (FileSystemException e1) {
            e1.printStackTrace();
        }
    }

    public void deactivate() {
        if (this._fileSystemWatcher != null && this._fileSystemWatcher.isWatching()) {
            this.stopWatching();
        }
    }

    public void handle(FileSystemEvent event) {
        String actionName = ACTION_NAMES[event.getAction() - 1];
        String message = MessageFormat.format(MESSAGE_TEMPLATE, event.getFileInfo(), actionName);
        if (event.getAction() == 4) {
            message = message + " from '" + event.getOldFileInfo() + "'";
        }
        message = message + " at " + this.getDateTime(false);
        this._events.add(message);
        this.lstEvents.updateUI();
    }

    String getDateTime(boolean longFormat) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(longFormat ? LONG_DATE_FORMAT : SHORT_DATE_FORMAT);
        return dateFormat.format(new Date());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.btnStart.setEnabled(true);
    }

    static {
        MESSAGE_TEMPLATE = MESSAGE_TEMPLATE;
        SHORT_DATE_FORMAT = SHORT_DATE_FORMAT;
        LONG_DATE_FORMAT = LONG_DATE_FORMAT;
    }
}

