/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.UShortInt;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.Brush;
import com.jniwrapper.win32.gdi.ColorRef;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.gdi.PolyFillMode;
import com.jniwrapper.win32.gdi.Region;
import com.jniwrapper.win32.ui.User32;

public class DC
extends Handle {
    static final String FUNCTION_CREATE_COMPATIBLE_DC = "CreateCompatibleDC";
    static final String FUNCTION_SELECT_OBJECT = "SelectObject";
    static final String FUNCTION_BIT_BLT = "BitBlt";
    static final String FUNCTION_STRETCH_BLT = "StretchBlt";
    static final String FUNCTION_PAT_BLT = "PatBlt";
    static final String FUNCTION_DELETE_DC = "DeleteDC";
    static final String FUNCTION_SET_DC_BRUSH_COLOR = "SetDCBrushColor";
    static final String FUNCTION_SET_DC_PEN_COLOR = "SetDCPenColor";
    static final FunctionName FUNCTION_TEXT_OUT;
    static final String FUNCTION_DRAW_ICON_EX = "DrawIconEx";
    static final String FUNCTION_DRAW_ICON = "DrawIcon";
    static final String FUNCTION_SET_BACKGROUND_MODE = "SetBkMode";
    static final String FUNCTION_SET_TEXT_COLOR = "SetTextColor";
    static final String FUNCTION_SELECT_CLIP_RGN = "SelectClipRgn";
    static final String FUNCTION_FILL_REGION = "FillRgn";
    static final String FUNCTION_FRAME_RGN = "FrameRgn";
    static final String FUNCTION_GET_POLY_FILL_MODE = "GetPolyFillMode";
    static final String FUNCTION_INVERT_RGN = "InvertRgn";
    static final String FUNCTION_PAINT_RGN = "PaintRgn";
    static final String FUNCTION_SET_POLY_FILL_MODE = "SetPolyFillMode";
    static final String FUNCTION_GET_PIXEL = "GetPixel";

    public DC() {
    }

    public DC(long value) {
        super(value);
    }

    public static DC createCompatibleDC(DC dc) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_COMPATIBLE_DC);
        DC result = new DC();
        function.invoke((Parameter)result, (Parameter)(dc == null ? new Pointer(null, true) : dc));
        return result;
    }

    private long selectObject(GdiObject object) {
        Function function = Gdi32.get(FUNCTION_SELECT_OBJECT);
        Handle result = new Handle();
        function.invoke((Parameter)result, (Parameter)this, (Parameter)object);
        return result.getValue();
    }

    public Brush selectObject(Brush brush) {
        long handle = this.selectObject((GdiObject)brush);
        Brush result = new Brush(handle);
        return result;
    }

    public Bitmap selectObject(Bitmap bitmap) {
        long handle = this.selectObject((GdiObject)bitmap);
        Bitmap result = new Bitmap(handle);
        return result;
    }

    public Region selectObject(Region region) {
        long handle = this.selectObject((GdiObject)region);
        Region result = new Region(handle);
        return result;
    }

    public static void bitBlt(DC hdcDest, int xDest, int yDest, int width, int height, DC hdcSrc, int xSrc, int ySrc, RasterOperation rop) {
        Function function = Gdi32.get(FUNCTION_BIT_BLT);
        function.invoke(null, new Parameter[]{hdcDest, new Int((long)xDest), new Int((long)yDest), new Int((long)width), new Int((long)height), hdcSrc, new Int((long)xSrc), new Int((long)ySrc), new UInt32((long)rop.getValue())});
    }

    public static boolean stretchBlt(DC hDCDest, int xOriginDest, int yOriginDest, int widthDest, int heightDest, DC hDCSrc, int xOriginSrc, int yOriginSrc, int widthSrc, int heightSrc, RasterOperation rasterOp) {
        Int result = new Int();
        Function function = Gdi32.get(FUNCTION_STRETCH_BLT);
        function.invoke((Parameter)result, new Parameter[]{hDCDest, new Int((long)xOriginDest), new Int((long)yOriginDest), new Int((long)widthDest), new Int((long)heightDest), hDCSrc, new Int((long)xOriginSrc), new Int((long)yOriginSrc), new Int((long)widthSrc), new Int((long)heightSrc), new UInt32((long)rasterOp.getValue())});
        return result.getValue() > 0L;
    }

    public static boolean patBlt(DC hDC, int xLeft, int yLeft, int width, int height, long rastOps) {
        Int result = new Int();
        Function function = Gdi32.get(FUNCTION_PAT_BLT);
        function.invoke((Parameter)result, new Parameter[]{hDC, new Int((long)xLeft), new Int((long)yLeft), new Int((long)width), new Int((long)height), new UInt32(rastOps)});
        return result.getValue() > 0L;
    }

    public void release() {
        DC.deleteDC(this);
    }

    public static void deleteDC(DC dc) {
        Function function = Gdi32.get(FUNCTION_DELETE_DC);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)dc);
        if (result.getValue() == 0L) {
            throw new LastErrorException();
        }
    }

    public void textOut(int x, int y, String text) {
        Function function = Gdi32.get(FUNCTION_TEXT_OUT.toString());
        UShortInt returnValue = new UShortInt();
        function.invoke((Parameter)returnValue, new Parameter[]{this, new Int((long)x), new Int((long)y), Gdi32.getInstance().stringParam(text), new Int((long)text.length())});
        if (returnValue.getValue() == 0L) {
            throw new LastErrorException();
        }
    }

    public void drawIconEx(int x, int y, Icon icon, int width, int heght, int frameIndex, Handle bgBrush, int flags) {
        Function function = User32.getInstance().getFunction(FUNCTION_DRAW_ICON_EX);
        UShortInt returnValue = new UShortInt();
        function.invoke((Parameter)returnValue, new Parameter[]{this, new Int((long)x), new Int((long)y), icon, new Int((long)width), new Int((long)heght), new UInt((long)frameIndex), bgBrush, new UInt((long)flags)});
        if (returnValue.getValue() == 0L) {
            throw new LastErrorException();
        }
    }

    public boolean drawIcon(int x, int y, Icon icon) {
        Function function = User32.getInstance().getFunction(FUNCTION_DRAW_ICON);
        Bool result = new Bool();
        function.invoke((Parameter)result, (Parameter)this, (Parameter)new Int((long)x), (Parameter)new Int((long)y), (Parameter)icon);
        return result.getValue();
    }

    public void setBkMode(int bgMode) {
        Function function = Gdi32.get(FUNCTION_SET_BACKGROUND_MODE);
        UShortInt returnValue = new UShortInt();
        function.invoke((Parameter)returnValue, (Parameter)this, (Parameter)new Int((long)bgMode));
        if (returnValue.getValue() == 0L) {
            throw new LastErrorException();
        }
    }

    public void setTextColor(ColorRef color) {
        ColorRef returnValue = new ColorRef();
        Function function = Gdi32.get(FUNCTION_SET_TEXT_COLOR);
        function.invoke((Parameter)returnValue, (Parameter)this, (Parameter)color);
        if (returnValue.isInvalid()) {
            throw new LastErrorException("Error while changing text color");
        }
    }

    public void selectClipRgn(Region region) {
        Int resultRgnType = new Int();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_SELECT_CLIP_RGN);
        function.invoke((Parameter)resultRgnType, (Parameter)this, (Parameter)region);
        if (0L == resultRgnType.getValue()) {
            throw new LastErrorException("Failed to select region");
        }
    }

    public void fillRegion(Region region, Brush brush) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_FILL_REGION);
        function.invoke((Parameter)result, (Parameter)this, (Parameter)region, (Parameter)brush);
        if (!result.getValue()) {
            throw new LastErrorException("Failed to fill region");
        }
    }

    public void frameRegion(Region region, Brush brush, int width, int heigh) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_FRAME_RGN);
        function.invoke((Parameter)result, new Parameter[]{this, region, brush, new Int((long)width), new Int((long)heigh)});
        if (!result.getValue()) {
            throw new LastErrorException("Failed to frame region");
        }
    }

    public int getPolyFillMode() {
        Int result = new Int();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_GET_POLY_FILL_MODE);
        function.invoke((Parameter)result, (Parameter)this);
        return (int)result.getValue();
    }

    public boolean invertRegion(Region region) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_INVERT_RGN);
        function.invoke((Parameter)result, (Parameter)this, (Parameter)region);
        return result.getValue();
    }

    public boolean paintRegion(Region region) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_PAINT_RGN);
        function.invoke((Parameter)result, (Parameter)this, (Parameter)region);
        return result.getValue();
    }

    public void setPolyFillMode(PolyFillMode polyFillMode) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_SET_POLY_FILL_MODE);
        function.invoke(null, (Parameter)this, (Parameter)new Int((long)polyFillMode.getValue()));
    }

    public ColorRef getPixel(int x, int y) {
        ColorRef result = new ColorRef();
        Function function = Gdi32.get(FUNCTION_GET_PIXEL);
        function.invoke((Parameter)result, (Parameter)this, (Parameter)new Int((long)x), (Parameter)new Int((long)y));
        return result;
    }

    public static ColorRef setDCBrushColor(DC hDC, ColorRef clrref) {
        ColorRef result = new ColorRef();
        Function function = Gdi32.get(FUNCTION_SET_DC_BRUSH_COLOR);
        function.invoke((Parameter)result, (Parameter)hDC, (Parameter)clrref);
        return result;
    }

    public ColorRef setDCPenColor(DC hDC, ColorRef colorRef) {
        ColorRef color = new ColorRef();
        Function function = Gdi32.get(FUNCTION_SET_DC_PEN_COLOR);
        function.invoke((Parameter)color, (Parameter)hDC, (Parameter)colorRef);
        return color;
    }

    static {
        FUNCTION_CREATE_COMPATIBLE_DC = FUNCTION_CREATE_COMPATIBLE_DC;
        FUNCTION_SELECT_OBJECT = FUNCTION_SELECT_OBJECT;
        FUNCTION_BIT_BLT = FUNCTION_BIT_BLT;
        FUNCTION_STRETCH_BLT = FUNCTION_STRETCH_BLT;
        FUNCTION_PAT_BLT = FUNCTION_PAT_BLT;
        FUNCTION_DELETE_DC = FUNCTION_DELETE_DC;
        FUNCTION_SET_DC_BRUSH_COLOR = FUNCTION_SET_DC_BRUSH_COLOR;
        FUNCTION_SET_DC_PEN_COLOR = FUNCTION_SET_DC_PEN_COLOR;
        FUNCTION_TEXT_OUT = new FunctionName("TextOut");
        FUNCTION_DRAW_ICON_EX = FUNCTION_DRAW_ICON_EX;
        FUNCTION_DRAW_ICON = FUNCTION_DRAW_ICON;
        FUNCTION_SET_BACKGROUND_MODE = FUNCTION_SET_BACKGROUND_MODE;
        FUNCTION_SET_TEXT_COLOR = FUNCTION_SET_TEXT_COLOR;
        FUNCTION_SELECT_CLIP_RGN = FUNCTION_SELECT_CLIP_RGN;
        FUNCTION_FILL_REGION = FUNCTION_FILL_REGION;
        FUNCTION_FRAME_RGN = FUNCTION_FRAME_RGN;
        FUNCTION_GET_POLY_FILL_MODE = FUNCTION_GET_POLY_FILL_MODE;
        FUNCTION_INVERT_RGN = FUNCTION_INVERT_RGN;
        FUNCTION_PAINT_RGN = FUNCTION_PAINT_RGN;
        FUNCTION_SET_POLY_FILL_MODE = FUNCTION_SET_POLY_FILL_MODE;
        FUNCTION_GET_PIXEL = FUNCTION_GET_PIXEL;
    }

    public static class RasterOperation
    extends EnumItem {
        public static final RasterOperation SRCCOPY = new RasterOperation(0xCC0020);
        public static final RasterOperation SRCPAINT = new RasterOperation(15597702);
        public static final RasterOperation SRCAND = new RasterOperation(8913094);
        public static final RasterOperation SRCINVERT = new RasterOperation(0x660046);
        public static final RasterOperation SRCERASE = new RasterOperation(4457256);
        public static final RasterOperation NOTSRCCOPY = new RasterOperation(0x330008);
        public static final RasterOperation NOTSRCERASE = new RasterOperation(1114278);
        public static final RasterOperation MERGECOPY = new RasterOperation(0xC000CA);
        public static final RasterOperation MERGEPAINT = new RasterOperation(12255782);
        public static final RasterOperation PATCOPY = new RasterOperation(15728673);
        public static final RasterOperation PATPAINT = new RasterOperation(16452105);
        public static final RasterOperation PATINVERT = new RasterOperation(5898313);
        public static final RasterOperation DSTINVERT = new RasterOperation(0x550009);
        public static final RasterOperation BLACKNESS = new RasterOperation(66);
        public static final RasterOperation WHITENESS = new RasterOperation(16711778);

        private RasterOperation(int value) {
            super(value);
        }
    }
}

