/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.io;

import com.jniwrapper.win32.io.FileSystem;
import java.io.File;

public class ExtFile
extends File {
    public ExtFile(String pathname) {
        super(pathname);
    }

    public ExtFile(String parent, String child) {
        super(parent, child);
    }

    public ExtFile(File parent, String child) {
        super(parent, child);
    }

    public long getFreeDiskSpace() {
        return FileSystem.getDiskFreeSpace(this.getAbsolutePath());
    }

    public long getAttributes() {
        FileSystem.FileAttributes fileAttributes = FileSystem.getFileAttributes(this.getAbsolutePath());
        return fileAttributes.getFlags();
    }

    public void setAttributes(long attributes) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.getAbsolutePath());
        }
        FileSystem.setFileAttributes(this, new FileSystem.FileAttributes(attributes));
    }

    public void addAttribute(int attribute) {
        this.setAttributes(this.getAttributes() | (long)attribute);
    }

    public void removeAttribute(int attribute) {
        this.setAttributes(this.getAttributes() & (long)(~attribute));
    }

    public boolean hasAttribute(int attribute) {
        long attributes = this.getAttributes();
        return (attributes & (long)attribute) == (long)attribute;
    }

    public boolean isReadOnly() {
        FileSystem.FileAttributes fileAttributes = FileSystem.getFileAttributes(this.getAbsolutePath());
        return fileAttributes.isReadOnly();
    }

    public boolean isArchive() {
        FileSystem.FileAttributes fileAttributes = FileSystem.getFileAttributes(this.getAbsolutePath());
        return fileAttributes.isArchive();
    }

    public boolean isSystem() {
        FileSystem.FileAttributes fileAttributes = FileSystem.getFileAttributes(this.getAbsolutePath());
        return fileAttributes.isSystem();
    }

    public boolean isNormal() {
        FileSystem.FileAttributes fileAttributes = FileSystem.getFileAttributes(this.getAbsolutePath());
        return fileAttributes.contains(128L);
    }

    public int getDriveType() {
        int driveType = FileSystem.getDriveType(this).getValue();
        return driveType;
    }

    public boolean isCDROM() {
        return FileSystem.getDriveType(this).equals((Object)FileSystem.DriveType.CDROM);
    }

    public boolean isRAMDisk() {
        return FileSystem.getDriveType(this).equals((Object)FileSystem.DriveType.RAMDISK);
    }

    public boolean isRemovableDisk() {
        return FileSystem.getDriveType(this).equals((Object)FileSystem.DriveType.REMOVABLE);
    }

    public boolean isRemoteDisk() {
        return FileSystem.getDriveType(this).equals((Object)FileSystem.DriveType.REMOTE);
    }

    public boolean isFixedDisk() {
        return FileSystem.getDriveType(this).equals((Object)FileSystem.DriveType.FIXED);
    }
}

