/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt32;
import com.jniwrapper.ZeroTerminatedString;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.system.AdvApi32;

public class WinRegistry
extends AdvApi32 {
    static final String FUNCTION_CLOSE_KEY = "RegCloseKey";
    static final FunctionName FUNCTION_CREATE_KEY_EX;
    static final FunctionName FUNCTION_DELETE_KEY;
    static final FunctionName FUNCTION_DELETE_VALUE;
    static final FunctionName FUNCTION_ENUM_KEY_EX;
    static final FunctionName FUNCTION_ENUM_VALUE;
    static final String FUNCTION_FLUSH_KEY = "RegFlushKey";
    static final FunctionName FUNCTION_LOAD_KEY;
    static final String FUNCTION_NOTIFY_CHANGE_KEY_VALUE = "RegNotifyChangeKeyValue";
    static final FunctionName FUNCTION_OPEN_KEY_EX;
    static final String FUNCTION_OVERRIDE_PREDEF_KEY = "RegOverridePredefKey";
    static final FunctionName FUNCTION_QUERY_INFO_KEY;
    static final FunctionName FUNCTION_QUERY_VALUE_EX;
    static final FunctionName FUNCTION_REPLACE_KEY;
    static final FunctionName FUNCTION_RESTORE_KEY;
    static final FunctionName FUNCTION_SAVE_KEY;
    static final FunctionName FUNCTION_SET_VALUE_EX;
    static final FunctionName FUNCTION_UNLOAD_KEY;

    public static long closeKey(Handle key) {
        Function function = AdvApi32.get(FUNCTION_CLOSE_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key);
        return result.getValue();
    }

    public static long createKey(int key, String subKey, long options, long accessType, Handle resultKey) {
        return WinRegistry.createKey(new Handle((long)key), subKey, options, accessType, resultKey);
    }

    public static long createKey(Handle key, String subKey, long options, long accessType, Handle resultKey) {
        return WinRegistry.createKey(key, subKey, options, accessType, resultKey, null);
    }

    public static long createKey(Handle key, String subKey, long options, long accessType, Handle resultKey, UInt32 disposition) {
        Function function = AdvApi32.get(FUNCTION_CREATE_KEY_EX);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new Pointer.Const((Parameter)AdvApi32.getInstance().stringParam(subKey)), new UInt32(0L), new Pointer(null, true), new UInt32(options), new UInt32(accessType), new Pointer(null, true), new Pointer((Parameter)resultKey), new Pointer((Parameter)disposition, disposition == null)});
        return result.getValue();
    }

    public static long deleteKey(Handle key, String subKey) {
        Function function = AdvApi32.get(FUNCTION_DELETE_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)AdvApi32.getInstance().stringParam(subKey));
        return result.getValue();
    }

    public static long deleteValue(Handle key, String valueName) {
        Function function = AdvApi32.get(FUNCTION_DELETE_VALUE);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)AdvApi32.getInstance().stringParam(valueName));
        return result.getValue();
    }

    public static long enumKeyEx(Handle key, int index, ZeroTerminatedString name, UInt32 cName, ZeroTerminatedString className, UInt32 cClassName) {
        Function function = AdvApi32.get(FUNCTION_ENUM_KEY_EX);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new UInt32((long)index), new Pointer.OutOnly((Parameter)name), new Pointer((Parameter)cName), new Pointer(null, true), new Pointer((Parameter)className, className == null), new Pointer((Parameter)cClassName, cClassName == null), new Handle()});
        return result.getValue();
    }

    public static long enumValue(Handle key, int index, ZeroTerminatedString valueName, UInt32 cValueName, UInt32 type, Pointer data, UInt32 cData) {
        Function function = AdvApi32.get(FUNCTION_ENUM_VALUE);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new UInt32((long)index), new Pointer.OutOnly((Parameter)valueName), new Pointer((Parameter)cValueName), new Pointer(null, true), new Pointer((Parameter)type, type == null), data == null ? new Pointer.Void() : data, new Pointer((Parameter)cData, cData == null)});
        return result.getValue();
    }

    public static long getValue(Handle key, String name, int type, Parameter value) {
        Function function = AdvApi32.get(FUNCTION_QUERY_VALUE_EX);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new Pointer((Parameter)AdvApi32.getInstance().stringParam(name), name == null), new Pointer(null, true), new Pointer((Parameter)new Int32(type)), new Pointer(value), new Pointer((Parameter)new Int32(value.getLength()))});
        return result.getValue();
    }

    public static long setValue(Handle key, String name, int type, Parameter value, int valueSize) {
        Function function = AdvApi32.get(FUNCTION_SET_VALUE_EX);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new Pointer((Parameter)AdvApi32.getInstance().stringParam(name), name == null), new UInt32(0L), new UInt32((long)type), new Pointer.Const(value), new Int32(valueSize)});
        return result.getValue();
    }

    public static long flushKey(Handle key) {
        Function function = AdvApi32.get(FUNCTION_FLUSH_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key);
        return result.getValue();
    }

    public static long loadKey(Handle key, String subKey, String file) {
        Function function = AdvApi32.get(FUNCTION_LOAD_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)AdvApi32.getInstance().stringParam(subKey), (Parameter)AdvApi32.getInstance().stringParam(file));
        return result.getValue();
    }

    public static long saveKey(Handle key, String file) {
        Function function = AdvApi32.get(FUNCTION_SAVE_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)AdvApi32.getInstance().stringParam(file), (Parameter)new Pointer(null, true));
        return result.getValue();
    }

    public static long unloadKey(Handle key, String subKey) {
        Function function = AdvApi32.get(FUNCTION_UNLOAD_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)AdvApi32.getInstance().stringParam(subKey));
        return result.getValue();
    }

    public static long notifyChangeValue(Handle key, boolean watchSubtree, int notifyFilter, Handle event, boolean asynchronous) {
        Function function = AdvApi32.get(FUNCTION_NOTIFY_CHANGE_KEY_VALUE);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new Bool(watchSubtree), new UInt32((long)notifyFilter), event, new Bool(asynchronous)});
        return result.getValue();
    }

    public static long openKey(Handle key, String subKey, int accessMask, Handle resultKey) {
        Function function = AdvApi32.get(FUNCTION_OPEN_KEY_EX);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new Pointer.Const((Parameter)AdvApi32.getInstance().stringParam(subKey), subKey == null), new UInt32(0L), new UInt32((long)accessMask), new Pointer.OutOnly((Parameter)resultKey)});
        return result.getValue();
    }

    public static long overridePredefinedKey(Handle key, Handle newKey) {
        Function function = AdvApi32.get(FUNCTION_OVERRIDE_PREDEF_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)newKey);
        return result.getValue();
    }

    public static long queryInfoKey(Handle key, ZeroTerminatedString className, UInt32 cClassName, UInt32 subKeys, UInt32 cMaxSubKeyLen, UInt32 cMaxClassLen, UInt32 cValues, UInt32 cMaxValueNameLen, UInt32 cMaxValueLen) {
        Function function = AdvApi32.get(FUNCTION_QUERY_INFO_KEY);
        Int32 result = new Int32();
        function.invoke((Parameter)result, new Parameter[]{key, new Pointer((Parameter)className, className == null), new Pointer((Parameter)cClassName, cClassName == null), new Pointer.Void(), new Pointer((Parameter)subKeys, subKeys == null), new Pointer((Parameter)cMaxSubKeyLen, cMaxSubKeyLen == null), new Pointer((Parameter)cMaxClassLen, cMaxClassLen == null), new Pointer((Parameter)cValues, cValues == null), new Pointer((Parameter)cMaxValueNameLen, cMaxValueNameLen == null), new Pointer((Parameter)cMaxValueLen, cMaxValueLen == null), new Pointer.Void(), new Pointer.Void()});
        return result.getValue();
    }

    public static long replaceKey(Handle key, String subKey, String newFile, String oldFile) {
        Function function = AdvApi32.get(FUNCTION_REPLACE_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)AdvApi32.getInstance().stringParam(subKey), (Parameter)AdvApi32.getInstance().stringParam(newFile), (Parameter)AdvApi32.getInstance().stringParam(oldFile));
        return result.getValue();
    }

    public static long restoreKey(Handle key, String file, int flags) {
        Function function = AdvApi32.get(FUNCTION_RESTORE_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)AdvApi32.getInstance().stringParam(file), (Parameter)new UInt32((long)flags));
        return result.getValue();
    }

    static {
        FUNCTION_CLOSE_KEY = FUNCTION_CLOSE_KEY;
        FUNCTION_CREATE_KEY_EX = new FunctionName("RegCreateKeyEx");
        FUNCTION_DELETE_KEY = new FunctionName("RegDeleteKey");
        FUNCTION_DELETE_VALUE = new FunctionName("RegDeleteValue");
        FUNCTION_ENUM_KEY_EX = new FunctionName("RegEnumKeyEx");
        FUNCTION_ENUM_VALUE = new FunctionName("RegEnumValue");
        FUNCTION_FLUSH_KEY = FUNCTION_FLUSH_KEY;
        FUNCTION_LOAD_KEY = new FunctionName("RegLoadKey");
        FUNCTION_NOTIFY_CHANGE_KEY_VALUE = FUNCTION_NOTIFY_CHANGE_KEY_VALUE;
        FUNCTION_OPEN_KEY_EX = new FunctionName("RegOpenKeyEx");
        FUNCTION_OVERRIDE_PREDEF_KEY = FUNCTION_OVERRIDE_PREDEF_KEY;
        FUNCTION_QUERY_INFO_KEY = new FunctionName("RegQueryInfoKey");
        FUNCTION_QUERY_VALUE_EX = new FunctionName("RegQueryValueEx");
        FUNCTION_REPLACE_KEY = new FunctionName("RegReplaceKey");
        FUNCTION_RESTORE_KEY = new FunctionName("RegRestoreKey");
        FUNCTION_SAVE_KEY = new FunctionName("RegSaveKey");
        FUNCTION_SET_VALUE_EX = new FunctionName("RegSetValueEx");
        FUNCTION_UNLOAD_KEY = new FunctionName("RegUnLoadKey");
    }
}

