/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.gdi.Cursor;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.shell.NotifyIconData;
import com.jniwrapper.win32.shell.Shell32;
import com.jniwrapper.win32.shell.TrayIconListener;
import com.jniwrapper.win32.shell.TrayMessage;
import com.jniwrapper.win32.ui.Timer;
import com.jniwrapper.win32.ui.WindowProc;
import com.jniwrapper.win32.ui.Wnd;
import com.jniwrapper.win32.ui.WndClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TrayIcon {
    static final FunctionName FUNCTION_SHELL_NOTIFY_ICON = new FunctionName("Shell_NotifyIcon");
    static final int NIM_ADD = 0;
    static final int NIM_MODIFY = 1;
    static final int NIM_DELETE = 2;
    static final int NIF_MESSAGE = 1;
    static final int NIF_ICON = 2;
    static final int NIF_TIP = 4;
    static final int NIF_STATE = 8;
    static final int NIF_INFO = 16;
    static final int NIS_HIDDEN = 1;
    static final int NIS_SHAREDICON = 2;
    static final int TIMER_ID = 1;
    public static final int WM_TRAY = 1025;
    public static final String CLASS_NAME = "JW_TrayWindowClassName";
    private static Map _messageHandlers;
    private static Object _trayWindowLock;
    private static int _curID;
    private static long _hWnd;
    private final int _trayID;
    private boolean _disposed = false;
    private List _listeners = new ArrayList();

    public TrayIcon() {
        this(null);
    }

    public TrayIcon(Icon icon) {
        this._trayID = _curID++;
        TrayIcon.ensureEventProcessing();
        _messageHandlers.put(new Integer(this._trayID), this);
        NotifyIconData notifyicondata = new NotifyIconData(_hWnd, this._trayID);
        notifyicondata.setCallbackMessage(1025);
        notifyicondata.setFlags(23L);
        this.notify(0, notifyicondata);
        this.setIcon(icon);
    }

    private void notify(int operation, NotifyIconData notifyIconData) {
        if (this._disposed) {
            throw new IllegalStateException("Already disposed");
        }
        Function function = Shell32.getInstance().getFunction(FUNCTION_SHELL_NOTIFY_ICON.toString());
        Bool result = new Bool();
        function.invoke((Parameter)result, (Parameter)new Int32(operation), (Parameter)new Pointer((Parameter)notifyIconData));
        if (!result.getValue()) {
            throw new LastErrorException("Icon operation failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureEventProcessing() {
        Object object = _trayWindowLock;
        synchronized (object) {
            if (_hWnd == 0L) {
                new Thread(){

                    public void run() {
                        TrayIcon.createEmptyNativeWindow();
                        Wnd.eventLoop(_hWnd);
                    }
                }.start();
                try {
                    _trayWindowLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (_hWnd == 0L) {
                    throw new RuntimeException("Event processing window creation failed");
                }
            }
        }
    }

    public void setIcon(Icon icon) {
        if (icon != null && !icon.isNull()) {
            NotifyIconData notifyicondata = new NotifyIconData(_hWnd, this._trayID);
            notifyicondata.setIcon(icon);
            notifyicondata.setFlags(2L);
            this.notify(1, notifyicondata);
        }
    }

    public void showMessage(TrayMessage value) {
        NotifyIconData notifyicondata = new NotifyIconData(_hWnd, this._trayID);
        notifyicondata.setFlags(16L);
        notifyicondata.setInfoTitle(value.getTitle());
        notifyicondata.setInfo(value.getMessage());
        notifyicondata.setTimeout(value.getTimeout() * 1000);
        notifyicondata.setInfoFlags(value.getIconType());
        this.notify(1, notifyicondata);
    }

    public void dispose() {
        if (!this._disposed) {
            this.notify(2, new NotifyIconData(_hWnd, this._trayID));
            _messageHandlers.remove(new Integer(this._trayID));
            this._disposed = true;
        }
    }

    public void setToolTip(String tip) {
        NotifyIconData notifyicondata = new NotifyIconData(_hWnd, this._trayID);
        notifyicondata.setToolTip(tip);
        notifyicondata.setFlags(4L);
        this.notify(1, notifyicondata);
    }

    public void addTrayListener(TrayIconListener listener) {
        this._listeners.add(listener);
    }

    public void removeTrayListener(TrayIconListener listener) {
        this._listeners.remove(listener);
    }

    private void onIconMessage(long message, int x, int y) {
        Iterator i = this._listeners.iterator();
        while (i.hasNext()) {
            TrayIconListener listener = (TrayIconListener)i.next();
            listener.trayActionPerformed(message, x, y);
        }
    }

    public void setVisible(boolean visible) {
        NotifyIconData notifyicondata = new NotifyIconData(_hWnd, this._trayID);
        notifyicondata.setFlags(8L);
        notifyicondata.setState(visible ? 0L : 1L);
        notifyicondata.setStateMask(1L);
        this.notify(1, notifyicondata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createEmptyNativeWindow() {
        Object object = _trayWindowLock;
        synchronized (object) {
            WndClass wndClass = new WndClass(new TrayIconWindowProc(), CLASS_NAME);
            wndClass.register();
            Wnd hWnd = Wnd.createWindow(CLASS_NAME);
            _hWnd = hWnd.getValue();
            _trayWindowLock.notify();
        }
    }

    static {
        NIM_ADD = 0;
        NIM_MODIFY = 1;
        NIM_DELETE = 2;
        NIF_MESSAGE = 1;
        NIF_ICON = 2;
        NIF_TIP = 4;
        NIF_STATE = 8;
        NIF_INFO = 16;
        NIS_HIDDEN = 1;
        NIS_SHAREDICON = 2;
        TIMER_ID = 1;
        WM_TRAY = 1025;
        CLASS_NAME = CLASS_NAME;
        _messageHandlers = new HashMap();
        _trayWindowLock = new Object();
        _curID = 0;
    }

    private static class TrayIconWindowProc
    extends WindowProc {
        boolean _timerRuning = false;
        boolean _mouseIn = false;
        int _mouseX = 0;
        int _mouseY = 0;
        Timer _timer = null;
        TrayIcon _handler = null;

        private TrayIconWindowProc() {
        }

        Timer getTimer() {
            if (this._timer == null) {
                this._timer = new Timer(new Wnd(_hWnd), 1L, 150L, new TimeOutCallback());
            }
            return this._timer;
        }

        public void callback() {
            int msg = (int)this._msg.getValue();
            switch (msg) {
                case 1025: {
                    long lParam = this._lParam.getValue();
                    long wParam = this._wParam.getValue();
                    Point cursorPos = Cursor.getCursorPosition();
                    int mx = (int)cursorPos.getX();
                    int my = (int)cursorPos.getY();
                    Integer id = new Integer((int)wParam);
                    this._handler = (TrayIcon)_messageHandlers.get(id);
                    if (!(this._mouseIn || this._handler == null || mx == this._mouseX && my == this._mouseY)) {
                        this._handler.onIconMessage(673L, mx, my);
                    }
                    if (lParam == 512L) {
                        Timer timer = this.getTimer();
                        if (this._timerRuning) {
                            timer.stop();
                            this._timerRuning = false;
                        }
                        timer.start();
                        this._timerRuning = true;
                    }
                    this._mouseX = mx;
                    this._mouseY = my;
                    if (this._handler != null) {
                        this._handler.onIconMessage(lParam, this._mouseX, this._mouseY);
                    }
                    this._mouseIn = true;
                    this._lResult.setValue(0L);
                    break;
                }
                default: {
                    super.callback();
                }
            }
        }

        private class TimeOutCallback
        extends Timer.Callback {
            private TimeOutCallback() {
            }

            public void callback() {
                Timer timer = TrayIconWindowProc.this.getTimer();
                if (TrayIconWindowProc.this._timerRuning) {
                    timer.stop();
                    TrayIconWindowProc.this._timerRuning = false;
                }
                Point cursorPosition = Cursor.getCursorPosition();
                int mx = (int)cursorPosition.getX();
                int my = (int)cursorPosition.getY();
                if (TrayIconWindowProc.this._handler != null && (mx != TrayIconWindowProc.this._mouseX || my != TrayIconWindowProc.this._mouseY)) {
                    TrayIconWindowProc.this._handler.onIconMessage(675L, mx, my);
                    TrayIconWindowProc.this._mouseIn = false;
                    TrayIconWindowProc.this._mouseY = 0;
                    TrayIconWindowProc.this._mouseY = 0;
                }
            }
        }
    }
}

