/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.DataBuffer;
import com.jniwrapper.IOPerformer;
import com.jniwrapper.MemoryAccessViolationException;
import com.jniwrapper.Parameter;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.y;

public class Structure
extends Parameter {
    private Parameter[] _members;
    private int _length;
    private int _alignmentRequirement = 1;
    private int[] _entryOffsets;
    private short _alignment = 1;

    protected Structure() {
        super(y.int(), 0);
    }

    public Structure(Parameter[] parameterArray) {
        this();
        this.init(parameterArray);
    }

    public Structure(Parameter[] parameterArray, short s2) {
        this();
        this.init(parameterArray, s2);
    }

    private Structure(Structure structure) {
        this();
        Parameter[] parameterArray = new Parameter[structure._members.length];
        int n2 = 0;
        while (n2 < parameterArray.length) {
            parameterArray[n2] = (Parameter)structure._members[n2].clone();
            ++n2;
        }
        this.init(parameterArray, structure._alignment);
    }

    protected void init(Parameter[] parameterArray, short s2) {
        this._members = parameterArray;
        this._alignment = s2;
        this.computeLength();
    }

    protected void init(Parameter[] parameterArray) {
        this.init(parameterArray, PlatformContext.getDefaultStructureAlignment());
    }

    protected void addMembers(Parameter[] parameterArray) {
        if (this._members == null) {
            this._members = parameterArray;
        } else {
            Parameter[] parameterArray2 = new Parameter[this._members.length + parameterArray.length];
            System.arraycopy(this._members, 0, parameterArray2, 0, this._members.length);
            System.arraycopy(parameterArray, 0, parameterArray2, this._members.length, parameterArray.length);
            this._members = parameterArray2;
        }
        this.computeLength();
    }

    public int getAlignmentRequirement() {
        return this._alignmentRequirement;
    }

    private static final int _align(int n2, int n3) {
        return (n2 += n3 - 1) - n2 % n3;
    }

    protected void computeLength() {
        this._length = 0;
        int n2 = 1;
        this._entryOffsets = new int[this._members.length];
        int n3 = 0;
        while (n3 < this._members.length) {
            int n4;
            Parameter parameter = this._members[n3];
            int n5 = parameter.getLength();
            int n6 = parameter.getAlignmentRequirement();
            if (n6 > n2) {
                n2 = n6;
            }
            int n7 = n4 = n6 < this._alignment ? n6 : (int)this._alignment;
            if (n4 > 1 && this._length % n4 != 0) {
                this._length = Structure._align(this._length, n4);
            }
            this._entryOffsets[n3] = this._length;
            this._length += n5;
            ++n3;
        }
        this._alignmentRequirement = n2 < this._alignment ? n2 : this._alignment;
        this._length = Structure._align(this._length, this._alignmentRequirement);
    }

    long getResultFlags() {
        return 2L;
    }

    public int getLength() {
        return this._length;
    }

    public Object clone() {
        return new Structure(this);
    }

    public String toString() {
        int n2 = this._members.length;
        int n3 = 25;
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName() + " value: \\\n" + "    Default alignment: " + String.valueOf(this._alignment) + " \\\n" + "    Alignment requirement: " + String.valueOf(this._alignmentRequirement) + " \\\n" + "    Structure length: " + Integer.toString(this._length) + " \\\n" + "    Structure member count: " + Integer.toString(n2) + " \\\n" + "    Structure members: \\\n{\n");
        int n4 = 0;
        while (n4 < n2) {
            Parameter parameter = this._members[n4];
            String string = parameter.toString();
            stringBuffer.append(Parameter.indent(string, 25));
            stringBuffer.append("\n");
            ++n4;
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public Parameter[] getMembers() {
        return this._members;
    }

    public Parameter getMember(int n2) {
        return this._members[n2];
    }

    protected void setDataBuffer(DataBuffer dataBuffer, int n2) {
        super.setDataBuffer(dataBuffer, n2);
        int n3 = 0;
        while (n3 < this._members.length) {
            Parameter parameter = this._members[n3];
            parameter.setDataBuffer(dataBuffer, n2 + this._entryOffsets[n3]);
            ++n3;
        }
    }

    protected void acceptIOPerformer(IOPerformer iOPerformer, DataBuffer dataBuffer, int n2, boolean bl, boolean bl2) {
        int n3 = 0;
        while (n3 < this._members.length) {
            this._members[n3].acceptIOPerformer(iOPerformer, dataBuffer, n2 + this._entryOffsets[n3], bl, bl2);
            ++n3;
        }
    }

    public void write(DataBuffer dataBuffer, int n2, boolean bl) throws MemoryAccessViolationException {
        int n3 = 0;
        while (n3 < this._members.length) {
            this._members[n3].write(dataBuffer, n2 + this._entryOffsets[n3], bl);
            ++n3;
        }
    }

    public void read(DataBuffer dataBuffer, int n2, boolean bl) throws MemoryAccessViolationException {
        int n3 = 0;
        while (n3 < this._members.length) {
            this._members[n3].read(dataBuffer, n2 + this._entryOffsets[n3], bl);
            ++n3;
        }
    }

    public void push(DataBuffer dataBuffer, int n2, boolean bl) throws MemoryAccessViolationException {
        int n3 = 0;
        while (n3 < this._members.length) {
            Parameter parameter = this._members[n3];
            parameter.push(dataBuffer, n2 + this._entryOffsets[n3], bl);
            ++n3;
        }
    }

    public void pop(DataBuffer dataBuffer, int n2, boolean bl) throws MemoryAccessViolationException {
        int n3 = 0;
        while (n3 < this._members.length) {
            Parameter parameter = this._members[n3];
            parameter.pop(dataBuffer, n2 + this._entryOffsets[n3], bl);
            ++n3;
        }
    }
}

