/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.win32.ui.dialogs.ChooseColorDialog;

import java.awt.*;

/**
 * Sample for ChooseColorDialog
 *
 * @author Serge Piletsky
 */
public class ChooseColorDialogSample
{
    public static void main(String[] args)
    {
        DefaultLibraryLoader.getInstance().addPath("Bin");

        ChooseColorDialog dialog = new ChooseColorDialog();
        // customize dialog appearance
        dialog.getOptions().setFullOpen(true);
        // customize initially selected color
        dialog.setColor(Color.yellow);
        // customize custom colors
        dialog.getCustomColors().add(Color.red);
        dialog.getCustomColors().add(Color.green);
        dialog.getCustomColors().add(Color.blue);
        final boolean result = dialog.execute();
        System.out.println("result = " + result);
        if (result)
        {
            System.out.println("dialog.getColorBitmap() = " + dialog.getColor());
            System.out.println("dialog.getCustomColors() = " + dialog.getCustomColors());
        }
    }
}
