/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.ui.controls.ChooseColorField;
import com.jniwrapper.win32.ui.dialogs.ChooseColorDialog;

import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

/**
 * @author Serge Piletsky
 */
class ChooseColorSample extends LazyPanel implements PropertyChangeListener
{
    private JLabel lblAdvisoryText;
    private JLabel lblSelectedColor;
    private JLabel lblCustomColors;
    private ChooseColorField _colorField;
    private ColorsPanel _customColors;
    private JLabel lblNote;

    public ChooseColorSample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        lblAdvisoryText = new HTMLText("This page demonstrates standard Select Color dialog invoked using special ChooseColor control.");
        lblSelectedColor = new JLabel("Select color:");
        lblCustomColors = new JLabel("Custom Colors:");
        _colorField = new ChooseColorField(Color.yellow);
        _colorField.addPropertyChangeListener(ChooseColorField.PROPERTY_COLOR, this);
        _customColors = new ColorsPanel();
        lblNote = new HTMLText("<b>NOTE:</b> Fill the 'Custom Colors' area in Color Chooser dialog to see the selected colors above.");

        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 10, 10), 0, 0));

        add(lblSelectedColor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(_colorField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(lblCustomColors, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(_customColors, new GridBagConstraints(1, 2, 1, 2, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 10), 0, 0));

        add(lblNote, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 0), 0, 0));

        add(new JPanel(), new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        ChooseColorDialog dialog = _colorField.getDialog();
        dialog.setColor(Color.yellow);
        final List customColors = dialog.getCustomColors();
        for (int i = 0; i < 16; i++)
        {
            customColors.add(Color.white);
        }
        dialog.getOptions().setFullOpen(true);
        _customColors.setCustomColors(customColors);

        updateUI();
        super.initialize();
    }

    public void propertyChange(PropertyChangeEvent evt)
    {
        _customColors.setCustomColors(_colorField.getDialog().getCustomColors());
    }

    class ColorsPanel extends JPanel
    {
        private final static int MAX_COLORS = 16;

        public ColorsPanel()
        {
            setLayout(new GridLayout(2, 8));
            for (int i = 0; i < MAX_COLORS; i++)
            {
                JPanel panel = new JPanel();
                Dimension size = new Dimension(20, 20);
                panel.setPreferredSize(size);
                panel.setMinimumSize(size);
                panel.setMaximumSize(size);
                panel.setBackground(Color.black);
                panel.setBorder(new BevelBorder(BevelBorder.LOWERED));
                add(panel, i);
            }
            setBorder(new LineBorder(Color.gray));
            updateUI();
        }

        void setCustomColors(List colors)
        {
            int colorsCount = Math.min(MAX_COLORS, colors.size());
            for (int i = 0; i < colorsCount; i++)
            {
                Component component = getComponent(i);
                Color color = (Color) colors.get(i);
                component.setBackground(color);
            }
            updateUI();
        }
    }
}
