/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import javax.swing.*;
import java.awt.*;

/**
 * @author Serge Piletsky
 */
abstract class LazyPanel extends JPanel
{
    private boolean _initialized = false;
    private Window _parent;

    public LazyPanel(Window parent)
    {
        _parent = parent;
    }

    public void initialize() throws Exception
    {
        _initialized = true;
    }

    public boolean isInitialized()
    {
        return _initialized;
    }

    public Window getParentWindow()
    {
        return _parent;
    }

    public void activate() throws Exception
    {
        if (!isInitialized())
            initialize();
    }

    public void deactivate()
    {
    }
}
