/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.util.ProcessorInfo;

import javax.swing.*;
import java.awt.*;

/**
 * @author Serge Piletsky
 */
class ProcessorInfoSample extends LazyPanel
{
    private JLabel lblAdvisoryText;

    private JLabel lblVendorCaption;
    private JLabel lblVendor;
    private JLabel lblProcessorNameCaption;
    private JLabel lblProcessorName;
    private JLabel lblFrequencyCaption;
    private JLabel lblFrequency;
    private JLabel lblFamilyCaption;
    private JLabel lblFamily;
    private JLabel lblModelCaption;
    private JLabel lblModel;
    private JLabel lblSteppingCaption;
    private JLabel lblStepping;
    private JCheckBox chkFPU;
    private JCheckBox chkMMX;
    private JCheckBox chkMMXPlus;
    private JCheckBox chk3DNow;
    private JCheckBox chk3DNowPlus;
    private JCheckBox chkSSE;
    private JCheckBox chkSSE2;

    public ProcessorInfoSample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        ProcessorInfo info = ProcessorInfo.getInstance();
        lblAdvisoryText = new HTMLText("This page displays information about your processor using ProcessorInfo class.");
        lblVendorCaption = new JLabel("Vendor:");
        lblVendor = new JLabel(info.getVendor());
        lblProcessorNameCaption = new JLabel("Processor Name:");
        lblProcessorName = new JLabel(info.getProcessorName());
        lblFrequencyCaption = new JLabel("Frequency:");
        lblFrequency = new JLabel(String.valueOf(info.getFrequency()) + " MHz");
        lblFamilyCaption = new JLabel("Family:");
        lblFamily = new JLabel(String.valueOf(info.getFamily()));
        lblModelCaption = new JLabel("Model:");
        lblModel = new JLabel(String.valueOf(info.getModel()));
        lblSteppingCaption = new JLabel("Stepping:");
        lblStepping = new JLabel(String.valueOf(info.getStepping()));
        chkFPU = new JCheckBox("FPU", info.hasFPU());
        chkFPU.setEnabled(false);
        chkMMX = new JCheckBox("MMX", info.hasMMX());
        chkMMX.setEnabled(false);
        chkMMXPlus = new JCheckBox("MMXPlus", info.hasMMXPlus());
        chkMMXPlus.setEnabled(false);
        chk3DNow = new JCheckBox("3DNow!", info.has3DNow());
        chk3DNow.setEnabled(false);
        chk3DNowPlus = new JCheckBox("3DNow! Plus", info.has3DNowPlus());
        chk3DNowPlus.setEnabled(false);
        chkSSE = new JCheckBox("SSE", info.hasSSE());
        chkSSE.setEnabled(false);
        chkSSE2 = new JCheckBox("SSE2", info.hasSSE2());
        chkSSE2.setEnabled(false);

        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 10, 10), 0, 0));

        add(lblVendorCaption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 10), 0, 0));

        add(lblVendor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 10, 0, 10), 0, 0));

        add(lblProcessorNameCaption, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 10, 0, 10), 0, 0));

        add(lblProcessorName, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 10, 0, 10), 0, 0));

        add(lblFrequencyCaption, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 10, 0, 10), 0, 0));

        add(lblFrequency, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 10, 0, 10), 0, 0));

        add(lblFamilyCaption, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 10, 0, 10), 0, 0));

        add(lblFamily, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 10, 0, 10), 0, 0));

        add(lblModelCaption, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 10, 0, 10), 0, 0));

        add(lblModel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 10, 0, 10), 0, 0));

        add(lblSteppingCaption, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 10, 0, 10), 0, 0));

        add(lblStepping, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 10, 0, 10), 0, 0));

        add(chkFPU, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 10), 0, 0));

        add(chkMMX, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 10), 0, 0));

        add(chkMMXPlus, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 10), 0, 0));

        add(chk3DNow, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 10), 0, 0));

        add(chk3DNowPlus, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 10), 0, 0));

        add(chkSSE, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 10), 0, 0));

        add(chkSSE2, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 10), 0, 0));

        add(new JPanel(), new GridBagConstraints(0, 10, 3, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        super.initialize();
    }
}
