/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.shell.ShellFolder;

import javax.swing.*;
import java.awt.*;

/**
 * @author Serge Piletsky
 */
class ShellFolderSample extends LazyPanel
{
    private JLabel lblAdvisoryText;
    private JLabel lblMyDocumentsFolderCaption;
    private JLabel lblMyDocumentsFolder;
    private JLabel lblMyPicturesFolderCaption;
    private JLabel lblMyPicturesFolder;
    private JLabel lblMyMusicFolderCaption;
    private JLabel lblMyMusicFolder;
    private JLabel lblMyVideosFolderCaption;
    private JLabel lblMyVideosFolder;
    private JLabel lblFavoritesFolderCaption;
    private JLabel lblFavoritesFolder;

    public ShellFolderSample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        lblAdvisoryText = new HTMLText("This page lists some of your system folders using the ShellFolder class functions.<br><br><b>NOTE:</b> " +
                "Along with ShellFolder path this page demonstrates shell folder icons extracted from system and converted to java images.");
//        lblMyDocumentsFolderCaption = new JLabel("My Documents:");
//        lblMyDocumentsFolder = new ShellFolderLabel(ShellFolder.PERSONAL);
        lblMyPicturesFolderCaption = new JLabel("My Pictures:");
        lblMyPicturesFolder = new ShellFolderLabel(ShellFolder.MYPICTURES, true);
        lblMyMusicFolderCaption = new JLabel("My Music:");
        lblMyMusicFolder = new ShellFolderLabel(ShellFolder.MYMUSIC, true);
        lblMyVideosFolderCaption = new JLabel("My Videos:");
        lblMyVideosFolder = new ShellFolderLabel(ShellFolder.MYVIDEO, true); ;
        lblFavoritesFolderCaption = new JLabel("Favorites:");
        lblFavoritesFolder = new ShellFolderLabel(ShellFolder.FAVORITES, true);

        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 20, 10), 0, 0));

//        add(lblMyDocumentsFolderCaption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
//                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 10), 0, 0));
//
//        add(lblMyDocumentsFolder, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
//                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(lblMyPicturesFolderCaption, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 10), 0, 0));

        add(lblMyPicturesFolder, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(lblMyMusicFolderCaption, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 10), 0, 0));

        add(lblMyMusicFolder, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(lblMyVideosFolderCaption, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 10), 0, 0));

        add(lblMyVideosFolder, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(lblFavoritesFolderCaption, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 10), 0, 0));

        add(lblFavoritesFolder, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 0, 10), 0, 0));

        add(new JPanel(), new GridBagConstraints(0, 11, 1, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        super.initialize();
    }

    class ShellFolderLabel extends JLabel
    {
        public ShellFolderLabel(ShellFolder shellFolder)
        {
            this(shellFolder, false);
        }

        public ShellFolderLabel(ShellFolder shellFolder, boolean big)
        {
            super();
            final String absolutePath = shellFolder.getAbsolutePath();
            setText(absolutePath.equals("")?"<none>":absolutePath);
            final Icon icon = big?
                    Icon.extractBigAssociatedIcon(absolutePath):
                    Icon.extractSmallAssociatedIcon(absolutePath);
            final ImageIcon imageIcon = new ImageIcon(icon.toImage());
            setIcon(imageIcon);
        }
    }
}
