/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.ui.AWTWindowDecorator;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;

/**
 * @author Serge Piletsky
 */
class WindowDecoratorSample extends LazyPanel
{
    private JLabel lblAdvisoryText;
    private JCheckBox chkTransparent;
    private JCheckBox chkTopmost;
    private JCheckBox chkPalette;
    private JCheckBox chkCaption;
    private JSlider _slider;
    private AWTWindowDecorator _decorator;

    public WindowDecoratorSample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        final Window parent = getParentWindow();
        _decorator = new AWTWindowDecorator(parent);
        lblAdvisoryText = new HTMLText("This page demonstrates WindowDecorator features.");

        chkTransparent = new JCheckBox("Transparent", false);
        chkTransparent.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                final boolean transparent = chkTransparent.isSelected();
                final byte transparency = (byte)_slider.getValue();

                _decorator.setTransparent(transparent);
                _decorator.setTransparency(transparency);
            }
        });
        _slider = new JSlider(JSlider.HORIZONTAL);
        _slider.setMinimum(AWTWindowDecorator.TRANSPARENT);
        _slider.setMaximum(AWTWindowDecorator.OPAQUE);
        _slider.setValue(AWTWindowDecorator.OPAQUE);
        Hashtable labelTable = new Hashtable();
        labelTable.put(new Integer(AWTWindowDecorator.TRANSPARENT), new JLabel("Transparent"));
        labelTable.put(new Integer(AWTWindowDecorator.OPAQUE), new JLabel("Opaque"));
        _slider.setLabelTable( labelTable );
        _slider.setMajorTickSpacing(10);
        _slider.setPaintTicks(true);
        _slider.setPaintLabels(true);
        _slider.addChangeListener(new ChangeListener()
        {
            public void stateChanged(ChangeEvent e)
            {
                JSlider source = (JSlider)e.getSource();
                if (_decorator.isTransparent() & !source.getValueIsAdjusting())
                {
                    byte transparency = (byte)source.getValue();
                    _decorator.setTransparency(transparency);
                }
            }
        });
        chkTopmost = new JCheckBox("Topmost", false);
        chkTopmost.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                _decorator.setTopmost(chkTopmost.isSelected());
            }
        });
        chkPalette = new JCheckBox("Palette Style", false);
        chkPalette.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                _decorator.setPalleteWindow(chkPalette.isSelected());
                parent.validate();
            }
        });
        chkCaption = new JCheckBox("Show Caption", true);
        chkCaption.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                _decorator.setCaptionVisible(chkCaption.isSelected());
                parent.validate();
            }
        });

        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 10, 10), 0, 0));

        add(chkTransparent, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
                  GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 10, 10), 0, 0));

        add(_slider, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,
                  GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 0, 5, 10), 0, 0));

        add(chkTopmost, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
                  GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 10, 10), 0, 0));

        add(chkPalette, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0,
                  GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 10, 10), 0, 0));

        add(chkCaption, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0,
                  GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 10, 10), 0, 0));

        add(new JPanel(), new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        super.initialize();
    }
}
