//-[stdhead]-------------------------------------------------------
//Project:Java preprocessor
//File   :main.cpp
//Started:05.07.00 11:56:52
//Updated:21.07.00 18:22:16
//Author :Nick E. Geht
//Subj   :entry point
//Version:1.0
//Requres:
//-----------------------------------------------------------------
#include "stdafx.h"
#include "lexer.h"
#include "parser.h"

void logo();
void help();


int main(int argc, char *argv[])
{
        CJppParser *pParser;
        pParser=new CJppParser;

        char    szIn[MAX_PATH]="",szOut[MAX_PATH];
        bool    nologo=false;
        bool    noremove=false;
        bool    nojavac=false;
        bool    rc;
        char    szJavaParam[MAX_PATH]="";
        int     i;
        bool    f;

        if (argc<2)
        {
                logo();
                help();
                delete pParser;
                return 1;
        }
        for (i=1;i<argc;i++)
        {
                if ((*argv[i]=='/')||
                    (*argv[i]=='-'))
                {
                        if (argv[i][1]=='D')
                        {
                                pParser->AddDefine(argv[i]+2,"");
                                continue;
                        }
                        if ((argv[i][1]=='?')||
                            (!strcmp(argv[i]+1,"help")))
                        {
                                logo();
                                help();
                                delete pParser;
                                return 1;
                        }
                        if (!strcmp(argv[i]+1,"nologo")) nologo=true;
                        if (!strcmp(argv[i]+1,"noremove")) noremove=true;
                        if (!strcmp(argv[i]+1,"nc")) nojavac=true;
                        if (!strcmp(argv[i]+1,"javac"))
                        {
                                for (i++;i<argc;i++)
                                {
                                        strcat(szJavaParam,argv[i]);
                                        strcat(szJavaParam," ");
                                }
                        }
                }
                else
                {
                        if (strlen(szIn))
                        {
                                printf ("One one input file name should be specified");
                                delete pParser;
                                return -1;
                        }
                        strcpy(szIn,argv[i]);
                }
        }
        if (!strlen(szIn))
        {
                printf ("Input file name should be specified");
                delete pParser;
                return -1;
        }
        strcpy(szOut,szIn);
        for (i=strlen(szOut);i>0;i--)
        {
                if (szOut[i]=='\\') break;
                if (szOut[i]=='/') break;
                if (szOut[i]=='.')
                {
                        szOut[i]=0;
                        break;
                }
        }
        strcat(szOut,".java");
        if (!nologo) logo();
        rc=pParser->Compile(szIn,szOut,szJavaParam,!nojavac);
        if (!noremove) remove(szOut);
        delete pParser;
        return rc==false;
}

void logo()
{
        printf("Java preprocessor\n");
        printf("Version 0.01\n");
        printf("copyright (c) Nick E. Geht, 2000\n");
}

void help()
{
        printf("Usage:\n");
        printf("   jpp <jppsource> [<jpp-keys>] [/javac <jc keys>]\n");
        printf("Where\n");
        printf("   jppsource    the name of the file with the java preprocessor source\n");
        printf("   jpp-keys     JPP specific parameters:\n");
        printf("      /nologo   do not display logo\n");
        printf("      /noremove do not remove generated java files\n");
        printf("      /D<IDENT> define identifier\n");
        printf("      /nc       disable javac\n");
        printf("   jc keys      SUN javac compiler keys\n");
        printf("Example:\n");
        printf("   jpp mysource.jpp /nologo /DDEBUG /DHOME /javac -O -g:none\n");
}
