//-[stdhead]-------------------------------------------------------
//Project:Java preprocessor
//File   :parser.cpp
//Started:05.07.00 11:22:17
//Updated:23.07.00 13:48:56
//Author :Nick E. Geht
//Subj   :Jpp source parser
//Version:1.0
//Requres:
//-----------------------------------------------------------------
#include "stdafx.h"
#include "lexer.h"
#include "parser.h"

//initialize parser
CJppParser::CJppParser()
{
        m_nSources=0;
        m_nDefines=0;
        m_nInlines=0;
}

//release parser
CJppParser::~CJppParser()
{
        int     i;
        for (i=0;i<m_nSources;i++)
        {
                delete m_pSources[i].pLexer;
        }
}

//compile jpp sources
bool CJppParser::Compile(PSTR szInputName, PSTR szOutputName,PSTR jparam,bool runjava)
{
        FILE    *po;
        strcpy(m_szOutFile,szOutputName);
        po=fopen(szOutputName,"w");
        if (!po)
        {
                printf("error: %s cannot be opened\n",szOutputName);
                return false;
        }
        m_nOutputLine=1;
        if (!Process(po,szInputName)) return false;
        fclose(po);
        int     rc;
        if (runjava)
        {
                //jpp source is parsed, try to compile
                FILE    *pe;
                char    szCmdLine[MAX_PATH];
                int     line;
                sprintf(szCmdLine,"javac %s -Xstdout %s >err.tmp",jparam,szOutputName);
                rc=system(szCmdLine);

                pe=fopen("err.tmp","r");
                if (pe)
                {
                        while(true)
                        {
                                *szCmdLine=0;
                                fgets(szCmdLine,MAX_PATH,pe);
                                if (feof(pe)&&(!*szCmdLine)) break;
                                if (!memcmp(szCmdLine,szOutputName,strlen(szOutputName)))
                                {
                                        PSTR    szInfo;
                                        szInfo=szCmdLine+strlen(szOutputName)+1;
                                        line=atoi(szInfo);
                                        if (line)
                                        {
                                                while(*szInfo!=0 && *szInfo!=':') szInfo++;
                                                printf("%s(%i) : error %s",m_pSources[m_nSourceFiles[line]].szFileName,m_nSourceLines[line],szInfo);
                                        }
                                }
                        }
                        fclose(pe);
                        remove("err.tmp");
                }
                return rc==0;
        }
        else    return true;
}

//process source
bool CJppParser::Process(FILE *pOut, PSTR szFileName)
{
        int             nFile;                  //current file number
        char            szLexem[65536];         //lexem size - up to 64Kb
        int             nLexem;                 //type of lexem
        CJppLexer      *pLexer;                 //current lexer
        int             i;                      //temp var
        int             m_nSkipDeep=0;          //   ( #ifdef/#ifndef - #endif)

        //open source file
        nFile=AddFile(szFileName);
        if (nFile==-1)
        {
                printf("error: include limit exceed at %s\n",szFileName);
                return false;
        }
        if (nFile==-2)
        {
                printf("error: %s cannot be opened\n",szFileName);
                return false;
        }
        //process source file
        pLexer=m_pSources[nFile].pLexer;
        while(true)
        {
                nLexem=pLexer->GetLexem(szLexem);

                if (m_nSkipDeep)
                {
                        //   
                        if (nLexem==5)
                        {
                                nLexem=pLexer->GetLexem(szLexem);
                                if (nLexem!=2)
                                {
                                        printf("%s(%i) : error : invalid preprocessor command\n",szFileName,pLexer->GetLine());
                                        return false;
                                }
                                if (!strcmp(szLexem,"ifdef")) m_nSkipDeep++;
                                if (!strcmp(szLexem,"ifndef")) m_nSkipDeep++;
                                if (!strcmp(szLexem,"endif")) m_nSkipDeep--;
                        }
                        else
                        if (nLexem==0)
                        {
                                printf("%s(%i) : error : #ifdef/#ifndef/#endif disbalance\n",szFileName,pLexer->GetLine());
                        }
                }
                else
                {
                        // 
                        switch(nLexem)
                        {
                        case    0:              //end of file
                                return true;
                        case    1:              //end of line
                                m_nSourceFiles[m_nOutputLine]=nFile;
                                m_nSourceLines[m_nOutputLine]=pLexer->GetLine()-1;
                                fprintf(pOut,"\n");
                                m_nOutputLine++;
                                break;
                        case    2:              //lexem
                                i=CheckAndProcessDefine(szLexem,pOut);
                                if (i>=0) break;
                                i=CheckAndProcessInline(szLexem,pOut,pLexer,szFileName);
                                if (i>=0) break;
                                if (i==-2) return false;
                        case    3:              //one-char lexem
                        case    4:              //string contant
                                fprintf(pOut,"%s",szLexem);
                                break;
                        case    5:              //sharp sign (#)
                                {
                                        nLexem=pLexer->GetLexem(szLexem);
                                        if (nLexem!=2)
                                        {
                                                printf("%s(%i) : error : invalid preprocessor command\n",szFileName,pLexer->GetLine());
                                                return false;
                                        }
                                        if (!strcmp(szLexem,"include"))
                                        {
                                                //include pre-processor command
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=6)
                                                {
                                                        printf("%s(%i) : error : invalid include syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=4)
                                                {
                                                        printf("%s(%i) : error : invalid include syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                //remove quotes from the include file name
                                                int     nLen;
                                                char    szIncName[MAX_PATH];
                                                char    szProcName[MAX_PATH]="";
                                                strcpy(szIncName,szLexem+1);
                                                nLen=strlen(szIncName);
                                                szIncName[nLen-1]=0;
                                                //search include file
                                                _searchenv(szIncName,"JPPINCLUDE",szProcName);
                                                if (*szProcName)
                                                {
                                                        if (!Process(pOut,szProcName)) return false;
                                                }
                                                else
                                                {
                                                        printf("%s(%i) : error : include file %s not found\n",szFileName,pLexer->GetLine(),szIncName);
                                                }
                                                break;
                                        }
                                        if (!strcmp(szLexem,"define"))
                                        {
                                                char    szName[MAX_PATH];
                                                char    szValue[MAX_PATH]="";
                                                //define
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=6)  //skip spaces
                                                {
                                                        printf("%s(%i) : error : invalid define syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=2)
                                                {
                                                        printf("%s(%i) : error : invalid define syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                strncpy(szName,szLexem,MAX_PATH);
                                                szName[255]=0;
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=6)  //skip spaces
                                                {
                                                        printf("%s(%i) : error : invalid define syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                nLexem=pLexer->GetLexem(szLexem);
                                                while((nLexem!=0)&&(nLexem!=1))
                                                {
                                                        strcat(szValue,szLexem);
                                                        nLexem=pLexer->GetLexem(szLexem);
                                                }
                                                AddDefine(szName,szValue);
                                                break;
                                        }
                                        if (!strcmp(szLexem,"ifdef"))
                                        {
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=6)
                                                {
                                                        printf("%s(%i) : error : invalid ifdef syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=2)
                                                {
                                                        printf("%s(%i) : error : invalid ifdef syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                for (i=0;i<m_nDefines;i++)
                                                {
                                                        if (!strcmp(szLexem,m_pDefines[i].szDefine))
                                                                break;
                                                }
                                                if (i==m_nDefines) m_nSkipDeep++;
                                                break;
                                        }
                                        if (!strcmp(szLexem,"ifndef"))
                                        {
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=6)
                                                {
                                                        printf("%s(%i) : error : invalid ifdef syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=2)
                                                {
                                                        printf("%s(%i) : error : invalid ifdef syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                for (i=0;i<m_nDefines;i++)
                                                {
                                                        if (!strcmp(szLexem,m_pDefines[i].szDefine))
                                                                break;
                                                }
                                                if (i<m_nDefines) m_nSkipDeep++;
                                                break;
                                        }
                                        if (!strcmp(szLexem,"endif")) break;
                                        if (!strcmp(szLexem,"inline"))
                                        {

                                                char    szName[MAX_PATH];
                                                char    szValue[1024]="";
                                                //define
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=6)  //skip spaces
                                                {
                                                        printf("%s(%i) : error : invalid define syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=2)
                                                {
                                                        printf("%s(%i) : error : invalid define syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                strncpy(szName,szLexem,MAX_PATH);
                                                szName[255]=0;
                                                nLexem=pLexer->GetLexem(szLexem);
                                                if (nLexem!=6)  //skip spaces
                                                {
                                                        printf("%s(%i) : error : invalid define syntax\n",szFileName,pLexer->GetLine());
                                                        return false;
                                                }
                                                nLexem=pLexer->GetLexem(szLexem);
                                                while((nLexem!=0)&&(nLexem!=1))
                                                {
                                                        strcat(szValue,szLexem);
                                                        nLexem=pLexer->GetLexem(szLexem);
                                                }
                                                AddInline(szName,szValue);
                                                break;
                                        }
                                        printf("%s(%i) : error : invalid preprocessor command\n",szFileName,pLexer->GetLine());
                                        return false;

                                }
                                break;
                        case    6:              //space
                                fprintf(pOut," ");
                                break;
                        }
                }
        }
}

//add file to source list
int CJppParser::AddFile(PSTR szInputName)
{
        FILE    *pf;
        int      len;
        char    *szContents;


        if (m_nSources>=32) return -1;          //source quantity exceed
        //read file into memory
        pf=fopen(szInputName,"rb");
        if (!pf) return -2;                      //can not open file
        fseek(pf,0,SEEK_END);
        len=ftell(pf);
        fseek(pf,0,SEEK_SET);
        szContents=(char *)malloc(len+1);
        fread(szContents,1,len,pf);
        szContents[len]=0;
        fclose(pf);
        //add source into the sources list
        strcpy(m_pSources[m_nSources].szFileName,szInputName);
        m_pSources[m_nSources].pLexer=new CJppLexer(szContents);
        return m_nSources++;
}

//add define
int CJppParser::AddDefine(PSTR szName, PSTR szLex)
{
        if (m_nDefines<2048)
        {
                if (strlen(szName)>=64) szName[63]=0;
                if (strlen(szLex)>=MAX_PATH) szName[MAX_PATH-1]=0;

                strcpy(m_pDefines[m_nDefines].szDefine,szName);
                strcpy(m_pDefines[m_nDefines].szValue,szLex);
                m_nDefines++;
        }
        return 0;
}


//add Inline
int CJppParser::AddInline(PSTR szName, PSTR szLex)
{
        if (m_nInlines<2048)
        {
                if (strlen(szName)>=64) szName[63]=0;
                if (strlen(szLex)>=1024) szName[1023]=0;

                strcpy(m_pInlines[m_nInlines].szName,szName);
                strcpy(m_pInlines[m_nInlines].szInline,szLex);
                m_nInlines++;
        }
        return 0;
}

int CJppParser::CheckAndProcessDefine(char *szName, FILE *pOut)
{
        int     i;
        for (i=0;i<m_nDefines;i++)
        {
                if (!strcmp(szName,m_pDefines[i].szDefine))
                {
                        if (pOut) fprintf(pOut,"%s",m_pDefines[i].szValue);
                        return i;
                }
        }
        return -1;
}

int CJppParser::CheckAndProcessInline(char *_szLexem, FILE *pOut, CJppLexer *pLexer,char *szFileName)
{
        int     i,nLexem;
        char    szLexem[32768];
        int             nv=0;                   //temp var for inline no
        bool            fIsNv;                  //

        for (i=0;i<m_nInlines;i++)
                if (!strcmp(_szLexem,m_pInlines[i].szName)) break;
        if (i==m_nInlines) return -1;   //no inline

        char    pList[10][256];
        int     pc=0,pp=0,sq=1,j;
        //process inline paramters
        nLexem=pLexer->GetLexem(szLexem,false);
        if ((nLexem!=3)||(*szLexem!='('))
        {
                printf("%s(%i) : error : invalid inline call\n",szFileName,pLexer->GetLine());
                return -2;
        }
        for (pp=0;pp<10;pp++) pList[pp][0]=0;
        pp=0;
        while(sq)
        {
                nLexem=pLexer->GetLexem(szLexem,false);
                //bracket in the parameter
                //we must ignore commans in brackets
                if ((nLexem==1)||(nLexem==0))
                {
                        printf("%s(%i) : error : inline call requires brackets\n",szFileName,pLexer->GetLine());
                        return -2;
                }
                if ((nLexem==3)&&(*szLexem=='('))
                {
                        strcat(pList[pp],"(");
                        sq++;
                        continue;
                }
                //close bracket
                if ((nLexem==3)&&(*szLexem==')'))
                {
                        sq--;
                        if (sq) strcat(pList[pp],")");
                        continue;
                }
                //comma. if bracket level==1
                if ((nLexem==3)&&(*szLexem==','))
                {
                        if (sq==1) pp++;
                              else strcat(pList[pp],",");
                        if (pp==10)
                        {
                                printf("%s(%i) : error : too many inline call parameters\n",szFileName,pLexer->GetLine());
                                return -2;
                        }
                        continue;
                }
                //check lexem for define
                j=CheckAndProcessDefine(szLexem,NULL);
                if (j>=0) strcat(pList[pp],m_pDefines[j].szValue);
                     else strcat(pList[pp],szLexem);
        }
        if (strlen(pList[pp])) pp++;
        pc=pp;
        //inline parameter processed
        //decode inline by self
        fIsNv=false;
        CJppLexer *pInlineLex=new CJppLexer(m_pInlines[i].szInline);
        while(nLexem=pInlineLex->GetLexem(szLexem))
        {
                //check lexem for define and inline paramter reference
                if (nLexem==2)
                {
                        if ((strlen(szLexem)==2)&&
                            (szLexem[0]=='_'))
                        {
                                pp=szLexem[1]-'0';
                                if ((pp<0)||(pp>=pc))
                                {
                                        if (szLexem[1]=='T')
                                        {
                                                if (!fIsNv)
                                                {
                                                        fIsNv=true;
                                                        nv++;
                                                }
                                                fprintf(pOut,"tmpvar%i",nv);
                                        }
                                        else
                                        {
                                                printf("%s(%i) : error : invalid inline parameter reference %s\n",szFileName,pLexer->GetLine(),szLexem);
                                                pInlineLex->EmptyText();
                                                delete pInlineLex;
                                                return -2;
                                        }
                                }
                                fprintf(pOut,"%s",pList[pp]);
                                continue;
                        }
                        j=CheckAndProcessDefine(szLexem,pOut);
                        if (j>=0) continue;
                }
                if (*szLexem=='@')      //repeatable block
                {
                        char    szRep[1024]="";
                        int     sp;
                        int     nreppos=-1;
                        //process repeator
                        nLexem=pInlineLex->GetLexem(szLexem,false);
                        if ((nLexem!=3)||(*szLexem!='('))
                        {
                                printf("%s(%i) : error : invalid repeator call\n",szFileName,pLexer->GetLine());
                                return -2;
                        }
                        sq=1;
                        while(sq)
                        {
                                nLexem=pInlineLex->GetLexem(szLexem,false);
                                //bracket in the parameter
                                //we must ignore commans in brackets
                                if ((nLexem==1)||(nLexem==0))
                                {
                                        printf("%s(%i) : error : inline call requires brackets\n",szFileName,pLexer->GetLine());
                                        return -2;
                                }
                                if ((nLexem==3)&&(*szLexem=='('))
                                {
                                        strcat(szRep,"(");
                                        sq++;
                                        continue;
                                }
                                //close bracket
                                if ((nLexem==3)&&(*szLexem==')'))
                                {
                                        sq--;
                                        if (sq) strcat(szRep,")");
                                        continue;
                                }
                                if ((nLexem==2)&&(!strcmp(szLexem,"_P")))
                                {
                                        if (nreppos!=-1)
                                        {
                                                printf("%s(%i) : error : more than one parameter reference in repeat block\n",szFileName,pLexer->GetLine());
                                                pInlineLex->EmptyText();
                                                delete pInlineLex;
                                                return -2;
                                        }
                                        nreppos=strlen(szRep);
                                        strcat(szRep," ");
                                        continue;
                                }
                                //check lexem for define
                                j=CheckAndProcessDefine(szLexem,NULL);
                                if (j>=0) strcat(szRep,m_pDefines[j].szValue);
                                     else strcat(szRep,szLexem);
                        }
                        if (nreppos>=0) szRep[nreppos]=0;
                        for (j=1;j<pc;j++)
                        {
                                fprintf(pOut,"%s",szRep);
                                if (nreppos>=0)
                                {
                                        fprintf(pOut,"%s",pList[j]);
                                        fprintf(pOut,"%s",szRep+nreppos+1);
                                }
                        }
                        continue;
                }
                fprintf(pOut,"%s",szLexem);
        }
        pInlineLex->EmptyText();
        delete pInlineLex;
        return i;
}
