/*
 * Decompiled with CFR 0.152.
 */
package com.kashif.utils;

import com.kashif.utils.ArgumentPair;
import com.kashif.utils.BadArgumentsException;
import java.util.Enumeration;
import java.util.Vector;

public class ArgumentParser {
    public static String ARGUMENT_PREFIX = "-";
    private Vector argPairList = null;
    private Vector possibleArgs = null;
    private int minArgs = -1;
    private int maxArgs = -1;
    private String argumentPrefix = ARGUMENT_PREFIX;

    public void parseArgs(String[] args) throws BadArgumentsException {
        if (args.length < this.minArgs || args.length > this.maxArgs) {
            throw new BadArgumentsException("Invalid number of arguments");
        }
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith(this.argumentPrefix)) {
                if (i + 1 >= args.length) {
                    this.argPairList.addElement(new ArgumentPair(arg, null));
                } else {
                    String nextArg = args[i + 1];
                    if (nextArg.startsWith(this.argumentPrefix)) {
                        this.argPairList.addElement(new ArgumentPair(arg, null));
                    } else {
                        this.argPairList.addElement(new ArgumentPair(arg, nextArg));
                        ++i;
                    }
                }
            } else {
                this.argPairList.addElement(new ArgumentPair("", arg));
            }
            ++i;
        }
        if (!this.areAllArgumentValid(args)) {
            throw new BadArgumentsException("Bad argument(s) passed");
        }
    }

    ArgumentParser(String argPrefix, Vector possibleArgs, int minArgs, int maxArgs) {
        this.argPairList = new Vector();
        this.possibleArgs = possibleArgs;
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
        this.argumentPrefix = argPrefix;
    }

    public void setArgumentPrefix(String o) {
        this.argumentPrefix = o;
    }

    public String getArgumentPrefix() {
        return this.argumentPrefix;
    }

    public Vector getAllUnpairedArgs() {
        Vector<String> rtnVector = new Vector<String>();
        Enumeration e = this.argPairList.elements();
        while (e.hasMoreElements()) {
            ArgumentPair argPair = (ArgumentPair)e.nextElement();
            if (argPair.getValue() != null) continue;
            rtnVector.addElement(argPair.getArg());
        }
        if (rtnVector.isEmpty()) {
            return null;
        }
        return rtnVector;
    }

    public Vector getAllUnpairedValues() {
        Vector<String> rtnVector = new Vector<String>();
        Enumeration e = this.argPairList.elements();
        while (e.hasMoreElements()) {
            ArgumentPair argPair = (ArgumentPair)e.nextElement();
            if (argPair.getArg() == null || !argPair.getArg().equals("")) continue;
            rtnVector.addElement(argPair.getValue());
        }
        if (rtnVector.isEmpty()) {
            return null;
        }
        return rtnVector;
    }

    public static void main(String[] args) {
        ArgumentParser parser = new ArgumentParser(ARGUMENT_PREFIX, null, 0, 20);
        try {
            parser.parseArgs(args);
            System.out.println(parser.getArgPairList());
            System.out.println("Value for argument -f = " + parser.getArgValue("-f"));
            System.out.println("Unpaired Args  = " + parser.getAllUnpairedArgs());
            System.out.println("Unpaired Values  = " + parser.getAllUnpairedValues());
            System.out.println("Paired Values  = " + parser.getAllPairedArgs());
            System.out.println("Found argument -h  = " + parser.isArgumentPresent("-h"));
        }
        catch (BadArgumentsException e) {
            System.out.println(e.getMessage());
        }
    }

    private boolean areAllArgumentValid(String[] args) {
        if (this.possibleArgs == null || this.possibleArgs.size() == 0) {
            return true;
        }
        Vector v = this.getAllArguments();
        if (v == null || v.size() == 0) {
            return true;
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String arg = (String)e.nextElement();
            if (this.possibleArgs.contains(arg)) continue;
            return false;
        }
        return true;
    }

    public Vector getAllPairedArgs() {
        Vector<ArgumentPair> rtnVector = new Vector<ArgumentPair>();
        Enumeration e = this.argPairList.elements();
        while (e.hasMoreElements()) {
            ArgumentPair argPair = (ArgumentPair)e.nextElement();
            if (argPair.getArg() == null || argPair.getArg().equals("") || argPair.getValue() == null) continue;
            rtnVector.addElement(argPair);
        }
        if (rtnVector.isEmpty()) {
            return null;
        }
        return rtnVector;
    }

    public ArgumentPair getArgPair(String arg) {
        Enumeration e = this.argPairList.elements();
        while (e.hasMoreElements()) {
            ArgumentPair argPair = (ArgumentPair)e.nextElement();
            if (argPair.getArg() == null || !argPair.getArg().equals(arg)) continue;
            return argPair;
        }
        return null;
    }

    public Vector getAllArguments() {
        Vector<String> rtnVector = new Vector<String>();
        Enumeration e = this.argPairList.elements();
        while (e.hasMoreElements()) {
            ArgumentPair argPair = (ArgumentPair)e.nextElement();
            if (argPair.getArg() == null || argPair.getArg().equals("")) continue;
            rtnVector.addElement(argPair.getArg());
        }
        if (rtnVector.isEmpty()) {
            return null;
        }
        return rtnVector;
    }

    public Vector getArgPairList() {
        return this.argPairList;
    }

    public boolean isArgumentPresent(String arg) {
        Enumeration e = this.argPairList.elements();
        while (e.hasMoreElements()) {
            ArgumentPair argPair = (ArgumentPair)e.nextElement();
            if (argPair.getArg() == null || !argPair.getArg().equals(arg)) continue;
            return true;
        }
        return false;
    }

    public String getArgValue(String arg) {
        ArgumentPair argPair = this.getArgPair(arg);
        if (argPair != null) {
            return argPair.getValue();
        }
        return null;
    }
}

