/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * ExceptionList: A list which stores all PRePExceptions. It is itself stored in
 *                a session
 *
 * History: 12/21/98 Creation nh
 *
 * Date: 12/21/98
 *
 * @author nh
 * @version 1.0
 */

package com.delec.prep;

import java.util.Vector;
import java.io.*;

public class ExceptionList extends Vector
{

  public void outExceptionList(PrintWriter pwriter)
  {
    for (int i = 0; i < size(); i++)
      {
	PRePException prepException = (PRePException)elementAt(i);
	pwriter.print(prepException.outException());
      }
  }

  public void outErrorlevel(PrintWriter pwriter, int iErrorlevel)
  {
    for (int i = 0; i < size(); i++)
      {
	PRePException prepException = (PRePException)elementAt(i);
	if (prepException.getErrorlevel() <= iErrorlevel)
	  {
	    pwriter.print(prepException.outException());
	    pwriter.flush();
	  }
      }
  }
}
