/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagCount: counts all ARGs which are temporarily stored in the TagList
 *               this tag is used for validating the arguments of a predefined
 *               tag
 *
 * History: - Creation nh
 *
 * @author nh
 * @version 1.0
 * @see PRePMain, TagList, PRePTag
 */
 
package com.delec.prep;
import java.io.*;
import java.util.*;

public class PRePTagCount extends PRePTagArg
{
	/**
	 * counts all the Arguments which are stored in the TagList
	 */
	int iCount;

	/**
	 * Constructor
	 */
	public PRePTagCount()
	{
		super("ARG0");
	}

	/**
	 * sets the counter in the tag
	 * @param int the number of arguments in the TagList
	 */

	public void setCount(int iCount)
	{
		this.iCount = iCount;
	}

	/**
	 * gets the counter of the tag
	 * @return the number of arguments in the TagList
	 */

	public int getIntValue()
	{
		return iCount-1;
	}
}
