/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagEXEC: Defines EXEC - it writes a batch file and a text file, calls the batchfile with 
 *              the text file as arguments. If the batch file returns with an errorcode which 
 *		is less or equal than zero, the program successed and it will follow the 
 *		instructions of the third argument. Else the fourth argument will be followed.
 *
 * History: - Creation 1.0
 *
 * @author nh
 * @version 1.0
 * @see PRePMain, TagList, PRePTag
 */
package com.delec.prep;

import java.io.*;
import java.util.*;

public class PRePTagEXEC extends PRePTagCode
{
	/**
	* value of the tag
	*/
	String value;

	/**
	* Constructor
	*/
	public PRePTagEXEC()
	{
		super("EXEC");
	}

	public File makeFile(Session session, String strPrefix, String strSuffix, String strPath)
	{
		File file = null;
		try
		{

			if ( strPath.equals("") )
			{
				file = File.createTempFile(strPrefix, strSuffix);
			}
			else
			{
				file = File.createTempFile(strPrefix, strSuffix, new File(strPath));
			}

			file.deleteOnExit();
		}
		catch ( IOException e )
		{
			exception(session, e, "Exception during creating the temp files");
		}

		return file;
	}

	public void writeTextToFile(PRePTag prepTag, Session session, File file)
	{
		try
		{
			prepTag = session.getTagList().find(prepTag.getValue());
			FileWriter fileWriter = new FileWriter(file);
			PrintWriter printWriter = new PrintWriter(fileWriter);
			prepTag.compile(session, printWriter);
			printWriter.close();
			fileWriter.close();
			printWriter = null;
			fileWriter = null;
		}
		catch ( Exception e )
		{
			session.getExceptionList().addElement(new PRePException(this, e));
		}
	}

	public void compile(Session session)
	{
		TagList tagList = session.getTagList();

		int iArgs = getArgCount(tagList);

		if ( iArgs >= 4 )
		{
			String strPath = "";

			if ( iArgs == 5 )
			{
				strPath = getArg(tagList, 5).getAllValue();
			}

			File fileBatch = makeFile(session, "batch", ".bat", strPath);
			File fileText = makeFile(session, "text", ".txt", strPath);

			writeTextToFile(getArg(tagList, 1), session, fileBatch);
			writeTextToFile(getArg(tagList, 2), session, fileText);

			int iErrorcode = 0;
			String strText = "";
			Process process = null;

			try
			{
				Runtime runtime = Runtime.getRuntime();
				process = runtime.exec(fileBatch.toString()+" "+fileText.toString());

				BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));

				String strLine = br.readLine();

				while ( strLine != null )
				{
					strText = strText+strLine+"\r\n";
					strLine = br.readLine();
				}

				iErrorcode = process.waitFor();
				int iExit = process.exitValue();        

				PRePTagText pttOutputText = new PRePTagText("EXEC_MESSAGE", strText);
				session.getTagList().addElement(pttOutputText);

				String strResult;

				if ( iErrorcode > 0 )
				{
					PRePTag ptSuccess =  getArg(tagList, 4);
					ptSuccess = tagList.find(ptSuccess.getAllValue());

					if (ptSuccess != null)
					{
						ptSuccess.compile(session);
					}
				}
				else
				{
					PRePTag ptFailed = getArg(tagList, 3);
					ptFailed = tagList.find(ptFailed.getAllValue());

					if (ptFailed != null)
					{
						ptFailed.compile(session);
					}
				}

				//session.getPrintWriter().print(strResult);
				//session.getPrintWriter().flush();
			}
			catch ( Exception e )
			{
				exception(session, e, "Exception during processing the instruction");
			}
			fileBatch.delete();
			fileText.delete();
		}
		else
		{
			exception(session, "Arguments missing");
		}   
	}
}
