/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Versin 1.0
 *
 * PRePTagIMG: adds a HEIGHT and a WIDTH tag to the taglist, which
 *             represent the picture's height and width and creates a
 *             <PRE><IMG SRC... ></PRE> tag
 *
 *             use it the following way: 
 *             {IMG::webroot::fileroot::file_name::other_attributes}
 *
 *             returns a HTML tag like this:
 *             <PRE><IMG SRC="http://www.anything..." WIDTH=some_nbr HEIGHT=some_nbr other_att></PRE>
 *
 * History: - Creation 02/16/99 nh
 *
 * Date: 02/16/99
 *
 * @author nh
 * @version 1.0
 */

package com.delec.prep;

import javax.swing.*;

public class PRePTagIMG extends PRePTagCode
{

	public PRePTagIMG()
	{
		super("IMG");
	}



	public void compile(Session session)
	{
		TagList tagList = session.getTagList();

		PRePTagCount prepTagCount = (PRePTagCount)tagList.find("ARG0");

		if ( prepTagCount != null )
		{
			if ( prepTagCount.getIntValue() >= 3 )
			{
				PRePTag prepTagWebroot = tagList.find("ARG1");
				PRePTag prepTagFileroot = tagList.find("ARG2");
				PRePTag prepTagFilename = tagList.find("ARG3");

				String strWebroot = prepTagWebroot.getValue();
				String strFileroot = prepTagFileroot.getValue();
				String strFilename = prepTagFilename.getValue();

				strWebroot = strWebroot+strFilename;

				char chSeparator = java.io.File.separatorChar;  

				strFilename = strFileroot+strFilename.replace('/', chSeparator);

				ImageIcon img = new ImageIcon(strFilename);

				int iHeight = img.getIconHeight();
				int iWidth = img.getIconWidth();

				String strHTMLImg = "<IMG SRC=\""+strWebroot;
				strHTMLImg = strHTMLImg+"\" WIDTH=\""+iWidth+"\" HEIGHT=\""+iHeight+"\"";

				PRePTag prepTagOther = tagList.find("ARG4");

				if ( prepTagOther != null )
				{
					strHTMLImg = strHTMLImg+" "+prepTagOther.getValue();
				}

				strHTMLImg = strHTMLImg+">";

				session.getPrintWriter().print(strHTMLImg);
			}
			else
			{
				session.getExceptionList().addElement(new PRePException(this, "'arguments missing'"));
			}

		}
		else
		{
			session.getExceptionList().addElement(new PRePException(this, "'no arguments'"));
		}



	}

}
