/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagLIST: Defines LIST, defines a specified tag for a whole specified list
 *
 * History: - Creation nh
 *
 * @author nh
 * @version 1.0
 * @see PRePMain, TagList, PRePTag, PRePTagCode
 */
package com.delec.prep;
import java.io.*;
import java.util.*;

public class PRePTagLIST extends PRePTagCode
{
	/**
	 * value of the tag
	 */
	String value;

	/**
	 * Constructor
	 */
	public PRePTagLIST()
	{
		super("LIST");
	}

	/**
	 * @param PrintWriter writer to compile the tag to
	 * @param TagList where the tags are stored
	 */
	public void compile(Session session) 
	{
		PRePTag tagNewValue = session.getTagList().find("ARG2");
		String strNewValue = "";

		if ( tagNewValue != null )
		{
			PRePTagCount tagCount = (PRePTagCount) session.getTagList().find("ARG0");
			if ( tagCount != null )
			{
				if ( tagCount.getIntValue() == 2 )
				{
					String strValue = tagNewValue.getAllValue(); //ARG2 (Taq)
					//tagNewValue = session.getTagList().find(strValue); 
					tagNewValue = session.getTagList().find("ARG1"); //ARG1 (List)
					strNewValue = tagNewValue.getAllValue(); 
					tagNewValue = session.getTagList().find(strNewValue); //list text
					PRePTagText prepDummy = new PRePTagText("dummy");
					if ( tagNewValue != null )
					{
						strNewValue = tagNewValue.getAllValue().trim();
						int iIndex = 0;
						String strNewSubstring = "";
						boolean booEmptyValue = (strNewValue.length() == 0);

						if ( strNewValue.indexOf('\r') == -1 )
						{
							strNewSubstring = "{"+strValue+"::"+tagNewValue.getAllValue()+"}";
						}
						else
						{
						    int iPosR = strNewValue.indexOf('\r', iIndex);
							
						    while ( iPosR != -1 )
							{
								String strSubstring = strNewValue.substring(iIndex, iPosR);

								if ( !(strSubstring.equals("")) )
								{
									strNewSubstring = strNewSubstring + "{"+strValue+"::"+strSubstring+"}";
								}
							               
								iIndex = iPosR;
								iIndex+= 2;
								iPosR = strNewValue.indexOf('\r', iIndex);
							}

							if ( iIndex > 0 )
							{

								if ( iIndex != strNewValue.length() )
								{
									strNewSubstring = strNewSubstring + "{"+strValue+"::"+strNewValue.substring(iIndex)+"}";
								}
							}
						}
						if ( !booEmptyValue )
						{
							prepDummy.setValue(strNewSubstring);
							prepDummy.compile(session);
						}
					}
					else
					{
						session.getExceptionList().addElement(new PRePException(this, "'argument not valid'"));
					}
				}
				else
				{
					session.getExceptionList().addElement(new PRePException(this, "'arguments missing'"));
				}
			}
			else
			{
				session.getExceptionList().addElement(new PRePException(this, "'No arguments'"));
			}
		}
		else
		{
			session.getExceptionList().addElement(new PRePException(this, "'Missing Tag'"));
		}
	}
}

