/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagSession: stores all objects which are used for one user
 *
 * History: - Creation nh
 *             
 * @author nh
 * @version 1.0
 */

package com.delec.prep;
import java.io.*;
import java.util.*;

public class Session 
{
	protected Hashtable hashtable;
	protected TagList tagList = null;
	protected Object user = null;
	protected PrintWriter pwriter = null;
	protected ExceptionList exceptionList = null;
	protected SQLServe sqlServe = null;
	protected PRePMain prepMain = null;

	public Session() 
	{
		hashtable = new Hashtable();
		tagList = new TagList();
		exceptionList = new ExceptionList();
	}

	/**
	 * put an object with a specified key object
	 * @param Object key 
	 * @param Object value
	 */
	public void put(Object key, Object value)
	{
		hashtable.put(key, value);
	}

	/**
	 * gets an object, specified with the key object
	 * @param Object key
	 * @return value
	 */
	public Object get(Object key) 
	{
		return hashtable.get(key);
	}

	/**
	 * remove an object, specified with the key object
	 * @param Object key
	 * @return value
	 */
	public Object remove(Object key)
	{
		return hashtable.remove(key);
	}

	/**
	 * returns the hashtable content as a string
	 * @return hashtable content
	 */
	public String toString()
	{
		return hashtable.toString();
	}

	/**
	 * sets the actual TagList
	 * @param TagList 
	 */
	public void setTagList(TagList tagList)
	{
		this.tagList = tagList;
	}

	/**
	 * gets the actual TagList that has been set by setTagList
	 * @return the actual TagList
	 */
	public TagList getTagList()
	{
		return tagList;
	}

	public void setPRePMain(PRePMain prepMain)
	{
		this.prepMain = prepMain;
	}

	public PRePMain getPRePMain()
	{
		return prepMain;
	}

	public void setSQLServe(SQLServe sqlServe)
	{
		this.sqlServe = sqlServe;
	}

	public SQLServe getSQLServe()
	{
		return sqlServe;
	}

	/**
	 * sets the User object for the session. Will be used by prep tags to retrieve user settings
	 * @param Object User object for the session
	 */
	public void setUser(Object user) 
	{
		this.user = user;
	}

	/**
	 * gets the actual User that has been set by setUser
	 * @return the actual User object
	 */
	public Object getUser()
	{
		return user;
	}

	/**
	 * sets the actual PrintWriter for the session. Use getPrintWriter to retrieve it again
	 * @param PrintWriter actual PrintWriter
	 */
	public void setPrintWriter(PrintWriter pwriter)
	{
		this.pwriter = pwriter;
	}

	/**
	 * gets the actual PrintWriter that has been set by setPrintWriter
	 * @return the actual PrintWriter
	 */
	public PrintWriter getPrintWriter()
	{
		return pwriter;
	}

	public void setExceptionList(ExceptionList exceptionList)
	{
		this.exceptionList = exceptionList;
	}

	public ExceptionList getExceptionList()
	{
		return exceptionList;
	}

}
