/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.Services;

import cern.lhcias.csgui.Events.AlarmEvent;
import cern.lhcias.csgui.interfaces.AlarmListener;
import java.beans.PropertyVetoException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import symantec.itools.multimedia.SoundPlayer;
import symantec.itools.net.RelativeURL;

public class Alarm
implements AlarmListener {
    SoundPlayer audio;
    boolean audio_flag = false;
    long previousTime;

    public Alarm(String string) {
        if (string != null) {
            this.SetAlarmSrc(string);
        }
    }

    public void SetAlarmSrc(String string) {
        this.audio_flag = false;
        this.audio = new SoundPlayer();
        try {
            URL[] uRLArray = new URL[]{RelativeURL.getURL(string)};
            this.audio.setURLList(uRLArray);
            this.audio_flag = true;
            return;
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Error :" + malformedURLException);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public boolean GetStatus() {
        return this.audio_flag;
    }

    public void receiveAlarm(AlarmEvent alarmEvent) {
        System.out.println(String.valueOf(new Date(alarmEvent.date).toGMTString()) + ":" + alarmEvent.group + ":" + alarmEvent.text);
        this.play();
    }

    public void play() {
        if (this.audio != null && this.audio_flag && new Date().getTime() - this.previousTime > 1000L) {
            this.audio.play();
            this.previousTime = new Date().getTime();
        }
    }

    public void on() {
        if (this.audio != null) {
            this.audio_flag = true;
        }
    }

    public void off() {
        this.audio_flag = false;
    }
}

