/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.TagsView;

import cern.lhcias.csgui.Events.AlarmAdapter;
import cern.lhcias.csgui.Events.OpenViewAdapter;
import cern.lhcias.csgui.Events.TagChangeAdapter;
import cern.lhcias.csgui.Events.TagChangeEvent;
import cern.lhcias.csgui.Events.TagClickedAdapter;
import cern.lhcias.csgui.Events.TagClickedEvent;
import cern.lhcias.csgui.Services.configurationMgr;
import cern.lhcias.csgui.Utils.Evaluate;
import cern.lhcias.csgui.Utils.dgslStatement;
import cern.lhcias.csgui.interfaces.AlarmListener;
import cern.lhcias.csgui.interfaces.OpenViewListener;
import cern.lhcias.csgui.interfaces.TagArrays;
import cern.lhcias.csgui.interfaces.TagClickedListener;
import cern.lhcias.csgui.interfaces.TagsView;
import cern.lhcias.csgui.rtdb.Tag;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import symantec.itools.awt.HorizontalSlider;
import symantec.itools.awt.VerticalSlider;
import symantec.itools.awt.util.ProgressBar;

public class JComptagView
extends Panel
implements TagsView {
    public static final int TEXTLABEL_TYPE = 0;
    public static final int HSLIDER_TYPE = 1;
    public static final int VSLIDER_TYPE = 2;
    public static final int BUTTON_TYPE = 3;
    public static final int PROGRESSBAR_TYPE = 4;
    public static final int TEXTFIELD_TYPE = 5;
    public int display_type = -1;
    TagChangeAdapter TCadapter;
    TagArrays ta;
    String Tagname = "";
    Label labelComponent;
    HorizontalSlider hSlider;
    VerticalSlider vSlider;
    Button button;
    ProgressBar progressBar;
    TextField textField;
    Component current_component;
    CMouse cMouse = new CMouse();
    SymAction lSymAction = new SymAction();
    int minValue;
    int maxValue;
    int tickFreq;
    boolean limitsSet = false;
    boolean IsStatement = false;
    String Tags;
    dgslStatement ip;
    Vector myListeners = new Vector();

    public JComptagView() {
        this.setLayout(null);
    }

    void button_MouseClicked(MouseEvent mouseEvent) {
        this.setValue(1);
    }

    public synchronized void addTagClickedListener(TagClickedListener tagClickedListener) {
        this.myListeners.addElement(tagClickedListener);
    }

    public synchronized void removeTagClickedListener(TagClickedListener tagClickedListener) {
        this.myListeners.removeElement(tagClickedListener);
    }

    void fireTagClickedEvent(String string) {
        TagClickedEvent tagClickedEvent = new TagClickedEvent(this);
        tagClickedEvent.setTagName(string);
        int n = 0;
        while (n < this.myListeners.size()) {
            ((TagClickedListener)this.myListeners.elementAt(n)).receiveTagClicked(tagClickedEvent);
            ++n;
        }
    }

    public void addOpenViewListener(OpenViewListener openViewListener) {
    }

    public void removeOpenViewListener(OpenViewListener openViewListener) {
    }

    public void addAlarmListener(AlarmListener alarmListener) {
    }

    public void removeAlarmListener(AlarmListener alarmListener) {
    }

    public void instantiate(TagArrays tagArrays, String string, TagChangeAdapter tagChangeAdapter, TagClickedAdapter tagClickedAdapter, OpenViewAdapter openViewAdapter, configurationMgr configurationMgr2, AlarmAdapter alarmAdapter) {
        if (this.display_type == -1) {
            System.out.println("Component Type undefined");
            return;
        }
        this.TCadapter = tagChangeAdapter;
        this.ta = tagArrays;
        if (string.startsWith("$") || string.startsWith("@")) {
            this.IsStatement = true;
        }
        this.Tagname = string;
        if (!this.IsStatement) {
            if (!this.ta.tagExist(string)) {
                this.ta.addTag(string);
            }
        } else {
            this.ip = new dgslStatement(2, string, this.ta);
            this.Tags = this.ip.getTagNames();
        }
        switch (this.display_type) {
            case 0: {
                this.add((Component)this.labelComponent, 0);
                this.labelComponent.setBackground(Color.white);
                this.labelComponent.setForeground(Color.black);
                break;
            }
            case 4: {
                this.add((Component)this.progressBar, 0);
                break;
            }
            case 5: {
                this.add((Component)this.textField, 0);
                this.textField.addActionListener(this.lSymAction);
                break;
            }
            case 3: {
                this.button.setLabel(string);
                this.button.setBackground(new Color(0xC0C0C0));
                this.add((Component)this.button, 0);
                break;
            }
            case 1: {
                try {
                    this.hSlider.setMaxValue(11);
                    this.maxValue = 11;
                }
                catch (PropertyVetoException propertyVetoException) {}
                try {
                    this.hSlider.setMinValue(0);
                    this.minValue = 0;
                }
                catch (PropertyVetoException propertyVetoException) {}
                try {
                    this.hSlider.setTickFreq(1);
                    this.tickFreq = 1;
                    this.limitsSet = true;
                }
                catch (PropertyVetoException propertyVetoException) {}
                this.hSlider.setBackground(new Color(0xC0C0C0));
                this.add((Component)this.hSlider, 0);
                this.hSlider.addActionListener(this.lSymAction);
                break;
            }
            case 2: {
                try {
                    this.vSlider.setMaxValue(11);
                    this.maxValue = 11;
                }
                catch (PropertyVetoException propertyVetoException) {}
                try {
                    this.vSlider.setMinValue(0);
                    this.minValue = 0;
                }
                catch (PropertyVetoException propertyVetoException) {}
                try {
                    this.vSlider.setTickFreq(1);
                    this.tickFreq = 1;
                    this.limitsSet = true;
                }
                catch (PropertyVetoException propertyVetoException) {}
                this.vSlider.setBackground(new Color(0xC0C0C0));
                this.add((Component)this.vSlider, 0);
                this.vSlider.addActionListener(this.lSymAction);
            }
        }
        this.current_component.addMouseListener(this.cMouse);
        this.repaint();
        tagChangeAdapter.subscribeTagList(this, this.getTagNames());
    }

    public void setProperty(String string, String string2, String string3) {
        if (string2.equalsIgnoreCase("DISPLAY_TYPE")) {
            if (string3.equalsIgnoreCase("TextLabel")) {
                this.labelComponent = new Label();
                if (this.labelComponent != null) {
                    this.display_type = 0;
                    this.current_component = this.labelComponent;
                }
            }
            if (string3.equalsIgnoreCase("HSlider")) {
                this.hSlider = new HorizontalSlider();
                if (this.hSlider != null) {
                    this.current_component = this.hSlider;
                    this.display_type = 1;
                }
            }
            if (string3.equalsIgnoreCase("VSlider")) {
                this.vSlider = new VerticalSlider();
                if (this.vSlider != null) {
                    this.current_component = this.vSlider;
                    this.display_type = 2;
                }
            }
            if (string3.equalsIgnoreCase("Button")) {
                this.button = new Button();
                if (this.button != null) {
                    this.current_component = this.button;
                    this.display_type = 3;
                }
            }
            if (string3.equalsIgnoreCase("ProgressBar")) {
                this.progressBar = new ProgressBar();
                if (this.progressBar != null) {
                    this.current_component = this.progressBar;
                    this.display_type = 4;
                }
            }
            if (string3.equalsIgnoreCase("TextField")) {
                this.textField = new TextField();
                if (this.textField != null) {
                    this.current_component = this.textField;
                    this.display_type = 5;
                }
            }
        }
        if (string2.equalsIgnoreCase("LABEL") && this.display_type == 3 && this.button != null) {
            this.button.setLabel(string3);
        }
    }

    public void setConfig(String string) {
        if (string.startsWith("$")) {
            this.IsStatement = true;
        }
        this.Tagname = string;
        if (!this.IsStatement) {
            if (!this.ta.tagExist(this.Tagname)) {
                this.ta.addTag(this.Tagname);
                return;
            }
        } else {
            this.ip = new dgslStatement(2, string, this.ta);
            this.Tags = this.ip.getTagNames();
        }
    }

    public void receiveTagChange(TagChangeEvent tagChangeEvent) {
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.current_component.getPreferredSize();
    }

    public void repaint() {
        switch (this.display_type) {
            case 5: {
                String string = this.get_current_value();
                if (string == null) break;
                if (!this.Tagname.startsWith("@") || string.length() > 0) {
                    ((TextComponent)this.textField).setText(string);
                }
                return;
            }
            case 4: {
                try {
                    this.progressBar.setValue(new Double(this.get_double_value()).intValue());
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            case 0: {
                String string = this.get_current_value();
                if (string == null) break;
                this.labelComponent.setText(string);
                return;
            }
            case 1: {
                double[] dArray = this.get_tag_limits();
                int n = new Double(dArray[0]).intValue();
                int n2 = new Double(dArray[1]).intValue() + 1;
                int n3 = new Double((dArray[1] - dArray[0]) / 10.0).intValue();
                if (n3 < 1) {
                    n3 = 1;
                }
                try {
                    if (n != n2) {
                        if (this.limitsSet) {
                            if (this.minValue != n) {
                                this.hSlider.setMinValue(n);
                                this.minValue = n;
                            }
                            if (this.maxValue != n2) {
                                this.hSlider.setMaxValue(n2);
                                this.minValue = n2;
                            }
                            if (this.tickFreq != n3) {
                                this.hSlider.setMaxValue(n3);
                                this.tickFreq = n3;
                            }
                        } else {
                            this.hSlider.setMinValue(n);
                            this.minValue = n;
                            this.hSlider.setMaxValue(n2);
                            this.minValue = n2;
                            this.hSlider.setMaxValue(n3);
                            this.tickFreq = n3;
                            this.limitsSet = true;
                        }
                    }
                    this.hSlider.removeActionListener(this.lSymAction);
                    this.hSlider.setValue(new Double(this.get_double_value()).intValue());
                    this.hSlider.addActionListener(this.lSymAction);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
            case 2: {
                double[] dArray = this.get_tag_limits();
                int n = new Double(dArray[0]).intValue();
                int n4 = new Double(dArray[1]).intValue() + 1;
                int n5 = new Double((dArray[1] - dArray[0]) / 10.0).intValue();
                if (n5 < 1) {
                    n5 = 1;
                }
                try {
                    if (n != n4) {
                        if (this.limitsSet) {
                            if (this.minValue != n) {
                                this.vSlider.setMinValue(n);
                                this.minValue = n;
                            }
                            if (this.maxValue != n4) {
                                this.vSlider.setMaxValue(n4);
                                this.minValue = n4;
                            }
                            if (this.tickFreq != n5) {
                                this.vSlider.setMaxValue(n5);
                                this.tickFreq = n5;
                            }
                        } else {
                            this.vSlider.setMinValue(n);
                            this.minValue = n;
                            this.vSlider.setMaxValue(n4);
                            this.minValue = n4;
                            this.vSlider.setMaxValue(n5);
                            this.tickFreq = n5;
                            this.limitsSet = true;
                        }
                    }
                    this.vSlider.removeActionListener(this.lSymAction);
                    this.vSlider.setValue(new Double(this.get_double_value()).intValue());
                    this.vSlider.addActionListener(this.lSymAction);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.display_type > -1 && this.current_component != null) {
            this.current_component.setBounds(0, 0, n3, n4);
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.display_type > -1 && this.current_component != null) {
            this.current_component.addMouseListener(mouseListener);
        }
    }

    public Vector getTagNames() {
        if (!this.IsStatement) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(this.Tagname);
            return vector;
        }
        if (this.ip != null) {
            Vector vector = this.ip.getTagNamesAsVector();
            return vector;
        }
        return new Vector();
    }

    public String toString() {
        return this.Tagname;
    }

    public boolean doYouImplement(String string) {
        if (string.equalsIgnoreCase("TextLabel")) {
            return true;
        }
        if (string.equalsIgnoreCase("HSlider")) {
            return true;
        }
        if (string.equalsIgnoreCase("VSlider")) {
            return true;
        }
        if (string.equalsIgnoreCase("Button")) {
            return true;
        }
        if (string.equalsIgnoreCase("ProgressBar")) {
            return true;
        }
        return string.equalsIgnoreCase("TextField");
    }

    public Vector getPossibleTypes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("TextLabel");
        vector.addElement("HSlider");
        vector.addElement("VSlider");
        vector.addElement("Button");
        vector.addElement("ProgressBar");
        vector.addElement("TextField");
        return vector;
    }

    public int getComponentNb() {
        return 0;
    }

    public Vector getComponentsList() {
        return null;
    }

    public Vector getLocalTagNames() {
        return this.getTagNames();
    }

    public String getType() {
        switch (this.display_type) {
            case 0: {
                return "TextLabel";
            }
            case 1: {
                return "HSlider";
            }
            case 2: {
                return "VSlider";
            }
            case 3: {
                return "Button";
            }
            case 4: {
                return "ProgressBar";
            }
            case 5: {
                return "TextField";
            }
        }
        return "UNKNOWN_TYPE";
    }

    public void addTag(String string) {
        if (this.ta != null && this.TCadapter != null) {
            this.IsStatement = false;
            if (string.startsWith("(")) {
                this.IsStatement = true;
            }
            this.Tagname = string;
            if (!this.IsStatement) {
                if (!this.ta.tagExist(string)) {
                    this.ta.addTag(string);
                }
            } else {
                this.ip = new dgslStatement(2, string, this.ta);
                this.Tags = this.ip.getTagNames();
            }
            this.TCadapter.subscribeTagList(this, this.getTagNames());
            return;
        }
        System.out.println("JComptagView not properly initialised\n");
    }

    public void addTag(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (string != null) {
                this.addTag(string);
                return;
            }
            ++n;
        }
    }

    public void addTag(TagsView tagsView) {
        this.addTag(tagsView.getTagNames());
    }

    public void removeTag(String string) {
        this.IsStatement = false;
        if (this.Tagname.equals(string)) {
            this.Tagname = "";
        }
        if (this.ta != null && this.TCadapter != null) {
            this.TCadapter.subscribeTagList(this, this.getTagNames());
            return;
        }
        System.out.println("JComptagView not properly initialised\n");
    }

    public void removeTag(Vector vector) {
        if (vector != null && vector.contains(this.Tagname)) {
            this.removeTag(this.Tagname);
        }
    }

    public void removeTag(TagsView tagsView) {
        this.removeTag(tagsView.getTagNames());
    }

    double[] get_tag_limits() {
        if (this.display_type == -1) {
            return new double[2];
        }
        if (!this.IsStatement) {
            Tag tag = this.ta.getTag(this.Tagname);
            if (tag == null) {
                return new double[2];
            }
            return tag.getLimits();
        }
        double[] dArray = Evaluate.getRange(this.ip.getOValidity());
        if (dArray[0] == 1.0 && dArray[1] == -1.0) {
            dArray[0] = 0.0;
            dArray[1] = 100.0;
        }
        return dArray;
    }

    double get_double_value() {
        if (this.display_type == -1) {
            return 0.0;
        }
        if (!this.IsStatement) {
            Tag tag = this.ta.getTag(this.Tagname);
            if (tag == null) {
                return 0.0;
            }
            return tag.doubleValue();
        }
        if (this.ip != null && this.ip.get_load_value()) {
            return this.ip.getDoubleValue();
        }
        return 0.0;
    }

    String get_current_value() {
        if (this.display_type == -1) {
            return "";
        }
        if (!this.IsStatement) {
            Tag tag = this.ta.getTag(this.Tagname);
            if (tag == null) {
                return null;
            }
            return tag.stringValue();
        }
        if (this.ip != null) {
            return this.ip.getStringValue();
        }
        return "";
    }

    void setStatementValue(String string) {
        if (this.display_type > -1) {
            if (!this.IsStatement) {
                this.ta.setValue(this.Tagname, string);
                return;
            }
            Vector<String> vector = new Vector<String>();
            vector.addElement("input");
            vector.addElement(string);
            this.ip.setValues(vector);
        }
    }

    void setValue(int n) {
        this.setStatementValue(Integer.toString(n));
    }

    void setValue(String string) {
        this.setStatementValue(string);
    }

    class CMouse
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object;
            if (JComptagView.this.display_type == 3 && (object = mouseEvent.getSource()) == JComptagView.this.button) {
                JComptagView.this.button_MouseClicked(mouseEvent);
            }
            if (JComptagView.this.Tagname.length() > 0) {
                JComptagView.this.fireTagClickedEvent(JComptagView.this.Tagname);
            }
        }

        CMouse() {
            JComptagView.this = JComptagView.this;
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (JComptagView.this.display_type == 1 && object == JComptagView.this.hSlider) {
                JComptagView.this.setValue(JComptagView.this.hSlider.getValue());
            }
            if (JComptagView.this.display_type == 2 && object == JComptagView.this.vSlider) {
                JComptagView.this.setValue(JComptagView.this.vSlider.getValue());
            }
            if (JComptagView.this.display_type == 5 && object == JComptagView.this.textField) {
                JComptagView.this.setValue(JComptagView.this.textField.getText());
            }
        }

        SymAction() {
            JComptagView.this = JComptagView.this;
        }
    }
}

