/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.rtdb;

import cern.lhcias.csgui.interfaces.tagHistory;
import java.util.Date;

public class Trend
implements tagHistory {
    public static final int MAX_VALUES = 100;
    public int nb_values;
    private double[] value = new double[100];
    private long[] date = new long[100];
    private boolean[] value_set = new boolean[100];

    public Trend() {
        this.initHistory();
    }

    public void initHistory() {
        this.nb_values = 0;
    }

    public void initHistory(int n) {
        if (n >= 100) {
            n = 100;
        }
        int n2 = this.nb_values;
        while (n2 < n) {
            this.value_set[n2] = false;
            ++n2;
        }
        this.nb_values = n;
    }

    public int getMaximumDepth() {
        return 100;
    }

    public int getHistoryDepth() {
        return this.nb_values;
    }

    public double[] getDoubleValues() {
        return this.value;
    }

    public int[] getIntValues() {
        int[] nArray = new int[this.nb_values];
        int n = 0;
        while (n < this.nb_values) {
            nArray[n] = new Double(this.value[n]).intValue();
            ++n;
        }
        return nArray;
    }

    public long[] getDates() {
        return this.date;
    }

    public boolean[] getValidities() {
        return this.value_set;
    }

    public String toString() {
        String string = new String();
        int n = 0;
        while (n < this.nb_values) {
            if (this.value_set[n]) {
                string = string.concat(String.valueOf(String.valueOf(this.value[n])) + "," + new Date(this.date[n]).toGMTString() + "\n");
            }
            ++n;
        }
        return string;
    }

    public void insertValue(int n) {
        this.insertValue(new Integer(n).doubleValue());
    }

    public void insertValue(double d) {
        this.insertValue(d, new Date().getTime());
    }

    public void insertValue(int n, long l) {
        this.insertValue(new Integer(n).doubleValue(), new Date().getTime());
    }

    public void insertValue(double d, long l) {
        if (this.nb_values < 100) {
            this.value[this.nb_values] = d;
            this.date[this.nb_values] = l;
            this.value_set[this.nb_values] = true;
            ++this.nb_values;
            return;
        }
        int n = 0;
        while (n < 99) {
            this.value[n] = this.value[n + 1];
            this.date[n] = this.date[n + 1];
            ++n;
        }
        this.value[this.nb_values - 1] = d;
        this.date[this.nb_values - 1] = l;
        this.value_set[this.nb_values - 1] = true;
    }

    public void insertInvalidValue() {
        this.insertInvalidValue(new Date().getTime());
    }

    public void insertInvalidValue(long l) {
        if (this.nb_values < 100) {
            this.date[this.nb_values] = l;
            this.value_set[this.nb_values] = false;
            ++this.nb_values;
            return;
        }
        int n = 0;
        while (n < 99) {
            this.value[n] = this.value[n + 1];
            this.date[n] = this.date[n + 1];
            ++n;
        }
        this.date[this.nb_values - 1] = l;
        this.value_set[this.nb_values - 1] = false;
    }
}

