/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import jclass.chart.ChartText;
import jclass.chart.ErrorDialog;
import jclass.chart.JCAxis;
import jclass.chart.JCChartBundle;
import jclass.chart.JCValueLabel;
import jclass.util.JCString;
import jclass.util.JCVector;

abstract class AxisHandler {
    JCAxis parent;
    double shift;
    double scale = 1.0;

    AxisHandler() {
    }

    void setParent(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    static AxisHandler makeAxisHandler(JCAxis jCAxis) {
        AxisHandler axisHandler = null;
        try {
            axisHandler = jCAxis.isLogarithmic ? (AxisHandler)Class.forName("jclass.chart.LogAxisHandler").newInstance() : (AxisHandler)Class.forName("jclass.chart.LinearAxisHandler").newInstance();
        }
        catch (Exception exception) {
            axisHandler = null;
        }
        if (axisHandler != null) {
            axisHandler.setParent(jCAxis);
        }
        return axisHandler;
    }

    abstract double toData(int var1);

    abstract int toPixel(double var1);

    abstract void calcParams();

    abstract void calcTransformation();

    boolean fixBounds() {
        if (!this.parent.min.isDefault && !this.parent.max.isDefault && this.parent.min.value >= this.parent.max.value) {
            String string = JCChartBundle.string("jclass.chart.Key105");
            string = String.valueOf(string) + JCChartBundle.string("jclass.chart.Key130");
            ErrorDialog.raise(this.parent, string);
            this.parent.max.isDefault = true;
            return true;
        }
        return false;
    }

    void drawTicks(Graphics graphics) {
        int n = this.parent.linePosition();
        JCVector jCVector = this.parent.getAnnotations();
        int n2 = 0;
        while (n2 < jCVector.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)jCVector.elementAt(n2);
            if (jCValueLabel.getChartText().isShowing) {
                int n3 = this.parent.toPixel(jCValueLabel.value);
                this.drawTick(graphics, n, n3);
            }
            ++n2;
        }
    }

    protected void drawTick(Graphics graphics, int n, int n2) {
        if (this.parent.isVertical) {
            graphics.drawLine(n - this.parent.tickLength / 2, n2, n + this.parent.tickLength / 2, n2);
            return;
        }
        graphics.drawLine(n2, n - this.parent.tickLength / 2, n2, n + this.parent.tickLength / 2);
    }

    abstract String format(double var1, int var3);

    abstract double range();

    abstract void translate(double var1);

    abstract void calcPrecision();

    void getAnnoExtent(Dimension dimension, double d, int n) {
        Dimension dimension2;
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.parent.getFont());
        }
        catch (Exception exception) {}
        if (fontMetrics == null) {
            return;
        }
        if (this.parent.labelGenerator != null) {
            Object object = this.parent.labelGenerator.makeLabel(d, n);
            if (object == null) {
                return;
            }
            if (object instanceof JCString) {
                JCString jCString = (JCString)object;
                dimension2 = jCString.getSize(this.parent.parent, this.parent.getFont());
            } else if (object instanceof ChartText) {
                ChartText chartText = (ChartText)object;
                chartText.setParent(this.parent.getParent());
                dimension2 = new Dimension(chartText.getWidth(), chartText.getHeight());
            } else {
                String string = object instanceof String ? (String)object : object.toString();
                dimension2 = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
            }
        } else {
            String string = this.format(d, n);
            dimension2 = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
        }
        if (this.parent.annotationRotation == 0) {
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
                return;
            }
        } else {
            if (dimension.width < dimension2.height) {
                dimension.width = dimension2.height;
            }
            if (dimension.height < dimension2.width) {
                dimension.height = dimension2.width;
            }
        }
    }
}

