/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.io.Serializable;
import java.util.Vector;
import jclass.chart.ArrayDataInterpretation;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.Chartable;
import jclass.chart.GeneralDataInterpretation;
import jclass.chart.JCChartBundle;

abstract class DataInterpretation
implements Serializable {
    ChartDataView view;

    static DataInterpretation getData(ChartDataView chartDataView, Chartable chartable) {
        DataInterpretation dataInterpretation;
        int n = chartable.getDataInterpretation();
        switch (n) {
            case 0: {
                dataInterpretation = new ArrayDataInterpretation(chartDataView);
                break;
            }
            case 1: {
                dataInterpretation = new GeneralDataInterpretation(chartDataView);
                break;
            }
            default: {
                throw new RuntimeException(JCChartBundle.string("jclass.chart.Key139"));
            }
        }
        dataInterpretation.loadData(chartable);
        return dataInterpretation;
    }

    DataInterpretation(ChartDataView chartDataView) {
        this.view = chartDataView;
    }

    abstract void loadData(Chartable var1);

    abstract boolean editPoint(int var1, int var2, double var3);

    abstract void changeValue(int var1, int var2);

    abstract void addValue(int var1, int var2);

    abstract void addColValues(int var1, int var2, int var3);

    abstract void removeValue(int var1, int var2);

    abstract void changeRow(int var1, int var2);

    abstract void addRow(int var1, int var2);

    abstract void removeRow(int var1, int var2);

    void changeColumn(int n, int n2) {
        int n3 = this.view.dataSource.getNumRows();
        int n4 = 0;
        while (n4 < n3) {
            this.changeValue(n4, n2);
            ++n4;
        }
    }

    void addColumn(int n, int n2) {
        int n3 = this.view.dataSource.getNumRows();
        int n4 = 0;
        while (n4 < n3) {
            this.addValue(n4, n2);
            ++n4;
        }
    }

    void appendColumns(int n, int n2, int n3) {
        int n4 = this.view.dataSource.getNumRows();
        int n5 = 0;
        while (n5 < n4) {
            this.addColValues(n5, n2, n3);
            ++n5;
        }
    }

    void removeColumn(int n, int n2) {
        int n3 = this.view.dataSource.getNumRows();
        int n4 = 0;
        while (n4 < n3) {
            this.removeValue(n4, n2);
            ++n4;
        }
    }

    void changePointLabel(int n, int n2) {
        String[] stringArray = this.view.dataSource.getPointLabels();
        if (n2 == -1) {
            this.view.setPointLabels(stringArray);
            return;
        }
        this.view.pointLabels.setElementAt(n2, stringArray[n2]);
        this.view.setChanged(true, 2);
    }

    abstract void changeSeriesName(int var1, int var2);

    abstract void changeSeriesLabel(int var1, int var2);

    void changePointLabels() {
        this.changePointLabel(0, -1);
    }

    void changeSeriesNames() {
        int n = 0;
        while (n < this.view.getNumSeries()) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n);
            chartDataViewSeries.setName(this.view.dataSource.getSeriesName(n));
            ++n;
        }
    }

    void changeSeriesLabels() {
        int n = 0;
        while (n < this.view.getNumSeries()) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n);
            chartDataViewSeries.setLabel(this.view.dataSource.getSeriesLabel(n));
            ++n;
        }
    }

    void changeName() {
        this.view.setName(this.view.dataSource.getName());
    }

    abstract void reset(int var1, int var2);

    double[] getX(int n) {
        return this.view.toDoubleArray(this.getXVector(n));
    }

    double[] getY(int n) {
        return this.view.toDoubleArray(this.getYVector(n));
    }

    abstract Vector getXVector(int var1);

    abstract Vector getYVector(int var1);

    abstract double getX(int var1, int var2);

    abstract double getY(int var1, int var2);
}

