/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Image;
import java.io.Serializable;
import java.util.Vector;
import jclass.chart.Changeable;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCBorderStyle;
import jclass.chart.JCChart;
import jclass.chart.JCFillStyle;
import jclass.chart.JCLineStyle;
import jclass.chart.JCShape;
import jclass.chart.JCSymbolStyle;

public class JCChartStyle
implements Serializable,
HTMLHandler {
    JCLineStyle lineStyle;
    JCFillStyle fillStyle;
    JCSymbolStyle symbolStyle;
    JCBorderStyle borderStyle;
    Vector parents = new Vector();

    public JCChartStyle(JCLineStyle jCLineStyle, JCFillStyle jCFillStyle, JCSymbolStyle jCSymbolStyle) {
        this.lineStyle = jCLineStyle;
        this.fillStyle = jCFillStyle;
        this.symbolStyle = jCSymbolStyle;
        this.fillStyle.parent = this.symbolStyle.parent = this;
        this.lineStyle.parent = this.symbolStyle.parent;
        this.borderStyle = new JCBorderStyle();
        this.borderStyle.type = 5;
        this.borderStyle.width = 1;
    }

    public JCChartStyle() {
        this.lineStyle = JCLineStyle.makeDefault(null);
        this.fillStyle = JCFillStyle.makeDefault(null);
        this.symbolStyle = JCSymbolStyle.makeDefault(null);
        this.fillStyle.parent = this.symbolStyle.parent = this;
        this.lineStyle.parent = this.symbolStyle.parent;
        this.borderStyle = new JCBorderStyle(null);
        this.borderStyle.type = 5;
        this.borderStyle.width = 1;
    }

    public static JCChartStyle makeDefault(JCChart jCChart) {
        return JCChartStyle.makeDefault(jCChart, null, false);
    }

    public static JCChartStyle makeDefault(JCChart jCChart, Changeable changeable) {
        return JCChartStyle.makeDefault(jCChart, changeable, false);
    }

    public static JCChartStyle makeDefault(JCChart jCChart, Changeable changeable, boolean bl) {
        JCChartStyle jCChartStyle = new JCChartStyle(JCLineStyle.makeDefault(jCChart), JCFillStyle.makeDefault(jCChart, bl), JCSymbolStyle.makeDefault(jCChart));
        if (changeable != null) {
            jCChartStyle.parents.addElement(changeable);
        } else if (jCChart != null) {
            jCChartStyle.parents.addElement(jCChart.chartArea);
        }
        return jCChartStyle;
    }

    public JCLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(JCLineStyle jCLineStyle) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            if (this.lineStyle == jCLineStyle) {
                Object var3_3 = null;
                return;
            }
            this.lineStyle = jCLineStyle;
            this.lineStyle.parent = this;
        }
        this.callParentSetChanged(true, 17);
    }

    public int getLinePattern() {
        if (this.lineStyle == null) {
            return 0;
        }
        return this.lineStyle.getPattern();
    }

    public void setLinePattern(int n) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setPattern(n);
    }

    public int getLineWidth() {
        if (this.lineStyle == null) {
            return 0;
        }
        return this.lineStyle.getWidth();
    }

    public void setLineWidth(int n) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            if (this.lineStyle == null) {
                this.lineStyle = JCLineStyle.makeDefault(null);
            }
        }
        this.lineStyle.setWidth(n);
    }

    public Color getLineColor() {
        if (this.lineStyle == null) {
            return null;
        }
        return this.lineStyle.getColor();
    }

    public void setLineColor(Color color) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            if (this.lineStyle == null) {
                this.lineStyle = JCLineStyle.makeDefault(null);
            }
        }
        this.lineStyle.setColor(color);
    }

    public JCSymbolStyle getSymbolStyle() {
        return this.symbolStyle;
    }

    public void setSymbolStyle(JCSymbolStyle jCSymbolStyle) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            if (this.symbolStyle == jCSymbolStyle) {
                Object var3_3 = null;
                return;
            }
            this.symbolStyle = jCSymbolStyle;
            this.symbolStyle.parent = this;
        }
        this.callParentSetChanged(true, 17);
    }

    public int getSymbolShape() {
        if (this.symbolStyle == null) {
            return 0;
        }
        return this.symbolStyle.getShape();
    }

    public void setSymbolShape(int n) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            if (this.symbolStyle == null) {
                this.symbolStyle = JCSymbolStyle.makeDefault(null);
            }
        }
        this.symbolStyle.setShape(n);
    }

    public Color getSymbolColor() {
        if (this.symbolStyle == null) {
            return null;
        }
        return this.symbolStyle.getColor();
    }

    public void setSymbolColor(Color color) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            if (this.symbolStyle == null) {
                this.symbolStyle = JCSymbolStyle.makeDefault(null);
            }
        }
        this.symbolStyle.setColor(color);
    }

    public int getSymbolSize() {
        if (this.symbolStyle == null) {
            return 0;
        }
        return this.symbolStyle.getSize();
    }

    public void setSymbolSize(int n) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setSize(n);
    }

    public JCShape getSymbolCustomShape() {
        if (this.symbolStyle == null) {
            return null;
        }
        return this.symbolStyle.getCustomShape();
    }

    public void setSymbolCustomShape(JCShape jCShape) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            if (this.symbolStyle == null) {
                this.symbolStyle = JCSymbolStyle.makeDefault(null);
            }
        }
        this.symbolStyle.setCustomShape(jCShape);
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            if (this.fillStyle == jCFillStyle) {
                Object var3_3 = null;
                return;
            }
            this.fillStyle = jCFillStyle;
            this.fillStyle.parent = this;
        }
        this.callParentSetChanged(true, 33);
    }

    public Color getFillColor() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getColor();
    }

    public void setFillColor(Color color) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            if (this.fillStyle == null) {
                this.fillStyle = JCFillStyle.makeDefault(null);
            }
        }
        this.fillStyle.setColor(color);
    }

    public int getFillPattern() {
        if (this.fillStyle == null) {
            return 0;
        }
        return this.fillStyle.getPattern();
    }

    public void setFillPattern(int n) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            if (this.fillStyle == null) {
                this.fillStyle = JCFillStyle.makeDefault(null);
            }
        }
        this.fillStyle.setPattern(n);
    }

    public Image getFillImage() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getImage();
    }

    public void setFillImage(Image image) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            if (this.fillStyle == null) {
                this.fillStyle = JCFillStyle.makeDefault(null);
            }
        }
        this.fillStyle.setImage(image);
    }

    void callParentSetChanged(boolean bl, int n) {
        if (this.parents == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.parents.size()) {
            ((Changeable)this.parents.elementAt(n2)).setChanged(true, n);
            ++n2;
        }
    }

    public void addParent(Changeable changeable) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            int n = 0;
            while (n < this.parents.size()) {
                if (this.parents.elementAt(n) == changeable) {
                    Object var3_4 = null;
                    return;
                }
                ++n;
            }
            this.parents.addElement(changeable);
            return;
        }
    }

    public void removeParent(Changeable changeable) {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            int n = 0;
            while (n < this.parents.size()) {
                if (this.parents.elementAt(n) == changeable) {
                    this.parents.removeElementAt(n);
                }
                ++n;
            }
            return;
        }
    }

    public void clearParents() {
        JCChartStyle jCChartStyle = this;
        synchronized (jCChartStyle) {
            this.parents = new Vector();
            return;
        }
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        this.getLineStyle().saveParams(String.valueOf(string) + ".line", hTMLSaveDriver);
        this.getFillStyle().saveParams(String.valueOf(string) + ".fill", hTMLSaveDriver);
        this.getSymbolStyle().saveParams(String.valueOf(string) + ".symbol", hTMLSaveDriver);
    }

    public void loadParams(String string, JCChart jCChart) {
        this.getLineStyle().loadParams(String.valueOf(string) + ".line", jCChart);
        this.getFillStyle().loadParams(String.valueOf(string) + ".fill", jCChart);
        this.getSymbolStyle().loadParams(String.valueOf(string) + ".symbol", jCChart);
    }
}

