/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.ChartText;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.JCPieChartFormat;
import jclass.chart.PieChartInfo;
import jclass.chart.PieData;
import jclass.chart.PiePercent;
import jclass.chart.PiePosition;
import jclass.chart.PieSortAscending;
import jclass.chart.PieSortDescending;
import jclass.chart.PieSortPoint;
import jclass.util.JCSortInterface;
import jclass.util.JCqsort;

class PieChartDraw
extends ChartDraw {
    public static final int COORD_DEFAULT_VALUE = -2;
    public static final int COORD_ZERO_SLICE = -1;
    public static final int INDEX_HOLE = -2;
    public static final int INDEX_NOT_DRAWN = -1;
    public static final int HIT_NOWHERE = 0;
    public static final int HIT_TOP = 1;
    public static final int HIT_EDGE = 2;
    PieChartInfo pieInfo;
    JCPieChartFormat pcf;
    int delta_y;
    Color outlineColor = Color.black;
    int num_pies;
    int num_lines;
    int num_pies_line;
    int box_width;
    int box_height;
    int pie_offset;
    int first_point;
    int graph_left;
    int graph_top;
    transient ChartText[] cLabels;
    int label_height;
    int explode_offset;

    public void recalc() {
        super.recalc();
        this.calcTransientData();
        this.pieInfo = (PieChartInfo)this.dataObject.getTransientData();
        this.outlineColor = this.dataObject.getOutlineColor();
        Rectangle rectangle = this.chartArea.plotRect;
        this.graph_left = rectangle.x;
        this.graph_top = rectangle.y;
        int n = Math.max(rectangle.width, 0);
        int n2 = Math.max(rectangle.height, 0);
        int n3 = this.dataObject.getNumPointLabels();
        String[] stringArray = new String[n3];
        this.cLabels = new ChartText[n3];
        this.label_height = 0;
        int n4 = 0;
        while (n4 < n3) {
            stringArray[n4] = this.dataObject.getPointLabel(n4);
            if (stringArray[n4] != null) {
                this.cLabels[n4] = new ChartText();
                this.cLabels[n4].setText(stringArray[n4], true);
                this.cLabels[n4].setParent(this.chartArea.getParent());
                this.cLabels[n4].recalc();
                int n5 = this.cLabels[n4].getHeight();
                this.label_height = Math.max(this.label_height, n5);
            } else {
                this.cLabels[n4] = null;
            }
            ++n4;
        }
        this.dataObject.getNumSeries();
        if (this.num_pies == 0) {
            return;
        }
        int[] nArray = this.pieLayout(this.num_pies, rectangle);
        this.num_lines = nArray[0];
        this.num_pies_line = nArray[1];
        this.box_width = n / this.num_pies_line;
        this.box_height = n2 / this.num_lines;
        this.explode_offset = this.pcf.getExplodeList() == null ? 0 : this.pcf.getExplodeOffset();
        int n6 = Math.max(this.box_width - this.label_height * 2 - this.explode_offset * 2, 0);
        int n7 = Math.max(this.box_height - this.label_height * 2 - this.explode_offset * 2, 0);
        double d = this.pcf.getExplodeList() == null ? JCChartUtil.degToRad(Math.max(0, this.chartArea.getElevation())) : 0.0;
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = (double)this.chartArea.getDepth() / 100.0;
        int n8 = 0;
        n8 = (double)n6 * (d3 + d4 * d2) < (double)n7 ? n6 : (int)((double)n7 / (d3 + d4 * d2));
        int n9 = (int)((double)n8 * d3);
        this.chartArea.deltaX = 0;
        this.chartArea.deltaY = this.delta_y = (int)((double)n8 * d4 * d2);
        if (n8 != (n8 | 1)) {
            n8 = (n8 | 1) - 2;
        }
        if (n9 != (n9 | 1)) {
            n9 = (n9 | 1) - 2;
        }
        this.pieInfo.width = n8;
        this.pieInfo.height = n9;
        this.pie_offset = (int)((double)(this.box_width - n8) / 2.0);
        if (this.pie_offset < 0) {
            this.pie_offset = 0;
        }
    }

    public void draw(Graphics graphics) {
        graphics.translate(this.chartArea.plotRect.x, this.chartArea.plotRect.y);
        if (this.pieInfo == null) {
            this.recalc();
        }
        if (this.num_pies == 0) {
            return;
        }
        int n = 0;
        int n2 = this.graph_left;
        int n3 = this.graph_top;
        int n4 = 0;
        while (n4 < this.num_lines) {
            int n5 = 0;
            while (n5 < this.num_pies_line) {
                int n6 = n2 + this.pie_offset;
                int n7 = n3 + (this.box_height - this.pieInfo.height - this.delta_y - this.label_height) / 2;
                if (n < this.num_pies) {
                    ChartText chartText;
                    if (!this.pieInfo.data[n].zero_pie) {
                        if (this.delta_y != 0) {
                            this.drawPiePlane(graphics, this.seriesList, this.pieInfo.data[n], this.pieInfo, n6, n7 + this.delta_y, n, false);
                            this.drawPieEdge(graphics, this.pieInfo.data[n], this.pieInfo, n6, n7);
                        }
                        this.drawPiePlane(graphics, this.seriesList, this.pieInfo.data[n], this.pieInfo, n6, n7, n, true);
                        this.drawPieLines(graphics, this.seriesList, this.pieInfo.data[n], this.pieInfo, n6, n7, n);
                    }
                    if (n + this.first_point < this.cLabels.length && (chartText = this.cLabels[n + this.first_point]) != null) {
                        int n8 = chartText.getWidth();
                        chartText.getHeight();
                        chartText.move(n2 + (this.box_width - n8) / 2, n7 + this.pieInfo.height + this.delta_y + this.explode_offset);
                        chartText.draw(graphics);
                    }
                    if (!this.pieInfo.data[n].zero_pie) {
                        this.drawPieCircle(graphics, this.seriesList, this.pieInfo.data[n], this.pieInfo, n6, n7, n);
                    }
                }
                ++n;
                n2 += this.box_width;
                ++n5;
            }
            n2 = this.graph_left;
            n3 += this.box_height;
            ++n4;
        }
    }

    private int[] pieLayout(int n, Rectangle rectangle) {
        double d;
        int n2 = rectangle.height == 0 ? n : (int)Math.min((double)n, Math.sqrt(n) * (double)rectangle.width / (double)rectangle.height);
        if (n2 < 1) {
            n2 = 1;
        }
        if ((d = (double)(n % n2) / (double)n2) == 0.0) {
            d = 1.0;
        }
        int n3 = n2;
        while (n3 > 1) {
            double d2 = (double)(n % n3) / (double)n3;
            if (d2 > d || d2 == 0.0) {
                n2 = n3;
                if (d2 == 0.0) {
                    d = 1.0;
                    n3 = 1;
                } else {
                    d = d2;
                }
            }
            --n3;
        }
        int n4 = n / n2;
        if ((double)n4 != (double)n / (double)n2) {
            // empty if block
        }
        int[] nArray = new int[]{++n4, n2};
        return nArray;
    }

    private int computeOtherSlice(ChartDataViewSeries[] chartDataViewSeriesArray, int n, int n2, PieData pieData) {
        int n3;
        int n4 = Math.min(n2, this.pcf.getMinSlices());
        double d = this.pcf.getThresholdValue() / 100.0;
        double d2 = 0.0;
        int n5 = 0;
        while (n5 < n2) {
            double d3 = chartDataViewSeriesArray[n5].getY(n);
            pieData.sortPoints[n5].index = n5;
            if (d3 == this.dataObject.getHoleValue() || !chartDataViewSeriesArray[n5].isShowing) {
                d3 = 0.0;
                pieData.sortPoints[n5].index = -2;
            } else if (d3 < 0.0) {
                d3 = 0.0;
            }
            d2 += d3;
            pieData.sortPoints[n5].y = d3;
            ++n5;
        }
        pieData.zero_pie = d2 == 0.0;
        Point[] pointArray = this.pcf.getExplodeList();
        if (pointArray != null) {
            n3 = 0;
            while (n3 < pointArray.length) {
                if (n == pointArray[n3].x) {
                    if (pointArray[n3].y == -10) {
                        pieData.exploded[pieData.exploded.length - 1] = true;
                    } else if (pointArray[n3].y < n2) {
                        pieData.exploded[pointArray[n3].y] = true;
                    }
                }
                ++n3;
            }
        }
        switch (this.pcf.sortOrder) {
            case 1: {
                this.sortWrapper(pieData, n2, new PieSortAscending());
                break;
            }
            case 2: {
                this.sortWrapper(pieData, n2, new PieSortDescending());
                break;
            }
        }
        n3 = 0;
        while (n3 < n2) {
            pieData.percents[n3].pct = pieData.zero_pie ? 0.0 : pieData.sortPoints[n3].y / d2;
            pieData.percents[n3].index = pieData.sortPoints[n3].index;
            ++n3;
        }
        pieData.other_slice = -1;
        boolean bl = false;
        double d4 = 0.0;
        int n6 = 0;
        int n7 = n2;
        boolean bl2 = true;
        switch (this.pcf.sortOrder) {
            case 1: {
                int n8 = 0;
                while (n8 < n2) {
                    if (n2 - n8 < n4) break;
                    switch (this.pcf.thresholdMethod) {
                        case 1: {
                            bl2 = d4 + pieData.percents[n8].pct <= d;
                            break;
                        }
                        case 0: {
                            bl2 = pieData.percents[n8].pct <= d;
                            break;
                        }
                        default: {
                            System.out.println(JCChartBundle.string("jclass.chart.Key9"));
                        }
                    }
                    if (bl2) {
                        pieData.percents[n8].pct += d4;
                        d4 = pieData.percents[n8].pct;
                        bl = true;
                        n6 = n8;
                    }
                    ++n8;
                }
                if (!bl) break;
                n7 = n2 - n6;
                pieData.other_slice = n7 - 1;
                pieData.percents[n2].pct = pieData.percents[n6].pct;
                pieData.percents[n2].index = n2;
                n8 = n6 + 1;
                while (n8 <= n2) {
                    pieData.percents[n8 - n6 - 1].pct = pieData.percents[n8].pct;
                    pieData.percents[n8 - n6 - 1].index = pieData.percents[n8].index;
                    ++n8;
                }
                break;
            }
            case 2: {
                n6 = n2 - 1;
                int n9 = n2 - 1;
                while (n9 >= 0) {
                    if (n9 + 1 < n4) break;
                    switch (this.pcf.thresholdMethod) {
                        case 1: {
                            bl2 = d4 + pieData.percents[n9].pct <= d;
                            break;
                        }
                        case 0: {
                            bl2 = pieData.percents[n9].pct <= d;
                            break;
                        }
                        default: {
                            System.out.println(JCChartBundle.string("jclass.chart.Key9"));
                        }
                    }
                    if (!bl2) break;
                    pieData.percents[n9].pct += d4;
                    d4 = pieData.percents[n9].pct;
                    n6 = n9--;
                    bl = true;
                }
                pieData.percents[n6].index = n2;
                n7 = n6 + 1;
                pieData.other_slice = n6;
                break;
            }
            case 0: {
                this.sortWrapper(pieData, n2, new PieSortAscending());
                pieData.percents[n2].pct = 0.0;
                pieData.percents[n2].index = n2;
                int n10 = 0;
                while (n10 < n2) {
                    if (n7 < n4) break;
                    double d5 = pieData.zero_pie ? 0.0 : pieData.sortPoints[n10].y / d2;
                    switch (this.pcf.thresholdMethod) {
                        case 1: {
                            bl2 = d4 + d5 <= d;
                            break;
                        }
                        case 0: {
                            bl2 = d5 <= d;
                            break;
                        }
                        default: {
                            System.out.println(JCChartBundle.string("jclass.chart.Key9"));
                        }
                    }
                    if (bl2) {
                        pieData.percents[n7].pct += d5;
                        d4 = pieData.percents[n7].pct;
                        n6 = 0;
                        while (n6 < n7) {
                            if (pieData.percents[n6].pct == d5) {
                                ++n6;
                                break;
                            }
                            ++n6;
                        }
                        while (n6 <= n7) {
                            pieData.percents[n6 - 1].pct = pieData.percents[n6].pct;
                            pieData.percents[n6 - 1].index = pieData.percents[n6].index;
                            ++n6;
                        }
                        bl = true;
                        --n7;
                    }
                    ++n10;
                }
                if (!bl) break;
                pieData.other_slice = n7++;
                break;
            }
            default: {
                System.out.println(JCChartBundle.string("jclass.chart.Key9"));
            }
        }
        pieData.num_slices_pie = n7;
        pieData.other_flag = bl ? 1 : 0;
        return pieData.other_flag;
    }

    private void drawPiePlane(Graphics graphics, ChartDataViewSeries[] chartDataViewSeriesArray, PieData pieData, PieChartInfo pieChartInfo, int n, int n2, int n3, boolean bl) {
        double d = 135.0;
        double d2 = 0.0;
        int n4 = 0;
        while (n4 < pieData.num_slices_pie) {
            JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n4);
            double d3 = pieData.percents[n4].pct * 360.0;
            if (n4 == pieData.lastDrawnSlice) {
                if (d2 >= 360.0) {
                    d3 = 0.0;
                } else {
                    d3 = d - 135.0;
                    if (d3 < 0.0 || d3 == 0.0 && d2 == 0.0) {
                        d3 += 360.0;
                    }
                }
            }
            if (d3 != 0.0) {
                int n5 = (int)Math.round(d3);
                if (n5 != 0) {
                    if (pieData.exploded[pieData.percents[n4].index]) {
                        int n6 = n5 / 2;
                        this.calcExplodeOffset((int)Math.round(d), n6, this.explode_offset, pieChartInfo.width / 2, pieChartInfo.pos[n3].offset[n4]);
                    }
                    Point point = pieChartInfo.pos[n3].offset[n4];
                    if (bl) {
                        jCFillStyle.fillArc(graphics, n + point.x, n2 + point.y, pieChartInfo.width, pieChartInfo.height, (int)Math.round(d), -1 * n5);
                    } else {
                        jCFillStyle.fillArcShadow(graphics, n + point.x, n2 + point.y, pieChartInfo.width, pieChartInfo.height, (int)Math.round(d), -1 * n5);
                    }
                }
                d -= (double)n5;
                d2 += (double)n5;
                if (d < 0.0) {
                    d += 360.0;
                }
            }
            ++n4;
        }
    }

    private void drawPieCircle(Graphics graphics, ChartDataViewSeries[] chartDataViewSeriesArray, PieData pieData, PieChartInfo pieChartInfo, int n, int n2, int n3) {
        double d = 135.0;
        double d2 = 0.0;
        int n4 = 0;
        if (graphics.getColor() != this.outlineColor) {
            graphics.setColor(this.outlineColor);
        }
        int n5 = 0;
        while (n5 < pieData.num_slices_pie) {
            this.getPieSliceFillStyle(pieData, n5);
            double d3 = pieData.percents[n5].pct * 360.0;
            if (n5 == pieData.lastDrawnSlice) {
                if (!pieData.exploded[pieData.percents[n5].index]) {
                    n4 = 0;
                }
                if (d2 >= 360.0) {
                    d3 = 0.0;
                } else {
                    d3 = d - (double)n4 - 135.0;
                    if (d3 < 0.0 || d3 == 0.0 && d2 == 0.0) {
                        d3 += 360.0;
                    }
                }
            }
            if (d3 != 0.0) {
                int n6 = (int)Math.round(d3);
                if (pieData.exploded[pieData.percents[n5].index]) {
                    if (n4 != 0) {
                        graphics.drawArc(n, n2, pieChartInfo.width, pieChartInfo.height, (int)Math.round(d), -1 * n4);
                        d -= (double)n4;
                        d2 += (double)n4;
                        if (d < 0.0) {
                            d += 360.0;
                        }
                        n4 = 0;
                    }
                    if (n6 != 0) {
                        Point point = pieChartInfo.pos[n3].offset[n5];
                        graphics.drawArc(n + point.x, n2 + point.y, pieChartInfo.width, pieChartInfo.height, (int)Math.round(d), -1 * n6);
                        d -= (double)Math.round(d3);
                        d2 += (double)Math.round(d3);
                        if (d < 0.0) {
                            d += 360.0;
                        }
                    }
                } else {
                    n4 += n6;
                }
            }
            ++n5;
        }
        if (n4 != 0) {
            graphics.drawArc(n, n2, pieChartInfo.width, pieChartInfo.height, (int)Math.round(d), -1 * n4);
        }
    }

    private void drawPieEdge(Graphics graphics, PieData pieData, PieChartInfo pieChartInfo, int n, int n2) {
        int n3 = pieChartInfo.width;
        int n4 = pieChartInfo.height;
        double d = (double)n3 / 2.0;
        double d2 = (double)n4 / 2.0;
        int n5 = (int)((double)n + d + 0.5);
        int n6 = (int)((double)n2 + d2 + 0.5);
        int n7 = 0;
        double d3 = 135.0;
        while (n7 < pieData.num_slices_pie && d3 > -180.0) {
            double d4;
            double d5 = pieData.percents[n7].pct * 360.0;
            if (d5 == 0.0) {
                d4 = d3;
            } else {
                d4 = d3 - d5;
                if (!(d4 > 0.0)) {
                    double d6 = d3 > 0.0 ? 0.0 : JCChartUtil.degToRad(d3);
                    Point[] pointArray = new Point[4];
                    pointArray[0] = new Point((int)((double)n5 + Math.cos(d6) * d + 0.5), (int)((double)n6 - Math.sin(d6) * d2 + 0.5));
                    pointArray[1] = new Point(pointArray[0].x, pointArray[0].y + this.delta_y);
                    d6 = d4 < -180.0 ? JCChartUtil.degToRad(-180.0) : JCChartUtil.degToRad(d4);
                    pointArray[3] = new Point((int)((double)n5 + Math.cos(d6) * d + 0.5), (int)((double)n6 - Math.sin(d6) * d2));
                    pointArray[2] = new Point(pointArray[3].x, pointArray[3].y + this.delta_y);
                    JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n7);
                    Polygon polygon = new Polygon();
                    int n8 = 0;
                    while (n8 < pointArray.length) {
                        polygon.addPoint(pointArray[n8].x, pointArray[n8].y);
                        ++n8;
                    }
                    jCFillStyle.fillPolygonShadow(graphics, polygon);
                    if (graphics.getColor() != this.outlineColor) {
                        graphics.setColor(this.outlineColor);
                    }
                    graphics.drawLine(pointArray[0].x, pointArray[0].y, pointArray[1].x, pointArray[1].y);
                }
            }
            ++n7;
            d3 = d4;
        }
        if (graphics.getColor() != this.outlineColor) {
            graphics.setColor(this.outlineColor);
        }
        graphics.drawLine(n, n6, n, n6 + this.delta_y);
        graphics.drawArc(n, n2 + this.delta_y, n3, n4, 0, -180);
    }

    private void drawPieLines(Graphics graphics, ChartDataViewSeries[] chartDataViewSeriesArray, PieData pieData, PieChartInfo pieChartInfo, int n, int n2, int n3) {
        double d = (double)pieChartInfo.width / 2.0;
        double d2 = (double)pieChartInfo.height / 2.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = pieChartInfo.pos[n3].cx = (int)((double)n + Math.floor(d));
        int n7 = pieChartInfo.pos[n3].cy = (int)((double)n2 + Math.floor(d2));
        int n8 = 0;
        int n9 = 0;
        if (graphics.getColor() != this.outlineColor) {
            graphics.setColor(this.outlineColor);
        }
        int n10 = -1;
        double d3 = 135.0;
        double d4 = 0.0;
        int n11 = pieData.lastDrawnSlice;
        boolean bl = false;
        boolean bl2 = false;
        int n12 = 0;
        while (n12 < pieData.num_slices_pie) {
            int n13 = -1;
            int n14 = -1;
            bl = n12 == 0 ? false : pieData.exploded[pieData.percents[n11].index];
            double d5 = pieData.percents[n12].pct * 360.0;
            if (n12 == pieData.lastDrawnSlice) {
                if (d4 >= 360.0) {
                    d5 = 0.0;
                } else {
                    d5 = d3 - 135.0;
                    if (d5 < 0.0 || d5 == 0.0 && d4 == 0.0) {
                        d5 += 360.0;
                    }
                }
            }
            if (d5 != 0.0) {
                Point point;
                int n15 = (int)Math.round(d3);
                if (d4 == 0.0) {
                    n14 = (int)Math.round((double)n6 + Math.cos(JCChartUtil.degToRad(n15)) * Math.floor(d));
                    n13 = (int)Math.round((double)n7 - Math.sin(JCChartUtil.degToRad(n15)) * Math.floor(d2));
                    n4 = n14;
                    n5 = n13;
                    bl2 = pieData.exploded[pieData.percents[n12].index];
                } else {
                    n14 = n8;
                    n13 = n9;
                }
                d3 -= (double)Math.round(d5);
                d4 += (double)Math.round(d5);
                if (d3 < 0.0) {
                    d3 += 360.0;
                }
                n15 = (int)Math.round(d3);
                n8 = (int)Math.round((double)n6 + Math.cos(JCChartUtil.degToRad(n15)) * Math.floor(d));
                n9 = (int)Math.round((double)n7 - Math.sin(JCChartUtil.degToRad(n15)) * Math.floor(d2));
                if (pieData.exploded[pieData.percents[n12].index]) {
                    point = pieChartInfo.pos[n3].offset[n12];
                    graphics.drawLine(n6 + point.x, n7 + point.y, n14 + point.x, n13 + point.y);
                } else if (bl) {
                    graphics.drawLine(n6, n7, n14, n13);
                }
                if (pieData.exploded[pieData.percents[n12].index]) {
                    point = pieChartInfo.pos[n3].offset[n12];
                    graphics.drawLine(n6 + point.x, n7 + point.y, n8 + point.x, n9 + point.y);
                } else {
                    graphics.drawLine(n6, n7, n8, n9);
                }
                n11 = n12;
            }
            pieChartInfo.pos[n3].coord[n12].x = n14;
            pieChartInfo.pos[n3].coord[n12].y = n13;
            if (n14 >= 0) {
                int n16 = n12 - 1;
                while (n16 >= 0 && pieChartInfo.pos[n3].coord[n16].x == -1) {
                    pieChartInfo.pos[n3].coord[n16].x = n14;
                    pieChartInfo.pos[n3].coord[n16].y = n13;
                    --n16;
                }
                n10 = n12;
            }
            ++n12;
        }
        if (!bl2 && pieData.exploded[pieData.percents[n11].index]) {
            graphics.drawLine(n6, n7, n4, n5);
        }
        n12 = n10 + 1;
        while (n12 < pieData.num_slices_pie) {
            pieChartInfo.pos[n3].coord[n12].x = pieChartInfo.pos[n3].coord[0].x;
            pieChartInfo.pos[n3].coord[n12].y = pieChartInfo.pos[n3].coord[0].y;
            ++n12;
        }
    }

    private void sortWrapper(PieData pieData, int n, JCSortInterface jCSortInterface) {
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < n) {
            Vector<PieSortPoint> vector2 = new Vector<PieSortPoint>();
            vector2.addElement(pieData.sortPoints[n2]);
            vector.addElement(vector2);
            ++n2;
        }
        new JCqsort(vector, jCSortInterface).sort(0);
        int n3 = 0;
        while (n3 < n) {
            pieData.sortPoints[n3] = (PieSortPoint)((Vector)vector.elementAt(n3)).elementAt(0);
            ++n3;
        }
    }

    private JCFillStyle getPieSliceFillStyle(PieData pieData, int n) {
        JCFillStyle jCFillStyle = null;
        if (n == pieData.other_slice && pieData.other_flag != 0) {
            jCFillStyle = this.pcf.getOtherStyle().getFillStyle();
        } else {
            int n2 = pieData.percents[n].index;
            if (n2 >= 0) {
                jCFillStyle = this.seriesList[n2].getStyle().getFillStyle();
            }
        }
        return jCFillStyle;
    }

    protected void calcTransientData() {
        int n;
        int n2;
        int n3;
        if (!this.dataObject.isChanged() && this.dataObject.getTransientData() != null) {
            return;
        }
        this.seriesList = this.dataObject.getSeries();
        this.pcf = this.dataObject.getPieChartFormat();
        int n4 = this.dataObject.getNumSeries();
        Point point = this.dataObject.getFirstLast();
        if (point == null) {
            this.num_pies = 0;
            return;
        }
        this.num_pies = Math.max(point.y - point.x + 1, 0);
        if (this.num_pies == 0) {
            return;
        }
        PieChartInfo pieChartInfo = null;
        pieChartInfo = new PieChartInfo();
        pieChartInfo.pos = new PiePosition[this.num_pies];
        pieChartInfo.data = new PieData[this.num_pies];
        pieChartInfo.num_pies = this.num_pies;
        int n5 = 0;
        while (n5 < this.num_pies) {
            pieChartInfo.pos[n5] = new PiePosition();
            pieChartInfo.pos[n5].coord = new Point[n4 + 1];
            pieChartInfo.pos[n5].offset = new Point[n4 + 1];
            n3 = 0;
            while (n3 <= n4) {
                pieChartInfo.pos[n5].coord[n3] = new Point(-2, -2);
                pieChartInfo.pos[n5].offset[n3] = new Point(0, 0);
                ++n3;
            }
            pieChartInfo.pos[n5].order = new short[n4 + 1];
            pieChartInfo.data[n5] = new PieData();
            pieChartInfo.data[n5].sortPoints = new PieSortPoint[n4];
            n2 = 0;
            while (n2 < n4) {
                pieChartInfo.data[n5].sortPoints[n2] = new PieSortPoint();
                ++n2;
            }
            pieChartInfo.data[n5].percents = new PiePercent[n4 + 1];
            pieChartInfo.data[n5].exploded = new boolean[n4 + 1];
            n = 0;
            while (n < n4 + 1) {
                pieChartInfo.data[n5].percents[n] = new PiePercent();
                pieChartInfo.data[n5].exploded[n] = false;
                ++n;
            }
            ++n5;
        }
        this.first_point = this.seriesList[0].getFirstPoint();
        pieChartInfo.other_flag = 0;
        n3 = 0;
        while (n3 < this.num_pies) {
            n2 = this.computeOtherSlice(this.seriesList, n3 + this.first_point, n4, pieChartInfo.data[n3]);
            n = pieChartInfo.data[n3].num_slices_pie;
            int n6 = 0;
            while (n6 < n) {
                pieChartInfo.pos[n3].order[n6] = (short)pieChartInfo.data[n3].percents[n6].index;
                if (pieChartInfo.data[n3].percents[n6].pct > 0.0) {
                    pieChartInfo.data[n3].lastDrawnSlice = n6;
                }
                ++n6;
            }
            while (n6 <= n4) {
                pieChartInfo.pos[n3].order[n6] = -1;
                ++n6;
            }
            if (n2 > 0) {
                pieChartInfo.pos[n3].order[pieChartInfo.data[n3].other_slice] = -10;
            }
            pieChartInfo.other_flag |= n2;
            ++n3;
        }
        this.dataObject.setTransientData(pieChartInfo);
        this.dataObject.setChanged(false, 0);
    }

    JCDataIndex pick(Point point, int n) {
        int n2;
        JCDataIndex jCDataIndex = null;
        PieData pieData = new PieData();
        pieData.sortPoints = null;
        pieData.percents = null;
        int n3 = 0;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n4 = this.seriesList.length;
        pieData.sortPoints = new PieSortPoint[n4];
        int n5 = 0;
        while (n5 < n4) {
            pieData.sortPoints[n5] = new PieSortPoint();
            ++n5;
        }
        pieData.percents = new PiePercent[n4 + 1];
        pieData.exploded = new boolean[n4 + 1];
        int n6 = 0;
        while (n6 < n4 + 1) {
            pieData.percents[n6] = new PiePercent();
            pieData.exploded[n6] = false;
            ++n6;
        }
        double d = JCChartUtil.degToRad(Math.max(0.0, (double)this.chartArea.getElevation()));
        double d2 = Math.cos(d);
        int n7 = 0;
        int n8 = 0;
        if (this.pieInfo == null || (n7 = this.pieInfo.width) == 0 || (n8 = this.pieInfo.height) == 0) {
            return jCDataIndex;
        }
        int n9 = (this.box_width - n7) / 2;
        if (n9 < 0) {
            n9 = 0;
        }
        double d3 = (double)n7 / 2.0;
        double d4 = (double)n8 / 2.0;
        int n10 = (point.x - rectangle.x) / this.box_width;
        if (n10 >= this.num_pies_line) {
            n10 = this.num_pies_line - 1;
        }
        if ((n2 = (point.y - rectangle.y) / this.box_height) >= this.num_lines) {
            n2 = this.num_lines - 1;
        }
        int n11 = n2 * this.num_pies_line + n10 + this.seriesList[0].firstPoint;
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = (n12 += n10 * this.box_width) + n9;
        int n15 = (n13 += n2 * this.box_height) + (this.box_height - n8 - this.delta_y - this.label_height) / 2;
        int n16 = n14 + (int)Math.round((double)n7 / 2.0);
        int n17 = n15 + (int)Math.round((double)n8 / 2.0);
        int n18 = -1;
        int n19 = -1;
        if (n11 < this.num_pies + this.seriesList[0].firstPoint && point.x >= n12 && point.x <= n12 + this.box_width && point.y >= n13 && point.y <= n13 + this.box_height) {
            double d5;
            double d6;
            int n20 = this.computeOtherSlice(this.seriesList, n11, n4, pieData);
            int[] nArray = this.pie_hit(n16, n17, d3, d4, this.delta_y, point.x, point.y);
            int n21 = nArray[0];
            double d7 = 0.0;
            switch (n21) {
                case 1: {
                    int n22 = nArray[1];
                    if (point.x == n16) {
                        d7 = point.y < n17 ? 90 : -90;
                    } else {
                        d7 = JCChartUtil.radToDeg(Math.atan((double)(n17 - point.y) / (double)(point.x - n16)));
                        if (point.x < n16) {
                            d7 += 180.0;
                        }
                    }
                    n3 = 0;
                    break;
                }
                case 2: {
                    int n22 = nArray[1];
                    if (point.x == n16) {
                        d7 = -90.0;
                    } else {
                        d7 = JCChartUtil.radToDeg(Math.atan((double)(-n22) / (double)(point.x - n16)));
                        if (point.x < n16) {
                            d7 += 180.0;
                        }
                    }
                    n3 = 0;
                    break;
                }
                case 0: {
                    double d8;
                    double d9;
                    if (point.y < n17) {
                        if (point.x == n16) {
                            d7 = 90.0;
                        } else {
                            d7 = JCChartUtil.radToDeg(Math.atan((double)(n17 - point.y) / (double)(point.x - n16)));
                            if (point.x < n16) {
                                d7 += 180.0;
                            }
                        }
                        d6 = point.x - n16;
                        d9 = point.y - n17;
                        d8 = Math.cos(JCChartUtil.degToRad(d7));
                        d5 = Math.sin(JCChartUtil.degToRad(d7));
                        n3 = (int)Math.round(Math.sqrt(d6 * d6 + d9 * d9) - d3 * d4 / Math.sqrt(d4 * d4 * d8 * d8 + d3 * d3 * d5 * d5));
                        n3 = Math.max(n3, 0);
                        break;
                    }
                    if (point.y > n17 + this.delta_y) {
                        if (point.x == n16) {
                            d7 = -90.0;
                        } else {
                            d7 = JCChartUtil.radToDeg(Math.atan((double)(n17 + this.delta_y - point.y) / (double)(point.x - n16)));
                            if (point.x < n16) {
                                d7 += 180.0;
                            }
                        }
                        d6 = point.x - n16;
                        d9 = point.y - (n17 + this.delta_y);
                        d8 = Math.cos(JCChartUtil.degToRad(d7));
                        d5 = Math.sin(JCChartUtil.degToRad(d7));
                        n3 = (int)Math.round(Math.sqrt(d6 * d6 + d9 * d9) - d3 * d4 / Math.sqrt(d4 * d4 * d8 * d8 + d3 * d3 * d5 * d5));
                        n3 = Math.max(n3, 0);
                        break;
                    }
                    if (point.x < n14) {
                        d7 = 180.0;
                        n3 = n14 - point.x;
                        break;
                    }
                    if (point.x > n14 + n7) {
                        d7 = 0.0;
                        n3 = point.x - (n14 + n7);
                        break;
                    }
                    d7 = point.x < n16 ? 180 : 0;
                    n3 = 0;
                    break;
                }
            }
            if (d2 != 0.0) {
                d6 = d7;
                d7 = JCChartUtil.radToDeg(Math.atan(Math.tan(JCChartUtil.degToRad(d6)) / d2));
                if (Math.cos(JCChartUtil.degToRad(d6)) <= 0.0) {
                    d7 += 180.0;
                }
            }
            if (d7 > 135.0) {
                d7 -= 360.0;
            }
            int n23 = 0;
            if (!pieData.zero_pie) {
                double d10 = 0.0;
                double d11 = 0.0;
                int n24 = 0;
                n24 = 0;
                d11 = 135.0;
                while (n24 < pieData.num_slices_pie) {
                    d5 = pieData.percents[n24].pct * 360.0;
                    if (d5 == 0.0) {
                        d10 = d11;
                    } else {
                        d10 = d11 - d5;
                        if (d10 <= d7 && d7 <= d11) {
                            n23 = n20 != 0 && n24 == pieData.other_slice ? -10 : pieData.percents[n24].index;
                            if (!pieData.exploded[pieData.percents[n24].index] || (n3 -= this.pcf.getExplodeOffset()) >= 0) break;
                            n3 = 0;
                            break;
                        }
                    }
                    ++n24;
                    d11 = d10;
                }
            }
            n18 = n23;
            n19 = n11;
        }
        if (n18 >= 0 && n19 >= 0) {
            jCDataIndex = new JCDataIndex(n19, this.seriesList[n18], n18);
            jCDataIndex.distance = n3;
        } else if (n18 == -10 && n19 >= 0) {
            jCDataIndex = new JCDataIndex(n19, null, n18);
            jCDataIndex.distance = n3;
        }
        return jCDataIndex;
    }

    private int[] pie_hit(int n, int n2, double d, double d2, int n3, int n4, int n5) {
        int[] nArray = new int[2];
        double d3 = d * d;
        double d4 = n4 - n;
        double d5 = d4 * d4;
        if (d3 < d5) {
            nArray[0] = 0;
            return nArray;
        }
        double d6 = d2 / d * Math.sqrt(d3 - d5);
        if ((double)n5 < (double)n2 - d6 || (double)n5 > (double)(n2 + n3) + d6) {
            nArray[0] = 0;
            return nArray;
        }
        nArray[1] = (int)Math.round(d6);
        nArray[0] = (double)n5 < (double)n2 + d6 ? 1 : 2;
        return nArray;
    }

    Point unpick(int n, int n2) {
        return this.find_point(n2, n);
    }

    private Point find_point(int n, int n2) {
        int n3 = this.seriesList.length;
        if (n != -10 && !this.seriesList[n].isShowing) {
            return null;
        }
        double d = Math.cos(JCChartUtil.degToRad(Math.max(0, this.chartArea.getElevation())));
        int n4 = -1;
        int n5 = -1;
        double d2 = 0.0;
        double d3 = 0.0;
        int n6 = 0;
        while (n6 < n3 + 1) {
            int n7 = n2 - this.seriesList[0].firstPoint;
            short s = this.pieInfo.pos[n7].order[n6];
            if (s == -1) {
                return null;
            }
            if (s != -2 && s == n) {
                double d4;
                double d5;
                double d6 = this.pieInfo.pos[n7].coord[n6].x;
                double d7 = this.pieInfo.pos[n7].coord[n6].y;
                if (d6 == -2.0) {
                    return null;
                }
                if (n6 == n3 || this.pieInfo.pos[n7].order[n6 + 1] == -1) {
                    d5 = this.pieInfo.pos[n7].coord[0].x;
                    d4 = this.pieInfo.pos[n7].coord[0].y;
                } else {
                    d5 = this.pieInfo.pos[n7].coord[n6 + 1].x;
                    d4 = this.pieInfo.pos[n7].coord[n6 + 1].y;
                }
                d7 = (d7 - (double)this.pieInfo.pos[n7].cy) / d + (double)this.pieInfo.pos[n7].cy;
                d4 = (d4 - (double)this.pieInfo.pos[n7].cy) / d + (double)this.pieInfo.pos[n7].cy;
                double d8 = Math.atan2((double)this.pieInfo.pos[n7].cy - d7, d6 - (double)this.pieInfo.pos[n7].cx);
                double d9 = Math.atan2((double)this.pieInfo.pos[n7].cy - d4, d5 - (double)this.pieInfo.pos[n7].cx);
                d2 = d8 - d9;
                if (d2 < 0.0) {
                    d2 += Math.PI * 2;
                }
                if ((d2 = d8 - d2 / 2.0) <= -Math.PI) {
                    d2 += Math.PI * 2;
                }
                if (d2 == 1.5707963267948966) {
                    n4 = this.pieInfo.pos[n7].cx;
                    n5 = this.pieInfo.pos[n7].cy - this.pieInfo.height / 2;
                    break;
                }
                if (d2 == -1.5707963267948966) {
                    n4 = this.pieInfo.pos[n7].cx;
                    n5 = this.pieInfo.pos[n7].cy + this.pieInfo.height / 2;
                    break;
                }
                double d10 = (double)this.pieInfo.width / 2.0;
                double d11 = Math.tan(d2);
                d6 = Math.sqrt(d10 * d10 / (1.0 + d11 * d11));
                if (d2 > 1.5707963267948966 || d2 < -1.5707963267948966) {
                    d6 = -d6;
                }
                d7 = d6 * d11 * d;
                n4 = (int)((double)this.pieInfo.pos[n7].cx + d6);
                n5 = (int)((double)this.pieInfo.pos[n7].cy - d7);
                break;
            }
            ++n6;
        }
        d3 = d2;
        return new Point(n4, n5);
    }

    private void calcExplodeOffset(int n, int n2, int n3, int n4, Point point) {
        int n5 = n3;
        int n6 = n - n2;
        if (n6 < 0) {
            n6 += 360;
        }
        if (n6 >= 0 && n6 <= 90) {
            point.x = (int)Math.round(Math.cos(JCChartUtil.degToRad(n6)) * (double)n5);
            point.y = -((int)Math.round(Math.sin(JCChartUtil.degToRad(n6)) * (double)n5));
            return;
        }
        if (n6 > 90 && n6 <= 180) {
            point.x = -((int)Math.round(Math.sin(JCChartUtil.degToRad(n6 -= 90)) * (double)n5));
            point.y = -((int)Math.round(Math.cos(JCChartUtil.degToRad(n6)) * (double)n5));
            return;
        }
        if (n6 > 180 && n6 <= 270) {
            point.x = -((int)Math.round(Math.cos(JCChartUtil.degToRad(n6 -= 180)) * (double)n5));
            point.y = (int)Math.round(Math.sin(JCChartUtil.degToRad(n6)) * (double)n5);
            return;
        }
        if (n6 > 270 && n6 <= 360) {
            point.x = (int)Math.round(Math.sin(JCChartUtil.degToRad(n6 -= 270)) * (double)n5);
            point.y = (int)Math.round(Math.cos(JCChartUtil.degToRad(n6)) * (double)n5);
        }
    }
}

