/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCContainer;
import jclass.bwt.JCLabel;
import jclass.bwt.JCTextField;
import jclass.chart.customizer.JCDeluxColorEditor;
import jclass.chart.customizer.JCPropertyPage;
import jclass.util.JCImageCreator;
import jclass.util.JCUtilConverter;

public class JCColorEditor
extends JCPropertyPage
implements JCActionListener,
PropertyEditor {
    public static String INHERIT_STRING = "inherit";
    private JCTextField field;
    private JCLabel swatch;
    private JCButton editTrigger;
    private static Frame colorFrame = null;
    private static JCDeluxColorEditor delux = null;
    private static String[] rainbow = new String[]{"rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "              ", "              ", "              ", "  ..  ..  ..  ", "  ..  ..  ..  "};

    public JCColorEditor() {
        this.setLayout(new FlowLayout(0, 2, 2));
        this.field = new JCTextField("", 10);
        this.field.addActionListener(this);
        this.add(this.field);
        JCContainer jCContainer = new JCContainer();
        this.swatch = new JCLabel("  ");
        this.swatch.setInsets(new Insets(0, 0, 0, 0));
        this.swatch.setShadowType(3);
        this.swatch.setShadowThickness(1);
        jCContainer.add(this.swatch);
        this.add(jCContainer);
        this.editTrigger = new JCButton(JCColorEditor.rainbowImage(this));
        this.editTrigger.setInsets(new Insets(0, 0, 0, 0));
        this.editTrigger.addActionListener(this);
        this.add(this.editTrigger);
    }

    public void setValue(Object object) {
        String string;
        Color color;
        if (object == null) {
            this.field.setText(INHERIT_STRING);
            this.swatch.setBackground(null);
            return;
        }
        if (object instanceof Color) {
            Color color2 = (Color)object;
            String string2 = this.getColorName(color2);
            this.field.setText(string2);
            this.swatch.setBackground(color2);
            return;
        }
        if (object instanceof String && (color = JCUtilConverter.toColor(string = (String)object)) != null) {
            this.field.setText(string);
            this.swatch.setBackground(color);
        }
    }

    public Object getValue() {
        return this.swatch.getBackground();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.setColor((Color)this.getValue());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public String getJavaInitializationString() {
        Color color = (Color)this.getValue();
        return "new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }

    public String getAsText() {
        return this.getJavaInitializationString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return new JCDeluxColorEditor();
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.field) {
            String string = this.field.getText();
            Color color = JCUtilConverter.toColor(string);
            if (color == null || string.equalsIgnoreCase("null") || string.indexOf(INHERIT_STRING) >= 0) {
                this.field.setText(INHERIT_STRING);
                this.firePropertyChange(null, null, null);
                return;
            }
            this.swatch.setBackground(color);
            this.firePropertyChange(null, null, this.getValue());
            return;
        }
        if (jCActionEvent.getSource() == this.editTrigger) {
            if (colorFrame == null) {
                colorFrame = new Frame("JClass Color Editor");
                colorFrame.setLayout(new GridLayout(1, 1));
                ((Component)colorFrame).setBackground(Color.lightGray);
                delux = (JCDeluxColorEditor)this.getCustomEditor();
                delux.setBackground(JCPropertyPage.textBG);
                colorFrame.add(delux);
                colorFrame.pack();
                JCPropertyPage.resizeFrame(delux);
            }
            delux.removePropertyChangeListener(null);
            delux.addPropertyChangeListener(this);
            delux.setValue(this.getValue());
            colorFrame.show();
        }
    }

    public void propertyChanged(Object object, Object object2) {
        this.setValue((Color)object2);
        this.firePropertyChange(null, null, object2);
        if (object == delux) {
            ((Component)colorFrame).hide();
        }
    }

    public void setBackground(Color color) {
        this.field.setBackground(color);
    }

    private String getColorName(Color color) {
        if (color == null) {
            return INHERIT_STRING;
        }
        if (color.equals(Color.black)) {
            return "Black";
        }
        if (color.equals(Color.blue)) {
            return "Blue";
        }
        if (color.equals(Color.cyan)) {
            return "Cyan";
        }
        if (color.equals(Color.darkGray)) {
            return "darkGray";
        }
        if (color.equals(Color.gray)) {
            return "Gray";
        }
        if (color.equals(Color.green)) {
            return "Green";
        }
        if (color.equals(Color.lightGray)) {
            return "lightGray";
        }
        if (color.equals(Color.magenta)) {
            return "Magenta";
        }
        if (color.equals(Color.orange)) {
            return "Orange";
        }
        if (color.equals(Color.pink)) {
            return "Pink";
        }
        if (color.equals(Color.red)) {
            return "Red";
        }
        if (color.equals(Color.white)) {
            return "White";
        }
        if (color.equals(Color.yellow)) {
            return "Yellow";
        }
        return color.getRed() + "-" + color.getGreen() + "-" + color.getBlue();
    }

    static Image rainbowImage(Component component) {
        JCImageCreator jCImageCreator = new JCImageCreator(component, rainbow[0].length(), rainbow.length);
        jCImageCreator.setColor('.', new Color(0));
        jCImageCreator.setColor('r', new Color(0xFF0000));
        jCImageCreator.setColor('g', new Color(65280));
        jCImageCreator.setColor('b', new Color(255));
        jCImageCreator.setPixels(rainbow);
        return jCImageCreator.create();
    }
}

