package cern.lhcias.csgui.Services;

import java.awt.*;
import java.util.*;
import cern.lhcias.csgui.interfaces.*;
import cern.lhcias.csgui.Events.*;
import symantec.itools.net.RelativeURL;

/*
 *
 * Alarm
 *
 */
public class Alarm implements AlarmListener
{
  	symantec.itools.multimedia.SoundPlayer audio = null;
	boolean audio_flag = false;
    long   previousTime;

	public Alarm(String alarmURL) {
	    if (alarmURL != null)
    	    SetAlarmSrc(alarmURL);
	}
	
	public void SetAlarmSrc(String alarmURL) {
	    audio_flag = false;
	    audio = new symantec.itools.multimedia.SoundPlayer();
	    try {
	        java.net.URL[] tempURL = new java.net.URL[1];
	        tempURL[0] = symantec.itools.net.RelativeURL.getURL(alarmURL);
	        audio.setURLList(tempURL);
	        audio_flag = true;
	    } catch (java.net.MalformedURLException error) {
	        System.out.println("Error :"+error);
	        }
	    catch (java.beans.PropertyVetoException e) {}
	}

	public boolean GetStatus() {
		return audio_flag;
	}
	
    public void receiveAlarm(AlarmEvent alarmevent) {
        System.out.println((new Date(alarmevent.date)).toGMTString()+":"+
                alarmevent.group+":"+alarmevent.text);
        play();
	}

	public void play() {
		if ((audio != null) && (audio_flag)) {
	        if (((new Date()).getTime()-previousTime) > 1000) {
			    audio.play();
			    previousTime = (new Date()).getTime();
			}
		}
	}

	public void on() {
		if (audio != null)
			audio_flag = true;
	}

	public void off() {
		audio_flag = false;
	}

}

