package cern.lhcias.csgui.TagsView;

import cern.lhcias.csgui.interfaces.*;
import cern.lhcias.csgui.Events.*;
import cern.lhcias.csgui.Utils.*;
import cern.lhcias.csgui.Services.*;
import cern.lhcias.csgui.rtdb.*;
import java.awt.*;
import java.util.Vector;

/**
*<br>  TagsView type implemented:  CanvasMTagsView
*<br>
*<br>   This class which is a "TagsView" is a simple base class for a TagsView which display
*<br>   multiple tags. This class is intended to be extended (see example class BarGraphView)
*<br>
*<br>  Events:
*<br>    As any TagsView, it may fires TagcCliked and Alarm events.
*<br>
*<br>  Configuration:
*<br>    The configuration is a string containing a list of tag names separated by
*<br>    commas (ex: level1,PT215,TT141).
*   @see TagsView
*/
public class CanvasMTagsView extends Canvas implements TagsView {

public String              TYPE = "CanvasMTagsView";
public TagChangeAdapter    tadapter;
public Vector              TagstoView = new Vector();
public TagArrays           tagArrays;
public TagClickedAdapter   tcadapter;
public OpenViewAdapter     ovadapter;
public configurationMgr    cM;
public AlarmAdapter        alarmAdapter;

//----------------------------------------------------
Vector myListeners = new Vector();

public synchronized void addTagClickedListener(TagClickedListener listener) {
     myListeners.addElement(listener);
}

public synchronized void removeTagClickedListener(TagClickedListener listener) {
     myListeners.removeElement(listener);
}

public void fireTagClickedEvent(String name) {
        TagClickedEvent tagclevt = new TagClickedEvent(this);
        tagclevt.setTagName(name);
        for (int i=0; i<myListeners.size(); i++) {
            ((TagClickedListener) myListeners.elementAt(i)).receiveTagClicked(tagclevt);
        }
}

Vector myAlarmListeners  = new Vector();

public synchronized void addAlarmListener( AlarmListener listener) {
    myAlarmListeners.addElement(listener);
}
   
public synchronized void removeAlarmListener(AlarmListener listener) {
    myAlarmListeners.removeElement(listener);
}
           
void fireAlarmEvent(String description, String aGroup, long aDate) {
    AlarmEvent alarmevt = new AlarmEvent(this, description,aGroup,aDate);
    for (int i=0; i<myAlarmListeners.size(); i++) {
        ((AlarmListener) myAlarmListeners.elementAt(i)).receiveAlarm(alarmevt);
    }
}

//---------------- TagsView implementation -----------------------------------------
public void removeOpenViewListener(OpenViewListener listener) {}
public void addOpenViewListener(OpenViewListener listener){}
public void addMouseListener(java.awt.event.MouseListener cMouse) {}
public void setProperty(String tagName, String tagProperty, String propertyValue) {}

public int getComponentNb(){
        return 0;
}

public Vector getComponentsList(){
    return(null);
}

public boolean doYouImplement(String type) {
	if (type.equalsIgnoreCase(TYPE)) return(true);
    return false;
}

public Vector getPossibleTypes() {
    Vector types = new Vector();
    types.addElement(TYPE);
    return(types);
}

public String getType(){
    return(TYPE);
}

public void removeTag(String tagName) {
    TagstoView.removeElement(tagName);
    TagListHasChanged();
    //---------- Subscribe to the required tag list --------------
    tadapter.subscribeTagList(this, TagstoView);
    repaint();
}

public void    removeTag(Vector tagNames) {
    for (int i=0;i<tagNames.size();i++) {
        String s = (String) tagNames.elementAt(i);
        if (s != null)
            TagstoView.removeElement(s);
    }
    TagListHasChanged();
    //---------- Subscribe to the required tag list --------------
    tadapter.subscribeTagList(this, TagstoView);
    repaint();
}

public void    removeTag(TagsView TVcomponent) {
    removeTag(TVcomponent.getTagNames());
}

public void addTag(String tagName) {
    TagstoView.addElement(tagName);
    TagListHasChanged();
    //---------- Subscribe to the required tag list --------------
    tadapter.subscribeTagList(this, TagstoView);
}

public void    addTag(Vector tagNames) {
    for (int i=0;i<tagNames.size();i++) {
        String s = (String) tagNames.elementAt(i);
        if (s != null)
            TagstoView.addElement(s);
    }
    TagListHasChanged();
    //---------- Subscribe to the required tag list --------------
    tadapter.subscribeTagList(this, TagstoView);
}

public void    addTag(TagsView TVcomponent) {
    addTag(TVcomponent.getTagNames());
}

public void setConfig(String config) {
    TagstoView = new Vector();
    int i=1;
    config = config.replace(',',' ');
    String tok = MyUtils.get_token(config,i);
    while (tok != null) {
        TagstoView.addElement(tok);
        i++;
        tok = MyUtils.get_token(config,i);
    }
    TagListHasChanged();
}

public String toString() {
    String configString = new String();
    for (int i=0; i<TagstoView.size();i++) {
        configString = configString + TagstoView.elementAt(i) + ",";
    }
    return configString;
}

public Vector getTagNames() {
    return TagstoView;
}

public Vector getLocalTagNames() {
    return(getTagNames());
}

public void instantiate(TagArrays TA, String configname, TagChangeAdapter adapter,
        TagClickedAdapter cadapter, OpenViewAdapter opadapter, 
        configurationMgr cm, AlarmAdapter aA){
    tadapter     = adapter;
    tagArrays    = TA;
    tcadapter    = cadapter;
    ovadapter    = opadapter;
    cM           = cm;
    alarmAdapter = aA;
    if (configname != null) setConfig(configname);
    init();
    //---------- Subscribe to the required tag list --------------
    tadapter.subscribeTagList(this, getTagNames());
}

public void receiveTagChange(TagChangeEvent tagevent){
    repaint();
}

    // Some utilities

	/** draws the ticks on the vertical axis in the current color.
	*   It doesn't draw the axis itself. If grid_on is true, lines will
	*   be drawn from x_origin-tick_size to x_origin+width 
	*   else lines will be drawn from x_origin-tick_size to x_origin
	*/
	public void drawVerticalTicks(Graphics g,
		int x_origin,int y_origin,int width, int height,int nb_ticks,
		double min, double max, int tick_size, boolean grid_on, Color axisColor,
		Color gridColor){
		int i, loc;
		double value;

		Font tfont = g.getFont();
				
		FontMetrics fm;
 		g.setFont(new Font("Helvetica",Font.BOLD,10));
		fm = g.getFontMetrics();

		double delta = max - min;
		double d_y_origin = (new Double(y_origin)).doubleValue();
		double d_height = (new Double(height)).doubleValue();
		double d_nb_ticks = (new Double(nb_ticks)).doubleValue();

		for (i=0; i<=nb_ticks; i++) {
			double d_i = (new Double(i)).doubleValue();
			value = min + ((d_i*delta)/(new Double(nb_ticks)).doubleValue());
			loc = (new Double(d_y_origin + d_height - d_i*(d_height/d_nb_ticks))).intValue();
            g.setColor(axisColor);
			g.drawLine(x_origin-tick_size,loc,x_origin,loc);
            String svalue = String.valueOf(value);
			if (i!=0)
				g.drawString(svalue, x_origin - fm.stringWidth(svalue)-tick_size, 
				loc + fm.getAscent()/2);
			else
				g.drawString(svalue, x_origin - fm.stringWidth(svalue)-tick_size,
				loc);
			if (grid_on) {
			    g.setColor(gridColor);
				g.drawLine(x_origin,loc,x_origin+width,loc);
			}
		}

		g.setFont(tfont);
	}

    /** creates a Vector containing the Tags themselves.
    */
    public Vector getTags() {
        Vector Tags = new Vector();
        for (int i=0; i<TagstoView.size(); i++) {
            Tags.addElement(tagArrays.getTag((String) TagstoView.elementAt(i)));
        }
        return Tags;
    }
    
    /** creates an array of Double containing the values of the Tags.
    */
    public double[] getDoubles() {
        double DoubleValues[] = new double[TagstoView.size()];
        for (int i=0; i<TagstoView.size(); i++) {
            DoubleValues[i] = tagArrays.getTag((String) TagstoView.elementAt(i)).doubleValue();
        }
        return DoubleValues;
    }

	/** get the min and max from all tags in TagstoView. The values are rounded
	*   to drawable limits.
	*/
	public double[] getLimits() {
		double d_m[] = new double[2];
		double min, max;

		if (TagstoView.size()<1) {
			d_m[0]=0;
			d_m[1]=100;
			return(d_m);
		}

		min = 0; max = 100;
		boolean set=false;
		for (int i=0;i<TagstoView.size();i++) {
			double d_a[] = tagArrays.getTag((String) TagstoView.elementAt(i)).getLimits();
			if (set) {
				if (d_a[0]<min) min=d_a[0];
				if (d_a[1]>max) max=d_a[1];
			}
			else {
				min = d_a[0];
				max = d_a[1];
				set = true;
			}
		}

		if (max < min) {
			double value = max; max = min; min=value;
		}
		if (max*min < 0) {
			max = Math.max(max,Math.abs(min));
			min = -1*max;
		}
		double delta = (max-min); if (delta == 0) delta = 1;
		double og = Math.rint(Math.log(delta)/Math.log(10));
		double new_min = (Math.floor(min/Math.pow(10,og)))*Math.pow(10,og);
		double new_max = (Math.ceil(max/Math.pow(10,og)))*Math.pow(10,og);

		d_m[0] = new_min;
		d_m[1] = new_max;
		return(d_m);
	}
    
// -------------------------------------------------------
    void TagListHasChanged() {}
    void init() {}
// -------------------------------------------------------
}