package cern.lhcias.csgui.TagsView;

import cern.lhcias.csgui.interfaces.*;
import cern.lhcias.csgui.Events.*;
import cern.lhcias.csgui.Utils.*;
import cern.lhcias.csgui.Services.*;
import cern.lhcias.csgui.rtdb.*;
import java.awt.*;
import java.util.Vector;

/**
*<br> public class PanelMTagsView extends Panel implements TagsView
*<br>
*<br>  TagsView type implemented:  PanelMTagsView
*<br>
*<br>   This class which is a "TagsView" is a simple base class for a TagsView which display
*<br>   multiple tags. It is intended to be extended.
*<br>
*<br>  Events:
*<br>    As any TagsView, it may fires TagcCliked and Alarm events.
*<br>
*<br>  Configuration:
*<br>    The configuration is a string containing a list of tag names separated by
*<br>    commas (ex: level1,PT215,TT141).
*   @see TagsView
*/
public class PanelMTagsView extends Panel implements TagsView {

public String              TYPE = "PanelMTagsView";
public TagChangeAdapter    tadapter;
public Vector              TagstoView = new Vector();
public TagArrays           tagArrays;
public TagClickedAdapter   tcadapter;
public OpenViewAdapter     ovadapter;
public configurationMgr    cM;
public AlarmAdapter        alarmAdapter;

//----------------------------------------------------
Vector myListeners = new Vector();

public synchronized void addTagClickedListener(TagClickedListener listener) {
     myListeners.addElement(listener);
}

public synchronized void removeTagClickedListener(TagClickedListener listener) {
     myListeners.removeElement(listener);
}

public void fireTagClickedEvent(String name) {
        TagClickedEvent tagclevt = new TagClickedEvent(this);
        tagclevt.setTagName(name);
        for (int i=0; i<myListeners.size(); i++) {
            ((TagClickedListener) myListeners.elementAt(i)).receiveTagClicked(tagclevt);
        }
}

Vector myAlarmListeners  = new Vector();

public synchronized void addAlarmListener( AlarmListener listener) {
    myAlarmListeners.addElement(listener);
}
   
public synchronized void removeAlarmListener(AlarmListener listener) {
    myAlarmListeners.removeElement(listener);
}
           
void fireAlarmEvent(String description, String aGroup, long aDate) {
    AlarmEvent alarmevt = new AlarmEvent(this, description,aGroup,aDate);
    for (int i=0; i<myAlarmListeners.size(); i++) {
        ((AlarmListener) myAlarmListeners.elementAt(i)).receiveAlarm(alarmevt);
    }
}

//---------------- TagsView implementation -----------------------------------------
public void removeOpenViewListener(OpenViewListener listener) {}
public void addOpenViewListener(OpenViewListener listener){}
public void addMouseListener(java.awt.event.MouseListener cMouse) {}
public void setProperty(String tagName, String tagProperty, String propertyValue) {}

public int getComponentNb(){
        return 0;
}

public Vector getComponentsList(){
    return(null);
}

public boolean doYouImplement(String type) {
	if (type.equalsIgnoreCase(TYPE)) return(true);
    return false;
}

public Vector getPossibleTypes() {
    Vector types = new Vector();
    types.addElement(TYPE);
    return(types);
}

public String getType(){
    return(TYPE);
}

public void removeTag(String tagName) {
    TagstoView.removeElement(tagName);
    TagListHasChanged();
    //---------- Subscribe to the required tag list --------------
    tadapter.subscribeTagList(this, TagstoView);
    repaint();
}

public void    removeTag(Vector tagNames) {
    for (int i=0;i<tagNames.size();i++) {
        String s = (String) tagNames.elementAt(i);
        if (s != null)
            TagstoView.removeElement(s);
    }
    TagListHasChanged();
    //---------- Subscribe to the required tag list --------------
    tadapter.subscribeTagList(this, TagstoView);
    repaint();
}

public void    removeTag(TagsView TVcomponent) {
    removeTag(TVcomponent.getTagNames());
}

public void addTag(String tagName) {
    TagstoView.addElement(tagName);
    TagListHasChanged();
    //---------- Subscribe to the required tag list --------------
    tadapter.subscribeTagList(this, TagstoView);
}

public void    addTag(Vector tagNames) {
    for (int i=0;i<tagNames.size();i++) {
        String s = (String) tagNames.elementAt(i);
        if (s != null)
            TagstoView.addElement(s);
    }
    TagListHasChanged();
    //---------- Subscribe to the required tag list --------------
    tadapter.subscribeTagList(this, TagstoView);
}

public void    addTag(TagsView TVcomponent) {
    addTag(TVcomponent.getTagNames());
}

public void setConfig(String config) {
    TagstoView = new Vector();
    int i=1;
    config = config.replace(',',' ');
    String tok = MyUtils.get_token(config,i);
    while (tok != null) {
        TagstoView.addElement(tok);
        i++;
        tok = MyUtils.get_token(config,i);
    }
    TagListHasChanged();
}

public String toString() {
    String configString = new String();
    for (int i=0; i<TagstoView.size();i++) {
        configString = configString + TagstoView.elementAt(i) + ",";
    }
    return configString;
}

public Vector getTagNames() {
    return TagstoView;
}

public Vector getLocalTagNames() {
    return(getTagNames());
}

public void instantiate(TagArrays TA, String configname, TagChangeAdapter adapter,
        TagClickedAdapter cadapter, OpenViewAdapter opadapter, 
        configurationMgr cm, AlarmAdapter aA){
    tadapter    = adapter;
    tagArrays   = TA;
    tcadapter   = cadapter;
    ovadapter   = opadapter;
    cM          = cm;
    alarmAdapter = aA;
    if (configname != null) setConfig(configname);
    init();
    //---------- Subscribe to the required tag list --------------
    tadapter.subscribeTagList(this, getTagNames());
}

public void receiveTagChange(TagChangeEvent tagevent){
    repaint();
}

    // --------- Some utilities -----------------------
    /** create a Vector containing the Tags themselves.
    */
    public Vector getTags() {
        Vector Tags = new Vector();
        for (int i=0; i<TagstoView.size(); i++) {
            Tags.addElement(tagArrays.getTag((String) TagstoView.elementAt(i)));
        }
        return Tags;
    }

    /** creates an array of Double containing the values of the Tags.
    */
    public double[] getDoubles() {
        double DoubleValues[] = new double[TagstoView.size()];
        for (int i=0; i<TagstoView.size(); i++) {
            DoubleValues[i] = tagArrays.getTag((String) TagstoView.elementAt(i)).doubleValue();
        }
        return DoubleValues;
    }
    
    
// -------------------------------------------------------
    void TagListHasChanged() {}
    void init() {}
// -------------------------------------------------------
}