package cern.lhcias.csgui.interfaces;

/**
*   Although a TagsView may be inserted in any java.awt.Container, or
*   in another TagsView (see CompoundView), some container specifically
*   dedicated to TagsView have been developped (it could be a Frame of some sort).
*   They share a common behavior described in this interface.
*/
public interface ViewManager
{
    /** The ViewManager will ask the currently displayed TagsView to
    *   add the Tag named "name" to its list of displayed Tags.
    */
    public void addTag(String name);
    /** The ViewManager will ask the currently displayed TagsView to
    *   add all the Tags handled by tv to its list of displayed Tags.
    */
    public void addTags(TagsView tv);
    /** The ViewManager will ask the currently displayed TagsView to
    *   add all the TagsView tv to its list of displayed TagsViews.
    */
    public void addComponent(TagsView tv);
    /** The ViewManager will ask the currently displayed TagsView to
    *   remove the Tag named "name" from its list of displayed Tags.
    */
    public void removeTag(String name);
    /** The ViewManager will ask the currently displayed TagsView to
    *   remove the TagsView tv from its list of displayed TagsViews.
    */
    public void removeComponent(TagsView tv);
    /** The ViewManager will save the configuration of the currently
    *   displayed TagsView.
    */
	public void Save();
    /** The ViewManager will display the content of the currently displayed
    *   TagsView in a tree-like representation.
    *
    */
	public void showTree();
    /** The ViewManager will hide the tree-like representation of the
    *   currently displayed TagsView.
    */
	public void hideTree();

}