/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.io.IOException;
import org.apache.crimson.parser.Parser2;
import org.apache.crimson.parser.ValidatingParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class XMLReaderImpl
implements XMLReader {
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION = "http://xml.org/sax/features/validation";
    private static final String EXTERNAL_GENERAL = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER = "http://xml.org/sax/features/external-parameter-entities";
    private static final String LEXICAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/lexical-handler/parameter-entities";
    private static final String PROPERTIES = "http://xml.org/sax/properties/";
    private static final String LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final String DECLARATION_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    private boolean namespaces = true;
    private boolean prefixes = false;
    private boolean validation = false;
    private LexicalHandler lexicalHandler;
    private DeclHandler declHandler;
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    private Parser2 parser;
    private boolean parsing;

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(NAMESPACES)) {
            return this.namespaces;
        }
        if (name.equals(NAMESPACE_PREFIXES)) {
            return this.prefixes;
        }
        if (name.equals(VALIDATION)) {
            return this.validation;
        }
        if (name.equals(EXTERNAL_GENERAL) || name.equals(EXTERNAL_PARAMETER)) {
            return true;
        }
        if (name.equals(LEXICAL_PARAMETER_ENTITIES)) {
            return false;
        }
        throw new SAXNotRecognizedException("Feature: " + name);
    }

    public void setFeature(String name, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(NAMESPACES)) {
            this.checkNotParsing("feature", name);
            this.namespaces = state;
            if (!this.namespaces && !this.prefixes) {
                this.prefixes = true;
            }
        } else if (name.equals(NAMESPACE_PREFIXES)) {
            this.checkNotParsing("feature", name);
            this.prefixes = state;
            if (!this.prefixes && !this.namespaces) {
                this.namespaces = true;
            }
        } else if (name.equals(VALIDATION)) {
            this.checkNotParsing("feature", name);
            if (this.validation != state) {
                this.parser = null;
            }
            this.validation = state;
        } else {
            if (name.equals(EXTERNAL_GENERAL) || name.equals(EXTERNAL_PARAMETER) || name.equals(LEXICAL_PARAMETER_ENTITIES)) {
                throw new SAXNotSupportedException("Feature: " + name);
            }
            throw new SAXNotRecognizedException("Feature: " + name);
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(LEXICAL_HANDLER)) {
            return this.lexicalHandler;
        }
        if (name.equals(DECLARATION_HANDLER)) {
            return this.declHandler;
        }
        throw new SAXNotRecognizedException("Property: " + name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        String detail = "Property: " + name;
        if (name.equals(LEXICAL_HANDLER)) {
            if (!(value instanceof LexicalHandler)) {
                throw new SAXNotSupportedException(detail);
            }
            this.lexicalHandler = (LexicalHandler)value;
        } else if (name.equals(DECLARATION_HANDLER)) {
            if (!(value instanceof DeclHandler)) {
                throw new SAXNotSupportedException(detail);
            }
            this.declHandler = (DeclHandler)value;
        } else {
            throw new SAXNotRecognizedException("Property: " + name);
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException("Null entity resolver");
        }
        this.entityResolver = resolver;
        if (this.parser != null) {
            this.parser.setEntityResolver(resolver);
        }
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null DTD handler");
        }
        this.dtdHandler = handler;
        if (this.parser != null) {
            this.parser.setDTDHandler(this.dtdHandler);
        }
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null content handler");
        }
        this.contentHandler = handler;
        if (this.parser != null) {
            this.parser.setContentHandler(handler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null error handler");
        }
        this.errorHandler = handler;
        if (this.parser != null) {
            this.parser.setErrorHandler(this.errorHandler);
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    public void parse(InputSource input) throws IOException, SAXException {
        if (this.parsing) {
            throw new SAXException("Parser is already in use");
        }
        this.parsing = true;
        if (this.parser == null) {
            this.parser = this.validation ? new ValidatingParser() : new Parser2();
        }
        this.parser.setNamespaceFeatures(this.namespaces, this.prefixes);
        this.parser.setContentHandler(this.contentHandler);
        this.parser.setDTDHandler(this.dtdHandler);
        this.parser.setErrorHandler(this.errorHandler);
        this.parser.setEntityResolver(this.entityResolver);
        this.parser.setLexicalHandler(this.lexicalHandler);
        this.parser.setDeclHandler(this.declHandler);
        try {
            this.parser.parse(input);
            Object var3_2 = null;
            this.parsing = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.parsing = false;
            throw throwable;
        }
    }

    private void checkNotParsing(String type, String name) throws SAXNotSupportedException {
        if (this.parsing) {
            throw new SAXNotSupportedException("Cannot change " + type + ' ' + name + " while parsing");
        }
    }
}

