package tester;

/**
 * @(#)TimePanel.java	03/19/02
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 */

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * TimePanel.
 * This class creates a custom panel that contains the test timer.
 * If modified, it can be used as a bean.
 *
 * @author Panagiotis Plevrakis
 *
 * Email: pplevrakis@hotmail.com
 * URL:   http://www30.brinkster.com/panos69/JProjects.aspx
 */
public class TimePanel extends JPanel {
    private Font font = new Font("Arial", Font.BOLD, 16);
    protected JTextField time;
    private Color timerColor = Color.white;
    private Color panelColor = Color.darkGray;
    private int hrs, min, sec, secondsCounter;
    private Timer timer;
    private boolean ended = false;
    private int initTimerVal;
    private int warningCounterLimit = (int) (initTimerVal / 4);
    private ExamFrame ef;

    public TimePanel(ExamFrame ef) {
        this.ef = ef;
        secondsCounter = (int) (ef.timePerQues * 59);
        initTimerVal = secondsCounter;
        timer = new javax.swing.Timer(1000, new timerListener());
        time = new JTextField(11);
        time.setText("           0 : 00 : 00");
        time.setBackground(timerColor);
        time.setFont(font);
        time.setEditable(false);
        setBackground(panelColor);
        setLayout(new BorderLayout());
        add(time, BorderLayout.CENTER);
    }

    public void startTimer() {
        timer.start();
    }

    public void stopTimer() {
        timer.stop();
    }

    public void displayTimer() {
        setVisible(true);
    }

    public void hideTimer() {
        setVisible(false);
    }

    public void setInitialTimerValue(int sec) {
        initTimerVal = sec;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setPanelColor(Color panelColor) {
        this.panelColor = panelColor;
    }

    public void setTimerColor(Color timerColor) {
        this.timerColor = timerColor;
    }

    public int getInitialTimerValue() {
        return initTimerVal;
    }

    public Font getFont() {
        return font;
    }

    public Color getPanelColor() {
        return panelColor;
    }

    public Color getTimerColor() {
        return timerColor;
    }

    public int getHours() {
        return hrs;
    }

    public int getMinutes() {
        return min;
    }

    public int getSeconds() {
        return sec;
    }

    private class timerListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            hrs = (int) (secondsCounter / 3600);
            min = (int) (secondsCounter / 60 - hrs * 60);
            sec = (int) (secondsCounter - hrs * 3600 - min * 60);
            --secondsCounter;

            if (ended == true)
                return;

            if (secondsCounter <= 0) {
                ended = true;

                // timer expired.
                Object[] options = { "OK"};
                ef.grade.setEnabled(true);
                int option = JOptionPane.showOptionDialog(null, "Press Grade to mark exam",
                        "Time Limit Expired!!!", JOptionPane.DEFAULT_OPTION,
                        JOptionPane.WARNING_MESSAGE, null, options, options[0]);
            }

            // change color based on time remaining
            if (secondsCounter <= warningCounterLimit) {
                time.setBackground(Color.red);
                time.setForeground(Color.white);
            }

            // update timer value
            StringBuffer bf = new StringBuffer();

            bf.append("           ");
            bf.append(hrs);
            bf.append(" : ");
            if (new String("" + min).length() == 1)
                bf.append("0" + min);
            else bf.append(min);
            bf.append(" : ");
            if (new String("" + sec).length() == 1)
                bf.append("0" + sec);
            else bf.append(sec);
            time.setText(bf.toString());
            if (time.getText().equals("          0 : 00 : 01"))
                time.setText("           0 : 00 : 00");
        }
    }
}
