package com.unipro.products.smgui;

import java.io.*;

import com.unipro.smlib.*;

/**
 * This class holds the Acknowledge object.
 *
 * @author Alexey Skorokhodov
 * @version 1.0
 */
public class ACKBean
    implements Serializable {

    private ACKReport report = null;

    /**
     * This constructor creates new ACKBean object from ACKReport.
     *
     * @param report ACKReport object
     */
    public ACKBean(ACKReport report){
        if (report == null) {
            throw new NullPointerException("ACKReport object passed is null");
        }
        this.report = report;
    }

    /**
     * Gets the stored ACKReport.
     *
     * @return the ACKReport
     */
    public ACKReport getReport() {
        return report;
    }

    /**
     * This method is specially for displaying a message in Mails Table.
     * This method returns the value of the column given.
     * The column number is considered to be in the Model coordinates, not any View coordinates.
     *
     * This method is called normally only from MessagesTableModel.getValueAt() method.
     *
     * @param i the ID of the column
     * @return the value for the given column ID
     */
    public Object getField(int i) {
        Object o = null;
        switch (i) {
            case ACKsTableModel.MODEL_COLUMN_TIME:
                o = getReport().getSMSCTime().getTime();
                break;

            case ACKsTableModel.MODEL_COLUMN_TEXT:
                String str = "message to " + getReport().getRecipientNumber() +
                    ": " +
                    getStatusDescription(getReport().getStatus()) + "";

                o = str;
                break;

            default:

        }
        return o;
    }

    /**
     * Gets the status description for the stored ACKReport.
     *
     * @return the status description
     */
    public String getStatusDescription() {
        return getStatusDescription(report.getStatus());
    }

    private String getStatusDescription(int status) {
        String result = null;
        switch (status) {
            case ACKReport.STATUS_DELIVERED:
                result = "delivered";
                break;

            case ACKReport.STATUS_REJECTED:
                result = "rejected";
                break;

            case ACKReport.STATUS_UNKNOWN:
                result = "unknown";
                break;

            default:
                System.err.println("unknown status: " + status);

        }

        return result;
    }

}
