package com.unipro.products.smgui;

import java.util.*;

import javax.swing.table.*;

import com.unipro.smlib.*;

/**
 * This class holds the Acknowledges table data.
 *
 * @author Alexey Skorokhodov
 * @version 1.0
 */
public class ACKsTableModel
    extends DefaultTableModel {

    public static final int MODEL_COLUMN_TIME = 0;
    public static final int MODEL_COLUMN_TEXT = 1;

    /**
     * This array holds the default column names for the 'Acknowledges' table.
     */
    public static final String[] MODEL_DEFAULT_COLUMNS_NAMES = {
        "Time", "Status"};

    /**
     * This array holds the default columns visibility settings
     * for the 'Acknowledges' table.
     */
    public static final boolean[] MODEL_DEFAULT_COLUMNS_VISIBILITY = {
        true, true};

    /**
     * This array holds the default column value types for the 'Acknowledges'
     * table (e.g. some columns can store images, some - strings, etc...).
     */
    public static final Class[] MODEL_DEFAULT_COLUMNS_TYPES = {
        String.class, String.class};

    /** Indicates which columns are visible */
    private boolean[] columnsVisible;

    /**
     * This constructor creates default ACKsTableModel object with empty
     * Data vector, default columns names and visibility settings.
     */
    public ACKsTableModel() {
        dataVector = new Vector();
        Vector v = new Vector();
        for (int i=0; i < MODEL_DEFAULT_COLUMNS_NAMES.length; i++) {
            v.add(MODEL_DEFAULT_COLUMNS_NAMES[i]);
        }
        this.columnIdentifiers = v;

        columnsVisible = new boolean[columnIdentifiers.size()];
        setColumnVisibility(MODEL_DEFAULT_COLUMNS_VISIBILITY);

    }

    /**
     * This constructor creates ACKsTableModel object with the given Data
     * vector, with default columns names and visibility settings.
     *
     * @param dataVector the vector to use for the model
     */
    public ACKsTableModel(Vector dataVector) {
        this.dataVector = dataVector;
        System.err.println("ACKsTableModel(): creating NEW model. rows=" +
                           this.getRowCount());
        // set default values
        Vector v = new Vector();
        for (int i=0; i < MODEL_DEFAULT_COLUMNS_NAMES.length; i++) {
            v.add(MODEL_DEFAULT_COLUMNS_NAMES[i]);
        }
        this.columnIdentifiers = v;

        columnsVisible = new boolean[columnIdentifiers.size()];
        setColumnVisibility(MODEL_DEFAULT_COLUMNS_VISIBILITY);

    }

    /**
     * Inserts ACKReport object to the passed position of the table Data.
     *
     * @param report the report to insert
     * @param position of the report to insert
     */
    public void insertReport(ACKReport report, int position) {
        dataVector.insertElementAt(new ACKBean(report), position);
        //System.err.println("MailTableModel: row inserted. rows=" + this.getRowCount());
    }

    /**
     * Adds ACKReport object to the end of the table Data.
     *
     * @param report the report to add
     */
    public void addReport(ACKReport report) {
        dataVector.add(new ACKBean(report));
        //System.err.println("MailTableModel: row added. rows=" + this.getRowCount());
    }

    //---------------------
    // Implementation of the TableModel methods
    //---------------------

    /**
     * Returns an attribute value for the cell at <code>row</code>
     * and <code>column</code>.
     *
     * @param   row             the row whose value is to be queried
     * @param   column          the column whose value is to be queried
     * @return                  the value Object at the specified cell
     * @exception  ArrayIndexOutOfBoundsException  if an invalid row or
     *               column was given
     */
    public Object getValueAt(int row, int column) {
        ACKBean bean = (ACKBean) dataVector.elementAt(row);
        return bean.getField(getNumber(column));
    }

    /**
     * Sets the visibility for the table columns.
     *
     * @param newVisibility array of visibility flags for columns
     */
    public void setColumnVisibility(boolean newVisibility[]) {
        // if the length is acceptable
        if ( (newVisibility != null) &&
            (newVisibility.length <= this.columnsVisible.length)) {
            for (int i = 0; i < newVisibility.length; i++) {
                columnsVisible[i] = newVisibility[i];
            }
        }
    }

    /**
     * Gets the Acknowledge object with the given row number.
     *
     * @param which the number of the row in the table
     * @return the ACKBean
     */
    public ACKBean getReport(int which) {
        return (ACKBean) dataVector.elementAt(which);
    }

    /**
     * This function converts a column number in the table view
     * to the right number of the table model.
     *
     * @param col the number of the column in the table view
     * @return the number of the column of the table
     */
    protected int getNumber(int col) {
        int n = col; // right number to return
        int i = 0;
        do {
            if (! (columnsVisible[i])) {
                n++;
            }
            i++;
        } while (i < n);

        // If we are on an invisible column,
        // we have to go one step further
        while (!columnsVisible[n]) {
            n++;
        }
        return n;
    }

    /**
     * This method is overriden to disable 'editable' feature for cells.
     * It always returns 'false' for any 'row' and 'column' value.
     *
     * @param row this value is ignored
     * @param column this value is ignored
     * @return always returns false
     */
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    /**
     * Clears the data in the model.
     */
    public void clearData() {
        this.dataVector.clear();
    }

}
