package com.unipro.products.smgui;

import java.io.*;
import java.util.*;

import java.awt.*;
import javax.swing.*;

import com.unipro.smlib.*;

/**
 * This is the main class of SMS Manager, which can be executed from system console.
 * Welcome! ;-)
 *
 * @author Alexey Skorokhodov, askorokhodov@unipro.ru
 * @version 1.0
 */
public class SMGUIApplication {

    //public static int NUMBER_OF_TRIAL_ALLOWED_MESSAGES = 50;

    //public static String TRIAL_EXPIRED_MESSAGE =
    //        "This version of SMS Manager is supposed to use with trial version of SmLib. \n" +
    //        "You can't send/receive more than "+
    //        NUMBER_OF_TRIAL_ALLOWED_MESSAGES + " messages in one session.";

    /**
     * This constant defines the name of the file which holds the Acknowledges.
     */
    private static String ACKS_FILE_NAME = "acks.dat";

    /**
     * This constant defines the name of the file which holds the Incoming Messages.
     */
    private static String MESSAGES_FILE_NAME = "messages.dat";

    /**
     * This constant defines the name of the file which holds the Project Settings.
     */
    private static String SETTINGS_FILE_NAME = "settings.dat";

    /**
     * This constant defines the name of the file which holds the recent Recipients list.
     */
    private static String RECIPIENTS_FILE_NAME = "recipients.dat";

    /**
     * This constant defines the default COM-port to use to connect to Mobile phone.
     */
    private static String DEFAULT_PORT = Configurator.PORT_COM3;

    /**
     * This constant defines the default COM-port baud rate to use to connect to Mobile phone.
     */
    private static int DEFAULT_BAUD = Configurator.BAUD_19200;

    /**
     * This constant defines the default SMSC number to send the SMSes.
     */
    public static String DEFAULT_SMSC_NUMBER = "79029869990";

    /**
     * This constant defines the URL of Unipro Mobiles web-site.
     */
    public static String MOBILES_URL = "http://mobiles.unipro.ru/smlib";

    /**
     * This constant defines the application version.
     */
    //public static String APPLICATION_VERSION = "1.0";
    public static String APPLICATION_VERSION = "2.0";

    boolean packFrame = false;

    public static SmsManager smsManager;
    public static Settings settings;
    public static MessagesTableModel messagesTableModel;
    public static ACKsTableModel acksTableModel;
    public static RecipientsComboBoxModel recipientsModel;

    /** Construct the application */
    public SMGUIApplication() throws Exception {
        MainFrame frame = new MainFrame();

        //Validate frames that have preset sizes
        //Pack frames that have useful preferred size info, e.g. from their layout
        if (packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        centerFrame(frame);
        frame.setVisible(true);

        try {
            smsManager.init(new Configurator(SMGUIApplication.
                settings.getPortName(),
                Integer.parseInt(settings.getPortBaud())));
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(frame, ex.getLocalizedMessage(),
                                          "Error",
                                          JOptionPane.ERROR_MESSAGE);
        }



        smsManager.addMessageListener(frame);
        smsManager.addACKListener(frame);
    }

    /**
     * The main method.
     *
     * @param args these args are not used by this application
     */
    public static void main(String[] args) {

        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            init();
            new SMGUIApplication();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Clears the data in SMS Manager application (incoming messages,
     * acknowledges and recipients).
     */
    public static void clearAll() {
        messagesTableModel.clearData();
        messagesTableModel.fireTableDataChanged();
        acksTableModel.clearData();
        acksTableModel.fireTableDataChanged();
        recipientsModel.removeAllElements();
    }

    /**
     * Clears the data in SMS Manager application (incoming messages).
     */
    public static void clearMessageTable() {
        messagesTableModel.clearData();
        messagesTableModel.fireTableDataChanged();
    }

    /**
     * Clears the data in SMS Manager application (acknowledges).
     */
    public static void clearACKTable() {
        acksTableModel.clearData();
        acksTableModel.fireTableDataChanged();
    }

    /**
     * Stores the settings on exit.
     */
    public static void onFinish() {
        smsManager.close();
        save(SETTINGS_FILE_NAME, settings);

        save(RECIPIENTS_FILE_NAME, recipientsModel);

        save(MESSAGES_FILE_NAME, messagesTableModel.getDataVector());
        save(ACKS_FILE_NAME, acksTableModel.getDataVector());
        System.err.println("Saved settings.");
    }

    private static void init() {
        smsManager = SmsManager.getInstance();

        recipientsModel = (RecipientsComboBoxModel) load(RECIPIENTS_FILE_NAME,
            RecipientsComboBoxModel.class);
        if (recipientsModel == null) {
            recipientsModel = new RecipientsComboBoxModel();
        }

        Vector messagesVector = (Vector) load(MESSAGES_FILE_NAME, Vector.class);
        if (messagesVector == null) {
            messagesTableModel = new MessagesTableModel();
        } else {
            messagesTableModel = new MessagesTableModel(messagesVector);
        }

        Vector acksVector = (Vector) load(ACKS_FILE_NAME, Vector.class);
        if (acksVector == null) {
            acksTableModel = new ACKsTableModel();
        } else {
            acksTableModel = new ACKsTableModel(acksVector);
        }

        settings = (Settings) load(SETTINGS_FILE_NAME, Settings.class);
            if (settings == null) {
                // set the default values
                settings = new Settings();
                settings.setPortName(DEFAULT_PORT);
                settings.setPortBaud(DEFAULT_BAUD + "");
                settings.setSmsCenterNumber(DEFAULT_SMSC_NUMBER);
                settings.setAllowedIncomingSMS(true);
            }
    }

    /**
     * Updates the SMSManager configuration.
     *
     * @throws ValidationException
     * @throws PortConnectionException
     * @throws MobileException
     * @see com.unipro.smlib.SmsManager#init(Configurator) SmsManager.init(..)
     */
    public static void refreshSMSManager() throws ValidationException,
        PortConnectionException, MobileException {
        if (smsManager == null) {
            return;
        }
        smsManager.close();
        smsManager.init(new Configurator(settings.getPortName(),
                                         Integer.parseInt(settings.getPortBaud())));
    }

    private static void save(String fileName, Object object) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
        } catch (Exception e) {
            System.err.println("save(): can't write to file:" + fileName + ". " +
                               e);
        }
    }

    private static Object load(String fileName, Class objclass) {
        Object result = null;
        FileInputStream fos = null;
        try {
            fos = new FileInputStream(fileName);
            ObjectInputStream oos = new ObjectInputStream(fos);
            result = oos.readObject();
        } catch (Exception e) {
            System.err.println("load(): can't load from file:" + fileName +
                               ". " + e);
        } finally {
            if (fos != null) {
                try {
                    fos.close();
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return result;
    }

    /**
     * Centers the window frame on the screen.
     *
     * @param frame the frame to center
     */
    public static void centerFrame(java.awt.Component frame) {
        //Center the window
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation( (screenSize.width - frameSize.width) / 2,
                          (screenSize.height - frameSize.height) / 2);

    }
}