package com.unipro.products.smgui;

import java.io.*;

/**
 * This class holds the SMS manager settings like Gate setup, etc.
 *
 * @author Alexey Skorokhodov
 * @version 1.0
 */
public class Settings
    implements Serializable {

    /** this array holds the most used port names */
    public static String PORT_NAMES[] = {
        "COM1", "COM2", "COM3", "COM4"};

    /** this array holds the most used port baud rates */
    public static String PORT_BAUDS[] = {
        "19200", "9600", "4800", "2400"};

    private String portName;
    private String portBaud;
    private byte sendRetriesCount;
    private String smsCenterNumber;
    private boolean requireAcks;
    private boolean allowedIncomingSMS;
    private boolean replyPath;
    private boolean isFlash;
    private boolean rejectDuplicates;

    /**
     * Gets the port name.
     * @return the port name ("COM1", "COM2", ...)
     */
    public String getPortName() {
        return portName;
    }

    /**
     * Sets the port name.
     * @param portName the port name ("COM1", "COM2", ...)
     */
    public void setPortName(String portName) {
        this.portName = portName;
    }

    /**
     * Gets the port baud rate.
     * @return the port baud rate ("19200", "9600", ...)
     */
    public String getPortBaud() {
        return portBaud;
    }

    /**
     * Sets the port baud rate.
     * @param portBaud the port baud rate ("19200", "9600", ...)
     */
    public void setPortBaud(String portBaud) {
        this.portBaud = portBaud;
    }

    /**
     * Shows, how much tries are allowed for SMS Gate to send a message.
     * @return the number of times
     */
    public byte getSendRetriesCount() {
        return sendRetriesCount;
    }

    /**
     * Sets the number of tries for SMS Gate to send a message.
     * @param sendRetriesCount the number of times
     */
    public void setSendRetriesCount(byte sendRetriesCount) {
        this.sendRetriesCount = sendRetriesCount;
    }

    /**
     * Gets the SMSC number to use to send SMSes.
     * @return the SMSC number
     */
    public String getSmsCenterNumber() {
        return smsCenterNumber;
    }

    /**
     * Sets the SMSC number to use to send SMSes.
     * @param smsCenterNumber the SMSC number
     */
    public void setSmsCenterNumber(String smsCenterNumber) {
        this.smsCenterNumber = smsCenterNumber;
    }

    /**
     * Shows, if the Acknowledges are required for sent SMSes.
     * @return boolean flag
     */
    public boolean isRequireAcks() {
        return requireAcks;
    }

    /**
     * Sets, if the Acknowledges are required for sent SMSes.
     * @return requireAcks boolean flag
     */
    public void setRequireAcks(boolean requireAcks) {
        this.requireAcks = requireAcks;
    }

    /**
     * Shows, if incoming messages are allowed
     * @return boolean flag
     */
    public boolean isAllowedIncomingSMS() {
        return allowedIncomingSMS;
    }

    /**
     * Enables/disables receiving of incoming messages
     * @param allowedIncomingSMS boolean flag
     */
    public void setAllowedIncomingSMS(boolean allowedIncomingSMS) {
        this.allowedIncomingSMS = allowedIncomingSMS;
    }

    /**
     * Shows, if the Reply Path flag is required for sent SMSes
     * @return boolean flag
     */
    public boolean isReplyPath() {
        return replyPath;
    }

    /**
     * Sets, if the Reply Path flag is required for sent SMSes
     * @param replyPeth boolean flag
     */
    public void setReplyPath(boolean replyPath) {
        this.replyPath = replyPath;
    }

    /**
     * Shows, if the Flash flag is required for sent SMSes
     * @return boolean flag
     */
    public boolean isFlash() {
        return isFlash;
    }

    /**
     * Sets, if the Flash flag is required for sent SMSes
     * @param isFlash boolean flag
     */
    public void setFlash(boolean isFlash) {
        this.isFlash = isFlash;
    }

    /**
     * Shows, if the Reject duplicates flag is required for sent SMSes
     * @return boolean flag
     */
    public boolean isRejectDuplicates() {
        return rejectDuplicates;
    }

    /**
     * Sets, if the Reject duplicates flag is required for sent SMSes
     * @param rejectDuplicates boolean flag
     */
    public void setRejectDuplicates(boolean rejectDuplicates) {
        this.rejectDuplicates = rejectDuplicates;
    }

}