/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceException;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.broker.ResourceUnavailableException;
import org.webmacro.engine.Template;
import org.webmacro.servlet.Config;
import org.webmacro.servlet.ErrorHandler;
import org.webmacro.servlet.Handler;
import org.webmacro.servlet.HandlerException;
import org.webmacro.servlet.WebContext;
import org.webmacro.util.Log;

public abstract class WMServlet
extends HttpServlet {
    private static ResourceBroker _broker = null;
    private static int _brokerUsers = 0;
    private static final Log _log = new Log("WMServlet", "WebMacro Abstract Servlet");
    private String _problem = "Not yet initialized: Your servlet API tried to access WebMacro without first calling init()!!!";

    public final synchronized void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void init() {
        ++_brokerUsers;
        if (_broker == null) {
            try {
                _broker = new ResourceBroker();
                _broker.join(new Config());
                String string = (String)_broker.getValue("config", "Providers");
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = (String)stringTokenizer.nextElement();
                    try {
                        Class<?> clazz = Class.forName(string2);
                        ResourceProvider resourceProvider = (ResourceProvider)clazz.newInstance();
                        _broker.join(resourceProvider);
                        _log.info("Loaded provider: " + string2);
                    }
                    catch (Exception exception) {
                        _log.exception(exception);
                        _log.error("Could not load resource provider \"" + string2 + "\":" + exception);
                    }
                }
            }
            catch (Exception exception) {
                _broker = null;
                _brokerUsers = 0;
                _log.exception(exception);
                _log.error("Could not initialize the broker!\n" + "*** Check that webmacro.properties was in your servlet\n" + "*** classpath, in a similar place to webmacro.jar \n" + "*** and that all values were set correctly.\n");
                this._problem = "Unable to initialize WebMacro:\n\n" + exception + "\n\n" + "This means critical providers could not be loaded. The usual\n" + "cause of this is that the configuration file could not\n" + "be loaded from the servlet classpath. Check in particular\n" + "that webmacro.properties, WebMacro's configuration file, is\n" + "in your classpath (the same place as webmacro.jar).\n" + "The fact that you are seeing this error means your servlet\n" + "runner did find webmacro.jar, and launched your WebMacro\n" + "servlet--however WebMacro was then unable to initialize.\n\n" + "WebMacro may have logged additional details to its log, or\n" + "to its standard output.\n";
                return;
            }
        }
        try {
            this.start();
            this._problem = null;
            return;
        }
        catch (ServletException servletException) {
            _log.exception((Object)servletException);
            this._problem = "WebMacro application code failed to initialize: \n" + (Object)((Object)servletException) + "\n" + "This error is the result of a failure in the\n" + (Object)((Object)servletException) + "code supplied by the application programmer.\n";
        }
    }

    public final synchronized void destroy() {
        this.stop();
        if (--_brokerUsers == 0 && _broker != null) {
            _broker.shutdown();
            _broker = null;
        }
    }

    protected final void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRequest(new WebContext(_broker, httpServletRequest, httpServletResponse));
    }

    protected final void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRequest(new WebContext(_broker, httpServletRequest, httpServletResponse));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doRequest(WebContext webContext) {
        if (this._problem != null) {
            this.init();
            if (this._problem != null) {
                try {
                    PrintWriter printWriter = webContext.getResponse().getWriter();
                    ((Writer)printWriter).write(this._problem);
                    ((Writer)printWriter).flush();
                    ((Writer)printWriter).close();
                    return;
                }
                catch (Exception exception) {
                    _log.error(this._problem);
                }
                return;
            }
        }
        Template template = null;
        try {
            template = this.handle(webContext);
        }
        catch (HandlerException handlerException) {
            _log.exception(handlerException);
            template = this.error(webContext, "Your handler was unable to process the request successfully " + "for some reason. Here are the details:<p>" + handlerException);
        }
        catch (Exception exception) {
            _log.exception(exception);
            template = this.error(webContext, "The handler WebMacro used to handle this request failed for " + "some reason. This is likely a bug in the handler written " + "for this application. Here are the details:<p>" + exception);
        }
        this.execute(template, webContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Template error(WebContext webContext, String string) {
        Template template = null;
        _log.warning(string);
        ErrorHandler errorHandler = new ErrorHandler();
        try {
            webContext.put(this.getConfig("ErrorVariable"), string);
            return errorHandler.accept(webContext);
        }
        catch (ResourceException resourceException) {
            _log.error("Could not find error variable in Config: " + resourceException);
            return template;
        }
        catch (Exception exception) {
            _log.error("Unable to use ErrorHandler: " + exception);
        }
        return template;
    }

    protected final ResourceBroker getBroker() {
        return _broker;
    }

    protected final Template getTemplate(String string) throws ResourceUnavailableException {
        return (Template)_broker.getValue("template", string);
    }

    protected final Handler getHandler(String string) throws ResourceUnavailableException {
        return (Handler)_broker.getValue("handler", string);
    }

    protected final String getConfig(String string) throws ResourceUnavailableException {
        return (String)_broker.getValue("config", string);
    }

    /*
     * Exception decompiling
     */
    protected final void execute(Template var1, WebContext var2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract Template handle(WebContext var1) throws HandlerException;

    protected void start() throws ServletException {
    }

    protected void stop() {
    }
}

