/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import java.util.Dictionary;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceMap;
import org.webmacro.servlet.CGI_Impersonator;
import org.webmacro.util.Log;
import org.webmacro.util.NullDictionary;
import org.webmacro.util.java2.HashMap;

public final class WebContext
extends HashMap {
    private static final Log _log = new Log("webcon", "WebContext Messages");
    private static final Dictionary _nullDictionary = new NullDictionary();
    final ResourceBroker broker_;
    final HttpServletRequest request_;
    final HttpServletResponse response_;
    private Dictionary _form = null;
    private CGI_Impersonator _cgi = null;

    public final HttpServletRequest getRequest() {
        return this.request_;
    }

    public final HttpServletResponse getResponse() {
        return this.response_;
    }

    public final HttpSession getSession() {
        return this.request_.getSession(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getForm(String string) {
        try {
            return this.request_.getParameterValues(string)[0];
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public final String[] getFormList(String string) {
        return this.request_.getParameterValues(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getConfig(String string) {
        try {
            return (String)this.broker_.getValue("config", string);
        }
        catch (Exception exception) {
            _log.exception(exception);
            _log.error("Could not load config");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ResourceMap getUsers() {
        try {
            return this.broker_.get("user");
        }
        catch (Exception exception) {
            _log.exception(exception);
            _log.error("Could not load user map");
            return null;
        }
    }

    public final CGI_Impersonator getCGI() {
        return this._cgi != null ? this._cgi : (this._cgi = new CGI_Impersonator(this.request_));
    }

    public final Cookie getCookie(String string) {
        Cookie[] cookieArray = this.request_.getCookies();
        if (cookieArray == null) {
            return null;
        }
        int n = 0;
        while (n < cookieArray.length) {
            if (cookieArray[n] != null && cookieArray[n].getName().equals(string)) {
                return cookieArray[n];
            }
            ++n;
        }
        return null;
    }

    public final void setCookie(String string, String string2) {
        Cookie cookie = new Cookie(string, string2);
        this.response_.addCookie(cookie);
    }

    public final ResourceBroker getBroker() {
        return this.broker_;
    }

    WebContext(ResourceBroker resourceBroker, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.broker_ = resourceBroker;
        this.request_ = httpServletRequest;
        this.response_ = httpServletResponse;
    }
}

