/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command;

import X10Gimli.Command.Command;
import X10Gimli.System.Definition;
import X10Gimli.System.Environment;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.ValueType;

public final class DefineCommand
extends Command {
    private Definition dDef;

    public DefineCommand() {
    }

    public DefineCommand(Definition def) {
        this.setDefinition(def);
    }

    public void setDefinition(Definition def) {
        this.dDef = def;
    }

    public Definition getDefinition() {
        return this.dDef;
    }

    public ValueType execute(EnvironmentSmall env) {
        if (env != null) {
            Definition d = env.findDefinition(this.dDef.getName());
            if (d == null) {
                Environment e = env.getFullEnvironment();
                if (e != null) {
                    e.setDefinition(this.dDef);
                }
            } else {
                d.setValue(this.dDef.getValue());
            }
        }
        return null;
    }

    protected void executionOutput() {
        this.sBuf.append("define ");
        this.sBuf.append(this.dDef.getName());
        this.sBuf.append(" = ");
        this.sBuf.append(this.dDef.getValue().string);
    }

    public String toX10GIMLI(int depth) {
        this.prepareOutputDepth(depth);
        this.sBuf.append("define ");
        this.sBuf.append(this.dDef.getName());
        this.sBuf.append(" = ");
        this.sBuf.append(this.dDef.getValue().toX10GIMLI());
        this.sBuf.append(";\n");
        return this.sBuf.toString();
    }
}

