/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command.Function;

import X10Gimli.Command.FuncCommand;
import X10Gimli.Debug;
import X10Gimli.System.Environment;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueList;
import X10Gimli.Value.ValuePacket;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueType;
import java.util.ArrayList;

public class PacketCommand
extends FuncCommand {
    private ValueList interpretValues(ValueList l, EnvironmentSmall env) {
        ValueList list = new ValueList();
        for (int i = 1; i <= l.getSize(); ++i) {
            ValueType val = l.getItem(i);
            list.addItem(val.getValue(env));
        }
        return list;
    }

    private ValueList identifierValues(ValueList l, EnvironmentSmall env) {
        ValueList list = new ValueList();
        for (int i = 1; i <= l.getSize(); ++i) {
            ValueType val = l.getItem(i);
            val = !(val instanceof ValueIdent) && !(val instanceof ValueString) ? val.getValue(env) : new ValueIdent(((Value)val).getValueString());
            list.addItem(new ValueIdent(val.toString()));
        }
        return list;
    }

    public ValueType execute(EnvironmentSmall env) {
        this.prepareParams();
        if (this.checkNumParams(3) && env != null) {
            ValuePacket packet = new ValuePacket();
            ValueIdent ident = this.getIdentParam(0);
            this.prepareParams(env);
            ValueList lookup = this.identifierValues(this.getListParam(1), env);
            ValueList value = this.interpretValues(this.getListParam(2), env);
            if (lookup.getItems().size() == value.getItems().size()) {
                ArrayList<String> lookupstrings = new ArrayList<String>();
                for (int i = 0; i < lookup.getItems().size(); ++i) {
                    lookupstrings.add(((Value)lookup.getItems().elementAt(i)).getValueString());
                }
                Environment e = env.getFullEnvironment();
                if (e != null) {
                    packet.setType(ident.getValueString());
                    packet.setLookup(lookupstrings);
                    packet.setValues(new ArrayList(value.getItems()));
                    return packet;
                }
            } else {
                Debug.error(106, String.valueOf(String.valueOf(new StringBuffer("(Runtime) ").append(this.toString()).append(" lookup and value lists must be equal lengths."))));
            }
        }
        return null;
    }
}

