/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command.Function;

import X10Gimli.Command.FuncCommand;
import X10Gimli.Debug;
import X10Gimli.Parser;
import X10Gimli.System.AllImports;
import X10Gimli.System.Definition;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.System.SystemModel;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValuePacket;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueType;
import java.util.ArrayList;

public class ReadCommand
extends FuncCommand {
    public ValueType execute(EnvironmentSmall env) {
        super.execute(env);
        SystemModel m = env.getSystemModel();
        if (this.checkNumParams(1)) {
            ValueString file = this.getStringParam(0);
            if (m != null) {
                String path = AllImports.resolvePath(file.getValueString());
                if (path == null) {
                    Debug.error(0, String.valueOf(String.valueOf(new StringBuffer("File ").append(file).append(" not found to read."))));
                    return ValueNothing.value;
                }
                Parser parse = new Parser();
                parse.setInputFile(path);
                ArrayList defs = parse.productionDefinitionList();
                ValuePacket packet = new ValuePacket();
                int size = defs.size();
                for (int i = 0; i < size; ++i) {
                    Definition d = (Definition)defs.get(i);
                    packet.addItem(d.getName(), d.getValue());
                }
                Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Successfully read file ").append(path).append(".\""))));
                return packet;
            }
        } else {
            Debug.error(100, "(Runtime) Expecting file name to read.");
        }
        return null;
    }
}

