/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command;

import X10Gimli.Command.Command;
import X10Gimli.Command.ElseCommand;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueType;

public final class IfCommand
extends Command {
    private ValueType ctCondition;
    private Command cCommand;
    private ElseCommand ecElse;

    public IfCommand() {
    }

    public IfCommand(ValueType condition, Command command, ElseCommand elsecommand) {
        this.setCondition(condition);
        this.setCommand(command);
        this.setElseCommand(elsecommand);
    }

    public void setCondition(ValueType condition) {
        this.ctCondition = condition;
    }

    public void setCommand(Command command) {
        this.cCommand = command;
    }

    public void setElseCommand(ElseCommand elsecommand) {
        this.ecElse = elsecommand;
    }

    public ValueType getCondition() {
        return this.ctCondition;
    }

    public Command getCommand() {
        return this.cCommand;
    }

    public ElseCommand getElseCommand() {
        return this.ecElse;
    }

    public ValueType execute(EnvironmentSmall env) {
        if (this.ctCondition != null && this.cCommand != null) {
            Value v = this.ctCondition.getValue(env);
            if (v != null && v.getBoolean()) {
                env.executeCommand(this.cCommand);
            } else if (this.ecElse != null) {
                this.ecElse.execute(env);
            }
        }
        return null;
    }

    protected void executionOutput() {
        this.sBuf.append("if ");
        this.sBuf.append(this.ctCondition.string);
    }

    public String toX10GIMLI(int depth) {
        this.prepareOutputDepth(depth);
        this.sBuf.append("if ");
        this.sBuf.append(this.ctCondition.toX10GIMLI());
        this.sBuf.append(" then\n");
        this.sBuf.append(this.cCommand.toX10GIMLI(depth + 1));
        if (this.ecElse != null) {
            this.sBuf.append(this.ecElse.toX10GIMLI(depth));
        }
        return this.sBuf.toString();
    }
}

