/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli;

import X10Gimli.Interface.Gateway.LocalDebugGateway;
import X10Gimli.Interface.OutputListener;
import X10Gimli.System.Packet.Packet;
import X10Gimli.System.Packet.X10gimliPacket;
import X10Gimli.Value.ValueDate;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueTime;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Vector;

public class Debug {
    private static StringBuffer sbuf = new StringBuffer();
    private static PrintStream masterstream = System.out;
    private static PrintStream systemstream = null;
    private static PrintStream errorstream = null;
    private static PrintStream userstream = null;
    private static PrintStream executionstream = null;
    private static int iCounter = 1;
    private static StringBuffer sTemp = new StringBuffer(10);
    private static String sToday = "";
    private static String sNow = "";
    private static String sDateTime = "";
    private static Calendar cToday;
    private static int lastSeconds;
    private static long lastMillis;
    private static Vector vOutputGateways;
    public static final int ERROR_INVALID_PARAM_COUNT = 100;
    public static final int ERROR_INCOMPATIBLE_TYPE_COMPARISON = 101;
    public static final int ERROR_INCOMPATIBLE_TYPE_ARITHMETIC = 102;
    public static final int ERROR_INCOMPATIBLE_TYPE_PARAMETER = 103;
    public static final int ERROR_NO_VALUE = 104;
    public static final int ERROR_INVALID_TYPE_LVALUE = 105;
    public static final int ERROR_PACKET_LIST_LENGTHS = 106;
    public static final int ERROR_INVALID_PARAM_VALUE = 107;
    public static final int ERROR_UNKNOWN_IDENTIFIER = 108;
    public static final int ERROR_OUT_OF_BOUNDS = 109;
    public static final int ERROR_INCORRECT_SYNTAX = 200;
    public static final int ERROR_INVALID_TOKEN = 201;
    public static final int ERROR_NATIVE_LINK = 300;
    public static final int ERROR_TIMEOUT = 301;
    public static final int ERROR_CONNECTION_FAILURE = 302;
    public static final int ERROR_INITIALIZE_INTERFACE = 303;
    public static final int ERROR_FILE_NOT_FOUND = 304;
    public static final int LOG_MASTER = 0;
    public static final int LOG_SYSTEM = 1;
    public static final int LOG_ERROR = 2;
    public static final int LOG_USER = 3;
    public static final int LOG_EXECUTION = 4;
    private static int levelFlags;

    public static synchronized void addOutputListener(LocalDebugGateway l) {
        if (!vOutputGateways.contains(l)) {
            vOutputGateways.addElement(l);
        }
    }

    public static synchronized void removeOutputListener(OutputListener l) {
        vOutputGateways.removeElement(l);
    }

    public static void transmitPacket(Packet packet) {
        int cnt = vOutputGateways.size();
        for (int i = 0; i < cnt; ++i) {
            LocalDebugGateway client = (LocalDebugGateway)vOutputGateways.elementAt(i);
            client.transmitDebug(packet);
        }
    }

    public static boolean yesLevel(int i) {
        return (levelFlags & 1 << i) != 0;
    }

    public static void onYesLevel(int i) {
        if (!Debug.yesLevel(i)) {
            levelFlags |= 1 << i;
        }
    }

    public static void offYesLevel(int i) {
        if (Debug.yesLevel(i)) {
            levelFlags -= 1 << i;
        }
    }

    public static String logName(int l) {
        switch (l) {
            case 1: {
                return "System";
            }
            case 3: {
                return "User";
            }
            case 4: {
                return "Execution";
            }
            case 2: {
                return "Error";
            }
            case 0: {
                return "Master";
            }
        }
        return "generic";
    }

    public static void toggleYesLevel(int i) {
        if (Debug.yesLevel(i)) {
            Debug.log(i, String.valueOf(String.valueOf(new StringBuffer("Toggling ").append(Debug.logName(i)).append(" log output off..."))));
            Debug.offYesLevel(i);
        } else {
            Debug.onYesLevel(i);
            Debug.log(i, String.valueOf(String.valueOf(new StringBuffer("Toggling ").append(Debug.logName(i)).append(" log output on..."))));
        }
    }

    public static void setLogLevel(int i) {
        levelFlags = i;
    }

    public static String hexByte(byte val) {
        String s = Debug.hex(val & 0xFF);
        while (s.length() < 2) {
            s = "0".concat(String.valueOf(String.valueOf(s)));
        }
        return s;
    }

    public static synchronized String hex(int val) {
        sbuf.setLength(0);
        String next = "";
        while (val != 0) {
            int chunk = val & 0xF;
            val >>>= 4;
            switch (chunk) {
                case 0: {
                    next = "0";
                    break;
                }
                case 1: {
                    next = "1";
                    break;
                }
                case 2: {
                    next = "2";
                    break;
                }
                case 3: {
                    next = "3";
                    break;
                }
                case 4: {
                    next = "4";
                    break;
                }
                case 5: {
                    next = "5";
                    break;
                }
                case 6: {
                    next = "6";
                    break;
                }
                case 7: {
                    next = "7";
                    break;
                }
                case 8: {
                    next = "8";
                    break;
                }
                case 9: {
                    next = "9";
                    break;
                }
                case 10: {
                    next = "A";
                    break;
                }
                case 11: {
                    next = "B";
                    break;
                }
                case 12: {
                    next = "C";
                    break;
                }
                case 13: {
                    next = "D";
                    break;
                }
                case 14: {
                    next = "E";
                    break;
                }
                case 15: {
                    next = "F";
                }
            }
            sbuf.append(next);
        }
        return sbuf.toString();
    }

    public static synchronized void log(int type, String s) {
        if (s != null && Debug.yesLevel(type)) {
            sbuf.setLength(0);
            long millis = System.currentTimeMillis();
            if (millis - lastMillis > (long)1000) {
                Calendar c = Calendar.getInstance();
                if (cToday.get(5) != c.get(5)) {
                    sTemp.setLength(0);
                    sTemp.append(c.get(2) + 1);
                    sTemp.append("/");
                    sTemp.append(c.get(5));
                    sTemp.append("/");
                    sTemp.append(c.get(1));
                    sTemp.append(" ");
                    sToday = sTemp.toString();
                }
                if (cToday.get(12) != c.get(12)) {
                    sTemp.setLength(0);
                    sTemp.append(c.get(11));
                    sTemp.append(":");
                    if (c.get(12) < 10) {
                        sTemp.append("0");
                    }
                    sTemp.append(c.get(12));
                    sTemp.append(":");
                    sNow = sTemp.toString();
                    sTemp.insert(0, sToday);
                    sDateTime = sTemp.toString();
                }
                cToday = c;
                lastSeconds = c.get(13);
                lastMillis = millis;
            }
            sbuf.append(sDateTime);
            if (lastSeconds < 10) {
                sbuf.append("0");
            }
            sbuf.append(lastSeconds);
            sbuf.append(" [");
            sbuf.append(iCounter);
            sbuf.append("] : ");
            sbuf.append(s);
            ++iCounter;
            switch (type) {
                case 1: {
                    if (systemstream == null) break;
                    systemstream.println(sbuf.toString());
                    break;
                }
                case 2: {
                    if (errorstream == null) break;
                    errorstream.println(sbuf.toString());
                    break;
                }
                case 3: {
                    if (userstream == null) break;
                    userstream.println(sbuf.toString());
                    break;
                }
                case 4: {
                    if (executionstream == null) break;
                    executionstream.println(sbuf.toString());
                }
            }
            if (masterstream != null) {
                masterstream.println(sbuf.toString());
            }
            Debug.transmitPacket(X10gimliPacket.logmessage(new ValueNumber(type), new ValueString(sbuf.toString()), new ValueDate(Calendar.getInstance()), new ValueTime(Calendar.getInstance())));
        }
    }

    public static void error(String s) {
        Debug.error(0, s);
    }

    public static synchronized void error(int type, String s) {
        if (Debug.yesLevel(2)) {
            sbuf.setLength(0);
            sbuf.append("E");
            sbuf.append(type);
            sbuf.append(": ");
            sbuf.append(s);
            Debug.log(2, sbuf.toString());
        }
    }

    public static void generateCallStack(String message) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            if (errorstream != null && Debug.yesLevel(2)) {
                StringWriter sw = new StringWriter(1000);
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                System.out.println(sw.toString());
                Debug.log(2, String.valueOf(String.valueOf(new StringBuffer("Stack trace : ").append(message).append("\n").append(sw.toString()))));
            }
            System.out.println("Stack trace : ".concat(String.valueOf(String.valueOf(message))));
            e.printStackTrace();
            return;
        }
    }

    public static void printCallStack(Exception e) {
        Debug.printCallStack("Exception.", e);
    }

    public static void printCallStack(String message, Exception e) {
        if (errorstream != null && Debug.yesLevel(2)) {
            StringWriter sw = new StringWriter(1000);
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Debug.log(2, String.valueOf(String.valueOf(new StringBuffer("Stack trace : ").append(message).append("\n\n").append(sw.toString()))));
        }
        System.out.println("Stack trace : ".concat(String.valueOf(String.valueOf(message))));
        e.printStackTrace();
    }

    public static void setLogFile(int log, String file) {
        if (file != null && file.length() > 0) {
            try {
                String logstring = String.valueOf(String.valueOf(new StringBuffer("\r\n====================================================\r\nOpening log file ").append(file).append("...\r\n====================================================")));
                switch (log) {
                    case 0: {
                        masterstream = new PrintStream(new FileOutputStream(file, true));
                        masterstream.println(logstring);
                        break;
                    }
                    case 1: {
                        systemstream = new PrintStream(new FileOutputStream(file, true));
                        systemstream.println(logstring);
                        break;
                    }
                    case 3: {
                        userstream = new PrintStream(new FileOutputStream(file, true));
                        userstream.println(logstring);
                        break;
                    }
                    case 4: {
                        executionstream = new PrintStream(new FileOutputStream(file, true));
                        executionstream.println(logstring);
                        break;
                    }
                    case 2: {
                        errorstream = new PrintStream(new FileOutputStream(file, true));
                        errorstream.println(logstring);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        lastMillis = 0L;
        cToday = Calendar.getInstance();
        cToday.add(5, -1);
        cToday.add(12, -5);
        vOutputGateways = new Vector();
        ERROR_INVALID_PARAM_COUNT = 100;
        ERROR_INCOMPATIBLE_TYPE_COMPARISON = 101;
        ERROR_INCOMPATIBLE_TYPE_ARITHMETIC = 102;
        ERROR_INCOMPATIBLE_TYPE_PARAMETER = 103;
        ERROR_NO_VALUE = 104;
        ERROR_INVALID_TYPE_LVALUE = 105;
        ERROR_PACKET_LIST_LENGTHS = 106;
        ERROR_INVALID_PARAM_VALUE = 107;
        ERROR_UNKNOWN_IDENTIFIER = 108;
        ERROR_OUT_OF_BOUNDS = 109;
        ERROR_INCORRECT_SYNTAX = 200;
        ERROR_INVALID_TOKEN = 201;
        ERROR_NATIVE_LINK = 300;
        ERROR_TIMEOUT = 301;
        ERROR_CONNECTION_FAILURE = 302;
        ERROR_INITIALIZE_INTERFACE = 303;
        ERROR_FILE_NOT_FOUND = 304;
        LOG_MASTER = 0;
        LOG_SYSTEM = 1;
        LOG_ERROR = 2;
        LOG_USER = 3;
        LOG_EXECUTION = 4;
        levelFlags = 1;
    }
}

