/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.GUI;

import X10Gimli.GUI.BasicGUIPanel;
import X10Gimli.System.Packet.Packet;
import X10Gimli.System.Packet.X10gimliPacket;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogPanel
extends BasicGUIPanel {
    private BorderLayout borderLayout = new BorderLayout();
    private JLabel labelLog = new JLabel();
    private int logType = 0;
    private String logTitle = "Log";
    private JScrollPane scrollpaneLog = new JScrollPane();
    private JButton jbToggle = new JButton();
    JTextArea textareaLog = new JTextArea();

    public LogPanel(String title, int log) {
        try {
            this.logTitle = title;
            this.logType = log;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LogPanel() {
        try {
            this.logType = 0;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setColor(Color c) {
        this.textareaLog.setForeground(c);
    }

    public Color getColor() {
        return this.textareaLog.getForeground();
    }

    public void addText(int log, String text) {
        if (log == this.logType || this.logType == 0 && log < 100) {
            this.textareaLog.append(text);
            this.textareaLog.setCaretPosition(this.textareaLog.getText().length());
        }
    }

    public void setTitle(String title) {
        this.logTitle = title;
        this.labelLog.setText(this.logTitle);
    }

    public String getTitle() {
        return this.logTitle;
    }

    public int getLogType() {
        return this.logType;
    }

    private void jbInit() throws Exception {
        this.labelLog.setHorizontalAlignment(0);
        this.labelLog.setText(this.logTitle);
        this.setLayout(this.borderLayout);
        this.scrollpaneLog.setAutoscrolls(true);
        this.jbToggle.setText("Toggle Log On/Off");
        this.jbToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                X10gimliPacket p = new X10gimliPacket(new ValueString("LOG_TOGGLE"));
                p.addSegment("LOG", new ValueNumber(LogPanel.this.getLogType()));
                LogPanel.this.transmitPacket(p);
            }
        });
        this.textareaLog.setBorder(BorderFactory.createLineBorder(Color.black));
        this.textareaLog.setEditable(false);
        this.textareaLog.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)this.labelLog, "North");
        this.add((Component)this.scrollpaneLog, "Center");
        this.scrollpaneLog.getViewport().add((Component)this.textareaLog, null);
        this.add((Component)this.jbToggle, "South");
    }

    public void receivePacket(Packet p) {
        if ((p = p.getPacketType()) instanceof X10gimliPacket && p.getValue("COMMAND") != null && p.getValue("COMMAND").getValueString().equals("LOGMESSAGE")) {
            if (p.getValue("TYPE") != null) {
                int type = p.getValue("TYPE").getNumber();
                String text = String.valueOf(String.valueOf(p.getValue("TEXT").getString())).concat("\r\n");
                this.addText(type, text);
            }
        } else {
            this.addText(101, String.valueOf(String.valueOf(p.toString())).concat("\r\n"));
        }
    }
}

