/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.GUI;

import X10Gimli.GUI.BasicGUIPanel;
import X10Gimli.GUI.RemoteControlPanel;
import X10Gimli.Interface.BasicGateway;
import X10Gimli.System.Packet.Packet;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueCommand;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueX10;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RemoteControlPanel
extends BasicGUIPanel {
    private Vector buttonList = new Vector();
    private Vector tagList = new Vector();
    private String sType = "REMOTE";
    private int forceRows = 0;
    private int forceColumns = 0;
    private JPanel jPanel = new JPanel();
    private GridLayout gridLayout = new GridLayout();
    private BorderLayout borderLayout = new BorderLayout();
    private JLabel jLabel = new JLabel();

    public RemoteControlPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public RemoteControlPanel(BasicGateway g) {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setGateway(g);
    }

    private void jbInit() throws Exception {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                RemoteControlPanel.this.this_componentResized(e);
            }
        });
        this.setLayout(this.borderLayout);
        this.jPanel.setLayout(this.gridLayout);
        this.jLabel.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel.setText(this.sType);
        this.add((Component)this.jPanel, "Center");
        this.add((Component)this.jLabel, "North");
    }

    public void addButton(Value b) {
        this.addButton(b, "BUTTON");
    }

    public void addButton(ArrayList b, ArrayList t) {
        if (!this.buttonList.contains(b)) {
            this.buttonList.add(b);
            this.tagList.add(t);
        }
        this.renderButtons();
    }

    public void addButton(Value b, String tag) {
        ArrayList<Value> bb = new ArrayList<Value>();
        bb.add(b);
        ArrayList<String> tt = new ArrayList<String>();
        tt.add(tag);
        this.addButton(bb, tt);
    }

    public void resetButtons() {
        this.buttonList = new Vector();
        this.tagList = new Vector();
    }

    public void setButtonsMediaControl() {
        this.forceRows = 6;
        this.forceColumns = 6;
        this.resetButtons();
        this.addButton(new ValueNumber(1), "COMMAND");
        this.addButton(new ValueNumber(2), "COMMAND");
        this.addButton(new ValueNumber(3), "COMMAND");
        this.addButton(new ValueString("TITLE"), "COMMAND");
        this.addButton(new ValueString("UP"), "COMMAND");
        this.addButton(new ValueString("DISPLAY"), "COMMAND");
        this.addButton(new ValueNumber(4), "COMMAND");
        this.addButton(new ValueNumber(5), "COMMAND");
        this.addButton(new ValueNumber(6), "COMMAND");
        this.addButton(new ValueString("LEFT"), "COMMAND");
        this.addButton(new ValueString("MENU"), "COMMAND");
        this.addButton(new ValueString("RIGHT"), "COMMAND");
        this.addButton(new ValueNumber(7), "COMMAND");
        this.addButton(new ValueNumber(8), "COMMAND");
        this.addButton(new ValueNumber(9), "COMMAND");
        this.addButton(new ValueString("SUBTITLE"), "COMMAND");
        this.addButton(new ValueString("DOWN"), "COMMAND");
        this.addButton(new ValueString("EXIT"), "COMMAND");
        this.addButton(new ValueString("AB"), "COMMAND");
        this.addButton(new ValueNumber(0), "COMMAND");
        this.addButton(new ValueString("ENTER"), "COMMAND");
        this.addButton(new ValueString("VOLDOWN"), "COMMAND");
        this.addButton(new ValueString("MUTE"), "COMMAND");
        this.addButton(new ValueString("VOLUP"), "COMMAND");
        this.addButton(new ValueString("RW"), "COMMAND");
        this.addButton(new ValueString("PLAY"), "COMMAND");
        this.addButton(new ValueString("PAUSE"), "COMMAND");
        this.addButton(new ValueString("STOP"), "COMMAND");
        this.addButton(new ValueString("RECORD"), "COMMAND");
        this.addButton(new ValueString("FF"), "COMMAND");
        this.addButton(new ValueString("POWER"), "COMMAND");
        this.addButton(new ValueString("RECALL"), "COMMAND");
        this.addButton(new ValueString("SKIPDOWN"), "COMMAND");
        this.addButton(new ValueString("RETURN"), "COMMAND");
        this.addButton(new ValueString("SKIPUP"), "COMMAND");
    }

    public void setButtonsX10(char housecode, int min, int max) {
        ArrayList<Value> bb = new ArrayList<Value>();
        ArrayList<String> tt = new ArrayList<String>();
        this.forceRows = max - min + 2;
        this.forceColumns = 2;
        this.resetButtons();
        for (int i = min; i <= max; ++i) {
            bb = new ArrayList();
            bb.add(new ValueX10(housecode, i));
            bb.add(new ValueCommand("ON"));
            tt = new ArrayList();
            tt.add("ADDRESS");
            tt.add("COMMAND");
            this.addButton(bb, tt);
            bb = new ArrayList();
            bb.add(new ValueX10(housecode, i));
            bb.add(new ValueCommand("OFF"));
            tt = new ArrayList();
            tt.add("ADDRESS");
            tt.add("COMMAND");
            this.addButton(bb, tt);
        }
        bb = new ArrayList();
        bb.add(new ValueCommand("DIM"));
        bb.add(new ValueX10(housecode, 0));
        bb.add(new ValueNumber(5));
        tt = new ArrayList();
        tt.add("COMMAND");
        tt.add("ADDRESS");
        tt.add("DIMS");
        this.addButton(bb, tt);
        bb = new ArrayList();
        bb.add(new ValueCommand("BRIGHT"));
        bb.add(new ValueX10(housecode, 0));
        bb.add(new ValueNumber(5));
        tt = new ArrayList();
        tt.add("COMMAND");
        tt.add("ADDRESS");
        tt.add("DIMS");
        this.addButton(bb, tt);
    }

    public String getType() {
        return this.sType;
    }

    public void setType(String type) {
        this.sType = type;
        this.jLabel.setText(this.sType);
    }

    private void renderButtons() {
        this.jPanel.removeAll();
        int cells = this.buttonList.size();
        int r1 = (int)Math.ceil(Math.sqrt(cells));
        if (this.forceRows != 0) {
            r1 = this.forceRows;
        }
        if (r1 < 1) {
            r1 = 1;
        }
        int r2 = r1;
        while (r1 * (r2 - 1) >= cells) {
            --r2;
        }
        if (this.forceColumns != 0) {
            r2 = this.forceColumns;
        }
        for (int i = 0; i < cells; ++i) {
            class JButtonSpecial
            extends JButton {
                ArrayList tags;
                ArrayList values;

                JButtonSpecial(String s, ArrayList tags, ArrayList values) {
                    super(s);
                    this.tags = tags;
                    this.values = values;
                }
            }
            JButtonSpecial b = new JButtonSpecial(this.buttonList.get(i).toString(), (ArrayList)this.tagList.get(i), (ArrayList)this.buttonList.get(i));
            b.setFont(new Font("Serif", 0, 10));
            b.setMargin(new Insets(2, 2, 2, 2));
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Packet p = new Packet(((JButtonSpecial)e.getSource()).tags, ((JButtonSpecial)e.getSource()).values);
                    p.setType(RemoteControlPanel.this.sType);
                    RemoteControlPanel.this.transmitPacket(p);
                }
            });
            this.jPanel.add(b);
        }
        this.gridLayout.setColumns(r2);
        this.gridLayout.setRows(r1);
        this.validate();
    }

    private void this_componentResized(ComponentEvent e) {
        this.renderButtons();
    }
}

