/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface;

import X10Gimli.Debug;
import X10Gimli.Interface.BasicGateway;
import X10Gimli.Interface.OutputListener;
import X10Gimli.System.Packet.Packet;
import X10Gimli.X10.X10Queue;
import java.util.Vector;

public abstract class OutputGateway
extends BasicGateway {
    private Vector outputListeners = new Vector();
    protected X10Queue oQueue = new X10Queue(10);

    public synchronized void addOutputListener(OutputListener l) {
        if (!this.outputListeners.contains(l)) {
            this.outputListeners.addElement(l);
        }
    }

    public synchronized void removeOutputListener(OutputListener l) {
        if (this.outputListeners != null) {
            this.outputListeners.removeElement(l);
        }
    }

    private void firePacket(Packet packet) {
        if (packet.getSource().length() == 0) {
            packet.setSource(this.sSource);
        }
        this.sendPacket(packet);
        Vector v = null;
        OutputGateway outputGateway = this;
        synchronized (outputGateway) {
            if (this.outputListeners != null) {
                v = (Vector)this.outputListeners.clone();
            }
        }
        if (v != null) {
            int cnt = v.size();
            for (int i = 0; i < cnt; ++i) {
                OutputListener client = (OutputListener)v.elementAt(i);
                client.transmitPacket(packet);
            }
        }
    }

    protected abstract void sendPacket(Packet var1);

    public void transmitPacket(Packet evt) {
        this.oQueue.put(evt);
    }

    protected void startQueueThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"").append(OutputGateway.this.getName()).append(" queue handler thread started.\""))));
                while (OutputGateway.this.oQueue == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        Debug.printCallStack("Interrupted sleep in output queue handler thread.", e);
                    }
                }
                while (true) {
                    Packet p = (Packet)OutputGateway.this.oQueue.get();
                    OutputGateway.this.firePacket(p);
                }
            }
        });
        t.start();
    }
}

